/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter;

import adapter.configuracoes.eStatusControle;
import adapter.exceptions.AdapterErrorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import rotinas.adapter.Controle;
import rotinas.adapter.SapServiceRunnable;
import rotinas.adapter.config.AdapterComercialDatabase;
import rotinas.adapter.config.AdapterDatabase;
import rotinas.adapter.config.AdapterFinanceiroDatabase;
import rotinas.adapter.config.AdapterRotinasDatabase;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.dao.AdapterDao;
import rotinas.adapter.dao.ComercialDao;
import rotinas.adapter.dao.FinanceiroDao;
import rotinas.adapter.email.EnvioEmailService;

public class IntegracaoSapPagamentoMain {
    public static final Logger LOGGER = Logger.getLogger(IntegracaoSapPagamentoMain.class.getName());
    public static StringWriter sw = new StringWriter();
    public static PrintWriter pw = new PrintWriter(sw);
    private static EnvioEmailService envioEmailService = new EnvioEmailService();

    public static void main(String[] args) throws Exception {
        LocalDateTime inicio = LocalDateTime.now();
        String idControleExecucaoS = null;
        String idFatura = null;
        if (args.length >= 2 && args[0].equals("-1")) {
            idControleExecucaoS = "-1";
            idFatura = args[1];
        } else {
            idControleExecucaoS = args[0];
        }
        Long idControleExecucaoRotina = null;
        Map<String, String> faturasIntegrados = Collections.synchronizedMap(new HashMap());
        Map<String, String> faturasErro = Collections.synchronizedMap(new HashMap());
        LOGGER.info("Inicio do envio de Pagamento para o SAP");
        try {
            try {
                idControleExecucaoRotina = Long.parseLong(idControleExecucaoS);
                Map<String, String> parametros = null;
                if (idControleExecucaoRotina != -1L) {
                    parametros = Controle.getParametrosRotina(idControleExecucaoRotina);
                }
                System.out.println("===================== INICIO ======================");
                AdapterDao adapterDao = new AdapterDao();
                FinanceiroDao financeiroDao = new FinanceiroDao();
                ComercialDao comercialDao = new ComercialDao();
                Configuracoes conf = Configuracoes.getInstance();
                ExecutorService executor = Executors.newFixedThreadPool(Integer.valueOf(conf.getNumeroThreads()));
                Map<String, Object> servidorIntegracao = adapterDao.getServidorIntegracaoSap();
                if (!servidorIntegracao.containsKey("URL") || !servidorIntegracao.containsKey("Porta")) {
                    throw new AdapterErrorException("Dados do servidor de integracao nao encontrados.");
                }
                Long idUsuarioTarefasAutomaticas = Long.parseLong(comercialDao.getConfiguracaoComercialByChave("ID_USUARIO_TAREFAS_AUTOMATICAS"));
                String integraSap = financeiroDao.getConfiguracaoFinanceiroByChave("INTEGRA_PAGAMENTO_SAP");
                if (integraSap == null || integraSap.equals("0")) {
                    throw new AdapterErrorException("Integracao de Pagamentos esta desabilitado.");
                }
                List<Map<String, Object>> listaFaturas = financeiroDao.findPagamentosIntegracao(parametros, idFatura);
                System.out.println("Quantidade de Faturas a serem integradas: " + listaFaturas.size());
                String cardCodeDocumento = comercialDao.getConfiguracaoComercialByChave("CARDCODE_DOCUMENTO_INTEGRACAO_CLIENTES_SAP");
                String idFilialFixo = financeiroDao.getConfiguracaoFinanceiroByChave("IDFILIAL_FIXO_INTEGRACAO_PAGAMENTO_SAP");
                String dataVencimentoIgualPagamento = financeiroDao.getConfiguracaoFinanceiroByChave("DATA_VENCIMENTO_IGUAL_DATA_PAGAMENTO_INTEGRACAO_PAGAMENTO_SAP");
                String idsFormasCobrancaSomaUmDiaPagamento = financeiroDao.getConfiguracaoFinanceiroByChave("IDS_FORMA_COBRANCA_SOMA_UM_DIA_DATA_PAGAMENTO_INTEGRACAO_PAGAMENTO_SAP");
                String verificaNotaFechada = financeiroDao.verificaSeTabelaNotaFechadaExiste();
                ArrayList<Long> idsFormasCobrancaSomamUmDia = null;
                if (idsFormasCobrancaSomaUmDiaPagamento != null && !idsFormasCobrancaSomaUmDiaPagamento.isEmpty()) {
                    idsFormasCobrancaSomamUmDia = new ArrayList<Long>();
                    String[] stringArray = idsFormasCobrancaSomaUmDiaPagamento.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        idsFormasCobrancaSomamUmDia.add(new Long(id));
                        ++n2;
                    }
                }
                for (Map<String, Object> fatura : listaFaturas) {
                    executor.execute(new SapServiceRunnable(fatura, faturasIntegrados, faturasErro, financeiroDao, servidorIntegracao, idUsuarioTarefasAutomaticas, conf, cardCodeDocumento, idFilialFixo, idsFormasCobrancaSomamUmDia, dataVencimentoIgualPagamento, verificaNotaFechada != null && !verificaNotaFechada.isEmpty()));
                }
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                System.out.println("===================== FIM ======================");
                LocalDateTime fim = LocalDateTime.now();
                Duration duration = Duration.between(inicio, fim);
                long tempoResposta = Math.abs(duration.getSeconds());
                Controle.finalizaContreleExecucaoRotina(idControleExecucaoRotina, eStatusControle.FINALIZADO);
                LOGGER.info("============================================> TEMPO TOTAL = " + (double)tempoResposta / 60.0 + " min");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("ERRO = " + e.getMessage());
                if (idControleExecucaoRotina != null) {
                    Controle.finalizaContreleExecucaoRotina(idControleExecucaoRotina, eStatusControle.ERRO);
                }
                envioEmailService.sendRelatorioDeErro(e.getMessage() != null ? e.getMessage() : e.getCause().toString());
                try {
                    if (faturasIntegrados.size() > 0) {
                        envioEmailService.sendRelatorioLogSucesso(faturasIntegrados);
                    }
                    if (faturasErro.size() > 0) {
                        envioEmailService.sendRelatorioLogErro(faturasErro);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                AdapterFinanceiroDatabase.shutdown();
                AdapterRotinasDatabase.shutdown();
                AdapterComercialDatabase.shutdown();
                AdapterDatabase.shutdown();
                System.exit(0);
            }
        }
        finally {
            try {
                if (faturasIntegrados.size() > 0) {
                    envioEmailService.sendRelatorioLogSucesso(faturasIntegrados);
                }
                if (faturasErro.size() > 0) {
                    envioEmailService.sendRelatorioLogErro(faturasErro);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AdapterFinanceiroDatabase.shutdown();
            AdapterRotinasDatabase.shutdown();
            AdapterComercialDatabase.shutdown();
            AdapterDatabase.shutdown();
            System.exit(0);
        }
    }
}

