/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.internal.net.ipclw.mql.Context;
import com.oracle.common.internal.net.ipclw.mql.KeyedMultiBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.LocalQueue;
import com.oracle.common.internal.net.ipclw.mql.MessageQueue;
import com.oracle.common.internal.net.ipclw.mql.MultiInterfaceKeyRegistry;
import com.oracle.common.internal.net.ipclw.mql.RegistrationKey;
import com.oracle.common.internal.net.ipclw.mql.RemoteQueue;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferManagers;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.io.BufferSequenceInputStream;
import com.oracle.common.net.InetAddresses;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NTMQProtocolHandler;
import oracle.net.nt.TcpNTAdapter;

public class MQLNTAdapter
implements NTAdapter,
LocalQueue.ReadCallback {
    int port;
    String host;
    private SocketChannel socketChannel;
    private Selector selector;
    private SelectionKey selectionKey;
    private long connectTimeout;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private AtomicInteger numberOfMessagesReceived = new AtomicInteger(0);
    private ByteBuffer wakeupBuffer = ByteBuffer.allocateDirect(1);
    InetAddress localInetAddress;
    private Context msgqContextForRemoteQueue;
    private LocalQueue localQueue;
    private Context msgqContextForLocalQueue;
    private RemoteQueue remoteQueue;
    private static final BufferManager bufferManager = BufferManagers.getNetworkDirectManager();
    Context.Dependencies.Transport transport = null;
    int busyWait;
    int kernelWait;
    IOException ioExceptionWhileMSGQOp = null;
    Queue<BufferSequence> onMessageBufferList = new LinkedList<BufferSequence>();
    NTMQProtocolHandler ntmqProtocolHandler;
    BufferSequence bufseqMsgToWrite;
    ByteBuffer headerBuffer;
    ByteBuffer headerBufferToWrite;
    ByteBuffer[] ntmqPacketBuffersToWrite = new ByteBuffer[2];
    RegistrationKey[] ntmqPacketRegistrationKeysToWrite = new RegistrationKey[2];
    private static final byte MQL_RC_TRANS = 1;
    private static final int MQL_MAX_MSGSIZE = 65536;
    private static final int MQL_DEFAULT_BUFFER_SPACE = 16;
    ByteBuffer buffer;
    ByteBuffer bufferForDeathDetection = ByteBuffer.allocate(1);
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public BufferManager getBufferManager() {
        return bufferManager;
    }

    public MQLNTAdapter(String string, Properties properties) throws NLException {
        this.socketOptions = properties;
        this.ntmqProtocolHandler = new NTMQProtocolHandler(1, false);
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair2.getAtom();
        if (nVPair3 != null) {
            try {
                this.port = Integer.parseInt(nVPair3.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        String string2 = (String)properties.get(22);
        if (string2 != null) {
            this.transport = Context.Dependencies.Transport.valueOf((String)string2);
        }
        this.busyWait = Integer.parseInt((String)properties.get(23));
        this.kernelWait = Integer.parseInt((String)properties.get(24));
    }

    private MessageQueue.Name readRemoteQueueNameOnLocalQueue() throws IOException {
        ByteBuffer byteBuffer = bufferManager.acquire(256);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.readFromLocalQueue(byteBuffer);
        if (this.ntmqProtocolHandler.isConnectPacket()) {
            ByteBuffer byteBuffer2 = this.ntmqProtocolHandler.getRemoteQueueNameBuffer();
            bufferManager.release(byteBuffer);
            return new MessageQueue.Name(byteBuffer2);
        }
        bufferManager.release(byteBuffer);
        throw new NetException(26, "ConnectPacket was expected");
    }

    private void writeLocalQueueNameOnSocket(LocalQueue localQueue) throws IOException {
        ByteBuffer byteBuffer = bufferManager.acquire(256);
        this.ntmqProtocolHandler.prepareConnectPacket(byteBuffer, null, 65536, ByteOrder.LITTLE_ENDIAN, localQueue);
        ByteBuffer byteBuffer2 = bufferManager.acquire(this.ntmqProtocolHandler.getHeaderPacketSize());
        this.ntmqProtocolHandler.prepareHeaderPacket(byteBuffer2, (byte)1, (byte)1, null);
        ByteBuffer byteBuffer3 = bufferManager.acquire(byteBuffer2.limit() + byteBuffer.limit());
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.put(byteBuffer);
        byteBuffer3.flip();
        this.selectionKey.interestOps(4);
        while (byteBuffer3.hasRemaining()) {
            if (this.selector.select(this.connectTimeout) == 0) {
                throw new NetException(23);
            }
            Set<SelectionKey> set = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                if (selectionKey.isWritable()) {
                    int n2 = this.socketChannel.write(byteBuffer3);
                }
                iterator.remove();
            }
        }
        bufferManager.release(byteBuffer3);
        bufferManager.release(byteBuffer);
        bufferManager.release(byteBuffer2);
    }

    public int readFromLocalQueue(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.clear();
        if (this.headerBuffer == null) {
            this.headerBuffer = bufferManager.acquire(this.ntmqProtocolHandler.getHeaderPacketSize());
        } else {
            this.headerBuffer.clear();
            this.headerBuffer.limit(this.ntmqProtocolHandler.getHeaderPacketSize());
        }
        while (this.onMessageBufferList.size() <= 0) {
            this.readNTMQPacketFromLocalQueue();
        }
        BufferSequence bufferSequence = this.onMessageBufferList.remove();
        BufferSequenceInputStream bufferSequenceInputStream = new BufferSequenceInputStream(bufferSequence);
        bufferSequenceInputStream.read(this.headerBuffer);
        bufferSequenceInputStream.read(byteBuffer);
        this.headerBuffer.flip();
        byteBuffer.flip();
        bufferSequence.dispose();
        this.ntmqProtocolHandler.processNTMQPacket(this.headerBuffer, byteBuffer, bufferManager);
        return byteBuffer.limit();
    }

    public void readNTMQPacketFromLocalQueue() throws IOException {
        int n2 = 0;
        while (this.numberOfMessagesReceived.get() == 0) {
            this.wakeupBuffer.put(0, (byte)0);
            this.ioExceptionWhileMSGQOp = null;
            this.localQueue.getContext().await(n2 == 0 ? this.busyWait : 0, this.kernelWait);
            if (this.ioExceptionWhileMSGQOp != null) {
                throw this.ioExceptionWhileMSGQOp;
            }
            if (this.numberOfMessagesReceived.get() != 0 || n2++ <= 5 || !this.isConnectionDead()) continue;
            this.disconnect();
            throw new NetException(0);
        }
        this.numberOfMessagesReceived.set(0);
    }

    public int writeToRemoteQueue(ByteBuffer byteBuffer) throws IOException {
        this.ioExceptionWhileMSGQOp = null;
        boolean bl = false;
        int n2 = byteBuffer.limit();
        int n3 = this.ntmqProtocolHandler.getHeaderPacketSize();
        if (this.headerBufferToWrite == null || this.headerBufferToWrite.capacity() < n3) {
            this.headerBufferToWrite = bufferManager.acquire(n3);
        } else {
            this.headerBufferToWrite.clear();
            this.headerBufferToWrite.limit(n3);
        }
        this.ntmqProtocolHandler.prepareHeaderPacket(this.headerBufferToWrite, (byte)4, (byte)1, null);
        this.bufseqMsgToWrite = this.initializeBufferSequence(this.headerBufferToWrite, byteBuffer, this.ntmqPacketBuffersToWrite, this.ntmqPacketRegistrationKeysToWrite);
        while (!this.remoteQueue.send(this.bufseqMsgToWrite, (Object)this.bufseqMsgToWrite, 1)) {
            this.remoteQueue.getContext().await(0, Integer.MAX_VALUE);
        }
        while (this.remoteQueue.isWorkPending()) {
            this.ioExceptionWhileMSGQOp = null;
            this.remoteQueue.getContext().await(0, Integer.MAX_VALUE);
            if (this.ioExceptionWhileMSGQOp == null) continue;
            throw this.ioExceptionWhileMSGQOp;
        }
        return n2;
    }

    private BufferSequence initializeBufferSequence(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer[] byteBufferArray, RegistrationKey[] registrationKeyArray) throws IOException {
        byteBufferArray[0] = byteBuffer;
        byteBufferArray[1] = byteBuffer2;
        registrationKeyArray[0] = ((MultiInterfaceKeyRegistry)bufferManager).getRegistry(this.localInetAddress).getKey(byteBufferArray[0]);
        registrationKeyArray[1] = ((MultiInterfaceKeyRegistry)bufferManager).getRegistry(this.localInetAddress).getKey(byteBufferArray[1]);
        KeyedMultiBufferSequence keyedMultiBufferSequence = new KeyedMultiBufferSequence(bufferManager, byteBufferArray, null, registrationKeyArray);
        return keyedMultiBufferSequence;
    }

    @Override
    public void connect() throws IOException {
        SelectionKey selectionKey;
        Object object;
        Context.DefaultDependencies defaultDependencies;
        Object object2;
        String string = (String)this.socketOptions.get(2);
        this.connectTimeout = Integer.parseInt(string);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        InetAddress[] inetAddressArray = InetAddress.getAllByName(this.host);
        if (bl && inetAddressArray.length > 1) {
            inetAddressArray = TcpNTAdapter.getAddressesInCircularOrder(this.host, inetAddressArray);
        }
        int n2 = inetAddressArray.length;
        int n3 = 0;
        Boolean bl2 = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (!bl2.booleanValue()) {
            throw new NetException(20);
        }
        while (true) {
            object2 = inetAddressArray[n3];
            ++n3;
            --n2;
            try {
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(false);
                this.selector = Selector.open();
                this.selectionKey = this.socketChannel.register(this.selector, 8);
                this.socketChannel.connect(new InetSocketAddress((InetAddress)object2, this.port));
                if (this.selector.select(this.connectTimeout) == 0) {
                    throw new NetException(22);
                }
                defaultDependencies = this.selector.selectedKeys();
                object = defaultDependencies.iterator();
                while (object.hasNext()) {
                    selectionKey = object.next();
                    if (selectionKey.isConnectable()) {
                        while (!this.socketChannel.finishConnect()) {
                        }
                    } else {
                        throw new NetException(24);
                    }
                    object.remove();
                }
                this.socket = this.socketChannel.socket();
            }
            catch (IOException iOException) {
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 > 0) continue;
                throw iOException;
                if (n3 < inetAddressArray.length) continue;
            }
            break;
        }
        this.setOption(3, string);
        this.setSocketOptions();
        object2 = (String)this.socketOptions.get(21);
        this.localInetAddress = object2 != null ? InetAddress.getByName((String)object2) : InetAddresses.getLocalHost();
        defaultDependencies = new Context.DefaultDependencies().setInetAddress(this.localInetAddress).setMaximumOutstandingMessageCount(16).setMaximumMessageSizeBytes(65536).setParentContext(((MultiInterfaceKeyRegistry)bufferManager).getRegistry(this.localInetAddress).getContext()).setTransport(Context.Dependencies.Transport.RC).setFlags(4);
        if (this.transport != null) {
            defaultDependencies.setTransport(this.transport);
        }
        this.msgqContextForLocalQueue = new Context((Context.Dependencies)defaultDependencies);
        try {
            this.msgqContextForLocalQueue.open();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.msgqContextForLocalQueue.setWakeupBuffer(this.wakeupBuffer);
        object = new LocalQueue.DefaultDependencies(defaultDependencies, null).setMaximumReceiveMessageCount(16).setInitialReceiveMessageCount(16);
        this.localQueue = this.msgqContextForLocalQueue.openLocalQueue((LocalQueue.Dependencies)object);
        this.localQueue.setReadCallback((LocalQueue.ReadCallback)this);
        try {
            this.localQueue.bind();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.msgqContextForRemoteQueue = new Context((Context.Dependencies)defaultDependencies);
        try {
            this.msgqContextForRemoteQueue.open();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.remoteQueue = this.msgqContextForRemoteQueue.openRemoteQueue();
        object = new RemoteQueue.WriteCallback(){

            public void onCompletion(Object object, IOException iOException) {
                if (iOException != null) {
                    if (MQLNTAdapter.this.ioExceptionWhileMSGQOp != null) {
                        iOException.initCause(MQLNTAdapter.this.ioExceptionWhileMSGQOp);
                    }
                    MQLNTAdapter.this.ioExceptionWhileMSGQOp = iOException;
                }
            }
        };
        this.remoteQueue.setWriteCallback((RemoteQueue.WriteCallback)object);
        this.writeLocalQueueNameOnSocket(this.localQueue);
        selectionKey = this.readRemoteQueueNameOnLocalQueue();
        this.remoteQueue.connect((MessageQueue.Name)selectionKey);
    }

    public void setSocketOptions() throws IOException {
        String string = (String)this.socketOptions.get(0);
        if (string != null) {
            this.setOption(0, string);
        }
        if ((string = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        if (this.remoteQueue != null) {
            try {
                this.remoteQueue.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.remoteQueue = null;
            }
        }
        if (this.socketChannel != null) {
            try {
                this.socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 0: {
                String string = (String)object;
                this.socket.setTcpNoDelay(string.equals("YES"));
                break;
            }
            case 1: {
                String string = (String)object;
                if (!string.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.sockTimeout = Integer.parseInt((String)object);
                this.socket.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        switch (n2) {
            case 1: {
                return "" + this.sockTimeout;
            }
            case 3: {
                return Integer.toString(this.socket.getSoTimeout());
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return null;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.MSGQ;
    }

    public void onMessage(BufferSequence bufferSequence, IOException iOException) {
        this.onMessageBufferList.add(bufferSequence);
        this.numberOfMessagesReceived.incrementAndGet();
        this.wakeupBuffer.put(0, (byte)1);
    }

    private boolean isConnectionDead() throws IOException {
        if (!this.socketChannel.isOpen()) {
            return true;
        }
        if (this.socket.isClosed()) {
            return true;
        }
        if (this.socket.isInputShutdown()) {
            return true;
        }
        if (this.socket.isOutputShutdown()) {
            return true;
        }
        if (this.selector.selectNow() > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                if (selectionKey.isReadable()) {
                    int n2 = this.socketChannel.read(this.bufferForDeathDetection);
                    if (n2 == -1) {
                        return true;
                    }
                    if (n2 > 0) {
                        throw new NetException(24);
                    }
                }
                iterator.remove();
            }
        }
        return false;
    }

    public static final String packetToString(ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        char[] cArray = new char[8];
        int n3 = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            String string = Integer.toHexString(by & 0xFF);
            if ((string = string.toUpperCase()).length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
            cArray[n2] = by > 32 && by < 127 ? (int)by : 46;
            if (++n2 != 8) continue;
            stringBuffer.append('|');
            stringBuffer.append(cArray);
            stringBuffer.append('|');
            stringBuffer.append('\n');
            n2 = 0;
        }
        if (n2 != 0) {
            int n4;
            int n5 = 8 - n2;
            for (n4 = 0; n4 < n5 * 3; ++n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('|');
            stringBuffer.append(cArray, 0, n2);
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('|');
            stringBuffer.append('\n');
        }
        byteBuffer.position(n3);
        return stringBuffer.toString();
    }

    private static String dump(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        char[] cArray = new char[byteBuffer2.limit() * 3];
        int n2 = 0;
        int n3 = 0;
        String string = System.getProperty("line.separator");
        for (int i2 = 0; i2 < byteBuffer2.limit(); ++i2) {
            int n4 = byteBuffer2.get(i2) & 0xFF;
            cArray[i2 * 3] = hexArray[n4 >>> 4];
            cArray[i2 * 3 + 1] = hexArray[n4 & 0xF];
            if (++n2 % 8 == 0) {
                cArray[i2 * 3 + 2 + n3] = 10;
                continue;
            }
            cArray[i2 * 3 + 2] = 32;
        }
        return new String(cArray);
    }
}

