/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AnalyzerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LabelNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.TryCatchBlockNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.VarInsnNode;
import com.newrelic.weave.utils.SynchronizedMethodNode;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.weavepackage.ErrorTrapHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ErrorTrapWeaveMethodsProcessor {
    private final MethodNode trappedMethod;
    private final ClassNode errorTrapHandler;
    private final LabelNode startOfTrapLabelNode;
    private final LabelNode endOfTrapLabelNode;
    private final LabelNode startOfOriginalMethodLabelNode;
    private final LabelNode endOfOriginalMethodLabelNode;

    public static MethodNode writeErrorTrap(MethodNode weaveMethod, ClassNode errorTrapHandler, LabelNode startOfOriginalMethodLabelNode, LabelNode endOfOriginalMethodLabelNode) {
        LabelNode startOfTrap = WeaveUtils.makeLabelNode();
        LabelNode endOfTrap = WeaveUtils.makeLabelNode();
        weaveMethod.instructions.insert(startOfTrap);
        weaveMethod.instructions.add(endOfTrap);
        ErrorTrapWeaveMethodsProcessor trapper = new ErrorTrapWeaveMethodsProcessor(weaveMethod, errorTrapHandler, startOfTrap, endOfTrap, startOfOriginalMethodLabelNode, endOfOriginalMethodLabelNode);
        return trapper.process();
    }

    public ErrorTrapWeaveMethodsProcessor(MethodNode weaveMethod, ClassNode errorTrapHandler, LabelNode startOfTrapLabelNode, LabelNode endOfTrapLabelNode, LabelNode startOfOriginalMethodLabelNode, LabelNode endOfOriginalMethodLabelNode) {
        this.trappedMethod = weaveMethod;
        this.errorTrapHandler = errorTrapHandler;
        this.startOfTrapLabelNode = startOfTrapLabelNode;
        this.endOfTrapLabelNode = endOfTrapLabelNode;
        this.startOfOriginalMethodLabelNode = startOfOriginalMethodLabelNode;
        this.endOfOriginalMethodLabelNode = endOfOriginalMethodLabelNode;
    }

    public ErrorTrapWeaveMethodsProcessor(MethodNode weaveMethod, ClassNode errorTrapHandler, LabelNode startOfTrapLabelNode, LabelNode endOfTrapLabelNode) {
        this(weaveMethod, errorTrapHandler, startOfTrapLabelNode, endOfTrapLabelNode, null, null);
    }

    public MethodNode process() {
        if (this.errorTrapHandler == ErrorTrapHandler.NO_ERROR_TRAP_HANDLER) {
            return this.trappedMethod;
        }
        Type originalReturnType = Type.getReturnType(this.trappedMethod.desc);
        boolean isVoid = originalReturnType.equals(Type.VOID_TYPE);
        if (!(null != this.startOfOriginalMethodLabelNode && null != this.endOfOriginalMethodLabelNode || isVoid)) {
            return this.trappedMethod;
        }
        ArrayList<TryCatchBlockNode> priorityTryCatch = new ArrayList<TryCatchBlockNode>();
        if (null != this.trappedMethod.tryCatchBlocks) {
            priorityTryCatch.addAll(this.trappedMethod.tryCatchBlocks);
        }
        SynchronizedMethodNode generatorMethod = new SynchronizedMethodNode(458752);
        GeneratorAdapter generator = new GeneratorAdapter(this.trappedMethod.access, new Method(this.trappedMethod.name, this.trappedMethod.desc), (MethodVisitor)generatorMethod);
        LocalVariableNode weaveExplicitThrow = null;
        if (ErrorTrapWeaveMethodsProcessor.isThrowCalled(this.trappedMethod)) {
            weaveExplicitThrow = new LocalVariableNode("weaveExplicitThrow", Type.getDescriptor(Throwable.class), null, this.startOfTrapLabelNode, this.endOfTrapLabelNode, ErrorTrapWeaveMethodsProcessor.findIndexForNewLocal(this.trappedMethod));
            ++this.trappedMethod.maxLocals;
            generator.push((String)null);
            generator.storeLocal(weaveExplicitThrow.index, Type.getType(Throwable.class));
            this.trappedMethod.visitLocalVariable(weaveExplicitThrow.name, weaveExplicitThrow.desc, weaveExplicitThrow.signature, weaveExplicitThrow.start.getLabel(), weaveExplicitThrow.end.getLabel(), weaveExplicitThrow.index);
            ErrorTrapWeaveMethodsProcessor.storeExceptionAtThrowSites(this.trappedMethod, weaveExplicitThrow.index);
            this.trappedMethod.instructions.insertBefore((AbstractInsnNode)this.startOfTrapLabelNode, generatorMethod.instructions);
        }
        if (null == this.startOfOriginalMethodLabelNode || null == this.endOfOriginalMethodLabelNode) {
            generator.goTo(this.endOfTrapLabelNode.getLabel());
            Label handler = new Label();
            generator.visitLabel(handler);
            if (null != weaveExplicitThrow) {
                ErrorTrapWeaveMethodsProcessor.writeRethrowExplicitThrow(generator, weaveExplicitThrow);
            }
            this.writeHandler(generator, this.errorTrapHandler);
            this.trappedMethod.instructions.insertBefore((AbstractInsnNode)this.endOfTrapLabelNode, generatorMethod.instructions);
            this.trappedMethod.visitTryCatchBlock(this.startOfTrapLabelNode.getLabel(), handler, handler, Type.getInternalName(Throwable.class));
        } else {
            LocalVariableNode weaveOriginalReturnValue = null;
            LabelNode localsStart = WeaveUtils.makeLabelNode();
            this.trappedMethod.instructions.insert(localsStart);
            this.initializePreambleLocals(this.trappedMethod, this.startOfOriginalMethodLabelNode, localsStart);
            if (!isVoid) {
                weaveOriginalReturnValue = new LocalVariableNode("weaveOriginalReturnValue", originalReturnType.getDescriptor(), null, this.startOfTrapLabelNode, this.endOfTrapLabelNode, ErrorTrapWeaveMethodsProcessor.findIndexForNewLocal(this.trappedMethod));
                ++this.trappedMethod.maxLocals;
                this.trappedMethod.visitLocalVariable(weaveOriginalReturnValue.name, weaveOriginalReturnValue.desc, weaveOriginalReturnValue.signature, weaveOriginalReturnValue.start.getLabel(), weaveOriginalReturnValue.end.getLabel(), weaveOriginalReturnValue.index);
                ErrorTrapWeaveMethodsProcessor.storeOriginalReturnValue(generatorMethod, generator, this.trappedMethod, this.startOfOriginalMethodLabelNode, this.endOfOriginalMethodLabelNode, weaveOriginalReturnValue);
            }
            LocalVariableNode weaveThrowableWasThrown = new LocalVariableNode("weaveThrowableWasThrown", Type.BOOLEAN_TYPE.getDescriptor(), null, this.startOfTrapLabelNode, this.endOfTrapLabelNode, ErrorTrapWeaveMethodsProcessor.findIndexForNewLocal(this.trappedMethod));
            ++this.trappedMethod.maxLocals;
            this.trappedMethod.visitLocalVariable(weaveThrowableWasThrown.name, weaveThrowableWasThrown.desc, weaveThrowableWasThrown.signature, weaveThrowableWasThrown.start.getLabel(), weaveThrowableWasThrown.end.getLabel(), weaveThrowableWasThrown.index);
            ErrorTrapWeaveMethodsProcessor.writeStoreInitialValue(generator, weaveThrowableWasThrown);
            if (!isVoid) {
                ErrorTrapWeaveMethodsProcessor.writeStoreInitialValue(generator, weaveOriginalReturnValue);
            }
            this.trappedMethod.instructions.insertBefore((AbstractInsnNode)this.startOfTrapLabelNode, generatorMethod.instructions);
            generator.goTo(this.startOfOriginalMethodLabelNode.getLabel());
            Label preambleHandler = new Label();
            generator.visitLabel(preambleHandler);
            if (null != weaveExplicitThrow) {
                ErrorTrapWeaveMethodsProcessor.writeRethrowExplicitThrow(generator, weaveExplicitThrow);
            }
            this.writeHandler(generator, this.errorTrapHandler);
            generator.push(true);
            generator.storeLocal(weaveThrowableWasThrown.index, Type.BOOLEAN_TYPE);
            this.trappedMethod.instructions.insertBefore((AbstractInsnNode)this.startOfOriginalMethodLabelNode, generatorMethod.instructions);
            this.trappedMethod.visitTryCatchBlock(this.startOfTrapLabelNode.getLabel(), preambleHandler, preambleHandler, Type.getInternalName(Throwable.class));
            LabelNode continueMethod = WeaveUtils.makeLabelNode();
            generator.push(false);
            generator.loadLocal(weaveThrowableWasThrown.index);
            generator.ifICmp(153, continueMethod.getLabel());
            if (isVoid) {
                generator.visitInsn(177);
            } else {
                generator.loadLocal(weaveOriginalReturnValue.index);
                generator.returnValue();
            }
            generator.visitLabel(continueMethod.getLabel());
            this.trappedMethod.instructions.insertBefore((AbstractInsnNode)this.endOfOriginalMethodLabelNode, generatorMethod.instructions);
            Label postambleHandler = new Label();
            generator.visitLabel(postambleHandler);
            if (null != weaveExplicitThrow) {
                ErrorTrapWeaveMethodsProcessor.writeRethrowExplicitThrow(generator, weaveExplicitThrow);
            }
            this.writeHandler(generator, this.errorTrapHandler);
            if (isVoid) {
                generator.visitInsn(177);
            } else {
                generator.loadLocal(weaveOriginalReturnValue.index);
                generator.returnValue();
            }
            this.trappedMethod.instructions.insertBefore((AbstractInsnNode)this.endOfTrapLabelNode, generatorMethod.instructions);
            this.trappedMethod.visitTryCatchBlock(this.endOfOriginalMethodLabelNode.getLabel(), postambleHandler, postambleHandler, Type.getInternalName(Throwable.class));
        }
        if (this.trappedMethod.tryCatchBlocks != null && priorityTryCatch.size() > 0) {
            ErrorTrapWeaveMethodsProcessor.sortTryCatchBlocks(this.trappedMethod, priorityTryCatch);
        }
        this.trappedMethod.instructions.resetLabels();
        return this.trappedMethod;
    }

    private static int findIndexForNewLocal(MethodNode method) {
        return 2 * method.maxLocals;
    }

    private static boolean isThrowCalled(MethodNode methodNode) {
        for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
            if (191 != insnNode.getOpcode()) continue;
            return true;
        }
        return false;
    }

    private static void storeExceptionAtThrowSites(MethodNode methodNode, int rethrowExceptionIndex) {
        for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
            if (191 != insnNode.getOpcode()) continue;
            methodNode.instructions.insertBefore(insnNode, new VarInsnNode(58, rethrowExceptionIndex));
            methodNode.instructions.insertBefore(insnNode, new VarInsnNode(25, rethrowExceptionIndex));
        }
    }

    private static void writeRethrowExplicitThrow(GeneratorAdapter generator, LocalVariableNode weaveExplicitThrow) {
        Label trapStart = new Label();
        generator.loadLocal(weaveExplicitThrow.index);
        generator.ifNull(trapStart);
        generator.throwException();
        generator.visitLabel(trapStart);
    }

    private static void writeStoreInitialValue(GeneratorAdapter generator, LocalVariableNode local) {
        Type type = Type.getType(local.desc);
        switch (type.getSort()) {
            case 9: 
            case 10: {
                generator.push((String)null);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                generator.push(false);
                break;
            }
            case 5: {
                generator.push(0);
                break;
            }
            case 7: {
                generator.push(0L);
                break;
            }
            case 6: {
                generator.push(0.0f);
                break;
            }
            case 8: {
                generator.push(0.0);
            }
        }
        generator.storeLocal(local.index, type);
    }

    private static int getNewOriginalInsertPoint(MethodNode methodNode, LabelNode startOfOriginalMethodLabelNode) {
        AnalyzerAdapter stackAnalyzer = new AnalyzerAdapter("DoesNotMatter", methodNode.access, methodNode.name, methodNode.desc, new MethodVisitor(458752){});
        int lastStackZeroIndex = 0;
        AbstractInsnNode[] inst = methodNode.instructions.toArray();
        for (int instructionIndex = 0; instructionIndex < inst.length; ++instructionIndex) {
            int stackSize;
            int n = stackSize = stackAnalyzer.stack == null ? 0 : stackAnalyzer.stack.size();
            if (stackSize == 0) {
                lastStackZeroIndex = instructionIndex;
            }
            inst[instructionIndex].accept(stackAnalyzer);
            if (inst[instructionIndex] != startOfOriginalMethodLabelNode) continue;
            if (stackSize > 0) {
                return lastStackZeroIndex;
            }
            return -1;
        }
        return -1;
    }

    private static void storeOriginalReturnValue(MethodNode generatorMethod, GeneratorAdapter generator, MethodNode methodNode, LabelNode startOfOriginalMethodLabelNode, LabelNode endOfOriginalMethodLabelNode, LocalVariableNode localToStoreIn) {
        Type originalReturnType = Type.getReturnType(methodNode.desc);
        Label localStore = new Label();
        generator.visitLabel(localStore);
        generator.storeLocal(localToStoreIn.index, originalReturnType);
        methodNode.instructions.insertBefore((AbstractInsnNode)endOfOriginalMethodLabelNode, generatorMethod.instructions);
        generator.loadLocal(localToStoreIn.index, originalReturnType);
        methodNode.instructions.insert((AbstractInsnNode)endOfOriginalMethodLabelNode, generatorMethod.instructions);
        int newOriginalInsertPoint = ErrorTrapWeaveMethodsProcessor.getNewOriginalInsertPoint(methodNode, startOfOriginalMethodLabelNode);
        if (newOriginalInsertPoint >= 0) {
            AbstractInsnNode insertPoint = methodNode.instructions.get(newOriginalInsertPoint);
            AbstractInsnNode current = startOfOriginalMethodLabelNode;
            AbstractInsnNode next = null;
            AbstractInsnNode stop = endOfOriginalMethodLabelNode.getNext();
            while (current != stop) {
                next = current.getNext();
                methodNode.instructions.remove(current);
                generatorMethod.instructions.add(current);
                current = next;
            }
            methodNode.instructions.insertBefore(insertPoint, generatorMethod.instructions);
        }
    }

    private void writeHandler(GeneratorAdapter generator, ClassNode handler) {
        generator.visitMethodInsn(184, handler.name, "onWeaverThrow", "(Ljava/lang/Throwable;)V", false);
    }

    private void initializePreambleLocals(MethodNode method, LabelNode startOfOriginalMethodLabelNode, LabelNode localsStart) {
        List<LocalVariableNode> localsInPreamble = this.getLocalsInPreamble(method, startOfOriginalMethodLabelNode);
        if (!localsInPreamble.isEmpty()) {
            Type[] argumentTypes = Type.getArgumentTypes(method.desc);
            int firstLocalIndex = (8 & method.access) == 0 ? 1 : 0;
            for (int i = 0; i < argumentTypes.length; ++i) {
                firstLocalIndex += argumentTypes[i].getSize();
            }
            for (LocalVariableNode local : localsInPreamble) {
                if (local.index < firstLocalIndex) continue;
                ErrorTrapWeaveMethodsProcessor.changeLocalVariableScopeStart(method, local, localsStart);
            }
        }
    }

    private List<LocalVariableNode> getLocalsInPreamble(MethodNode method, AbstractInsnNode insertPoint) {
        int insertPointIndex = method.instructions.indexOf(insertPoint);
        if (insertPointIndex < 0) {
            return Collections.emptyList();
        }
        ArrayList<LocalVariableNode> locals = Lists.newArrayList();
        for (LocalVariableNode local : method.localVariables) {
            int startIndex = method.instructions.indexOf(local.start);
            int end = method.instructions.indexOf(local.end);
            if (startIndex > insertPointIndex || insertPointIndex >= end) continue;
            locals.add(local);
        }
        return locals;
    }

    private static void changeLocalVariableScopeStart(MethodNode method, LocalVariableNode local, LabelNode newStart) {
        AbstractInsnNode initialValue;
        Type type = Type.getType(local.desc);
        local.start = newStart;
        List<LocalVariableNode> collidingLocals = ErrorTrapWeaveMethodsProcessor.getCollidingVariables(local, method.localVariables);
        if (!collidingLocals.isEmpty()) {
            int newIndex = ErrorTrapWeaveMethodsProcessor.findIndexForNewLocal(method);
            ++method.maxLocals;
            for (LocalVariableNode collidingLocal : collidingLocals) {
                collidingLocal.index = newIndex;
                ErrorTrapWeaveMethodsProcessor.changeLocalSlot(local.index, newIndex, collidingLocal.start, collidingLocal.end);
            }
        }
        if ((initialValue = ErrorTrapWeaveMethodsProcessor.getInitialValueInstruction(type)) != null) {
            method.instructions.insert((AbstractInsnNode)newStart, new VarInsnNode(type.getOpcode(54), local.index));
            method.instructions.insert((AbstractInsnNode)newStart, initialValue);
        }
    }

    private static List<LocalVariableNode> getCollidingVariables(LocalVariableNode local, List<LocalVariableNode> otherLocals) {
        ArrayList<LocalVariableNode> collisions = new ArrayList<LocalVariableNode>();
        for (LocalVariableNode otherLocal : otherLocals) {
            if (local.name.equals(otherLocal.name) && local.desc.equals(otherLocal.desc) || !ErrorTrapWeaveMethodsProcessor.shareSlot(local, otherLocal) || !ErrorTrapWeaveMethodsProcessor.scopesOverlap(local, otherLocal)) continue;
            collisions.add(otherLocal);
        }
        return collisions;
    }

    private static AbstractInsnNode getInitialValueInstruction(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return new InsnNode(1);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new InsnNode(3);
            }
            case 7: {
                return new InsnNode(9);
            }
            case 6: {
                return new InsnNode(11);
            }
            case 8: {
                return new InsnNode(14);
            }
        }
        return null;
    }

    private static boolean shareSlot(LocalVariableNode local, LocalVariableNode otherLocal) {
        return local.index == otherLocal.index;
    }

    private static boolean scopesOverlap(LocalVariableNode local, LocalVariableNode otherLocal) {
        return ErrorTrapWeaveMethodsProcessor.scopeContainsAnyPartOf(local, otherLocal) || ErrorTrapWeaveMethodsProcessor.scopeContainsAnyPartOf(otherLocal, local);
    }

    private static boolean scopeContainsAnyPartOf(LocalVariableNode local, LocalVariableNode otherLocal) {
        for (AbstractInsnNode currentNode = local.start; currentNode != null && !currentNode.equals(local.end); currentNode = currentNode.getNext()) {
            if (currentNode.equals(otherLocal.start)) {
                return true;
            }
            if (!currentNode.equals(otherLocal.end)) continue;
            return !currentNode.equals(local.start);
        }
        return false;
    }

    private static void changeLocalSlot(int oldSlot, int newSlot, LabelNode start, LabelNode end) {
        AbstractInsnNode currentNode;
        AbstractInsnNode abstractInsnNode = currentNode = null == start.getPrevious() ? start : start.getPrevious();
        while (null != currentNode && !currentNode.equals(end)) {
            if (currentNode.getType() == 2) {
                VarInsnNode currentInsn = (VarInsnNode)currentNode;
                if (currentInsn.var == oldSlot) {
                    currentInsn.var = newSlot;
                }
            }
            currentNode = currentNode.getNext();
        }
    }

    public static void sortTryCatchBlocks(final MethodNode trappedMethod, final List<TryCatchBlockNode> priorityTryCatch) {
        Comparator<TryCatchBlockNode> comp = new Comparator<TryCatchBlockNode>(){

            @Override
            public int compare(TryCatchBlockNode t1, TryCatchBlockNode t2) {
                boolean isT1Priority = priorityTryCatch.contains(t1);
                boolean isT2Priority = priorityTryCatch.contains(t2);
                if (isT1Priority && isT2Priority) {
                    return trappedMethod.instructions.indexOf(t2.start) - trappedMethod.instructions.indexOf(t1.start);
                }
                if (isT1Priority) {
                    return -1;
                }
                if (isT2Priority) {
                    return 1;
                }
                return trappedMethod.instructions.indexOf(t2.start) - trappedMethod.instructions.indexOf(t1.start);
            }
        };
        Collections.sort(trappedMethod.tryCatchBlocks, comp);
        for (int i = 0; i < trappedMethod.tryCatchBlocks.size(); ++i) {
            trappedMethod.tryCatchBlocks.get(i).updateIndex(i);
        }
    }
}

