/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.config.JavaVersionUtils;
import com.newrelic.bootstrap.BootstrapLoader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BootstrapAgent {
    public static final String AGENT_CLASS_NAME = "com.newrelic.agent.Agent";
    private static final String WS_SERVER_JAR = "ws-server.jar";
    private static final String WS_LOG_MANAGER = "com.ibm.ws.kernel.boot.logging.WsLogManager";
    private static final String IBM_VENDOR = "IBM";
    private static final String JDK_INTERNAL_LOADER = "jdk.internal.loader";
    private static final String JAVA_LANG = "java.lang";

    public static URL getAgentJarUrl() {
        return BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static void main(String[] args) {
        try {
            Collection<URL> urls = BootstrapLoader.getJarURLs();
            urls.add(BootstrapAgent.getAgentJarUrl());
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), null);
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method main = agentClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error invoking the New Relic command: {0}", t));
            t.printStackTrace();
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String javaSpecVersion = JavaVersionUtils.getJavaSpecificationVersion();
        if (!JavaVersionUtils.isAgentSupportedJavaSpecVersion(javaSpecVersion)) {
            System.err.println("----------");
            System.err.println(JavaVersionUtils.getUnsupportedAgentJavaSpecVersionMessage(javaSpecVersion));
            System.err.println("----------");
            return;
        }
        String sysPropEnabled = System.getProperty("newrelic.config.agent_enabled");
        String envVarEnabled = System.getenv("NEW_RELIC_AGENT_ENABLED");
        if (sysPropEnabled != null && !Boolean.valueOf(sysPropEnabled).booleanValue()) {
            System.err.println("----------");
            System.err.println("New Relic Agent is disabled by -Dnewrelic.config.agent_enabled system property.");
            System.err.println("----------");
            return;
        }
        if (envVarEnabled != null && !Boolean.valueOf(envVarEnabled).booleanValue()) {
            System.err.println("----------");
            System.err.println("New Relic Agent is disabled by NEW_RELIC_AGENT_ENABLED environment variable.");
            System.err.println("----------");
            return;
        }
        BootstrapAgent.checkAndApplyIBMLibertyProfileLogManagerWorkaround();
        BootstrapAgent.startAgent(agentArgs, inst);
    }

    private static void checkAndApplyIBMLibertyProfileLogManagerWorkaround() {
        String javaClassPath;
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.startsWith(IBM_VENDOR) && (javaClassPath = System.getProperty("java.class.path")) != null && javaClassPath.contains(WS_SERVER_JAR) && System.getProperty("java.util.logging.manager") == null) {
            try {
                Class.forName(WS_LOG_MANAGER, false, BootstrapAgent.class.getClassLoader());
                System.setProperty("java.util.logging.manager", WS_LOG_MANAGER);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void startAgent(String agentArgs, Instrumentation inst) {
        try {
            ClassLoader classLoader;
            long startTime = System.currentTimeMillis();
            BootstrapLoader.load(inst);
            boolean ibmWorkaround = IBMUtils.getIbmWorkaroundDefault();
            if (System.getProperty("ibm_iv25688_workaround") != null) {
                ibmWorkaround = Boolean.parseBoolean(System.getProperty("ibm_iv25688_workaround"));
            }
            if (ibmWorkaround) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else {
                URL[] codeSource;
                String javaVersion = System.getProperty("java.version", "");
                ClassLoader agentClassLoaderParent = null;
                try {
                    Class<ClassLoader> classLoaderClass = ClassLoader.class;
                    Method getPlatformClassLoader = classLoaderClass.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
                    agentClassLoaderParent = (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
                }
                catch (Exception classLoaderClass) {
                    // empty catch block
                }
                if (javaVersion.startsWith("9") || javaVersion.startsWith("10") || javaVersion.startsWith("11")) {
                    URL url = BootstrapLoader.getDatastoreJarURL();
                    codeSource = new URL[]{BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation(), url};
                } else {
                    codeSource = new URL[]{BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation()};
                }
                classLoader = new JVMAgentClassLoader(codeSource, agentClassLoaderParent);
                if (javaVersion.startsWith("9") || javaVersion.startsWith("10") || javaVersion.startsWith("11")) {
                    Class<?> objectClass = Object.class.getClass();
                    Method getModuleMethod = objectClass.getDeclaredMethod("getModule", new Class[0]);
                    Object baseModule = getModuleMethod.invoke(objectClass, new Object[0]);
                    Class<Instrumentation> instClass = Instrumentation.class;
                    Method redefineModule = instClass.getDeclaredMethod("redefineModule", baseModule.getClass(), Set.class, Map.class, Map.class, Set.class, Map.class);
                    Class<?> bootLoaderClass = classLoader.getClass();
                    Method getUnnamedModule = bootLoaderClass.getMethod("getUnnamedModule", new Class[0]);
                    Object bootUnnamedModule = getUnnamedModule.invoke((Object)classLoader, new Object[0]);
                    HashSet<Object> bootUnnamedModuleSet = new HashSet<Object>();
                    bootUnnamedModuleSet.add(bootUnnamedModule);
                    HashMap<String, HashSet<Object>> extraOpensAndExports = new HashMap<String, HashSet<Object>>();
                    extraOpensAndExports.put(JDK_INTERNAL_LOADER, bootUnnamedModuleSet);
                    extraOpensAndExports.put(JAVA_LANG, bootUnnamedModuleSet);
                    redefineModule.invoke((Object)inst, baseModule, Collections.emptySet(), extraOpensAndExports, extraOpensAndExports, Collections.emptySet(), Collections.emptyMap());
                }
            }
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method premain = agentClass.getDeclaredMethod("premain", String.class, Instrumentation.class, Long.TYPE);
            premain.invoke(null, agentArgs, inst, startTime);
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t));
            t.printStackTrace();
        }
    }

    private static class JVMAgentClassLoader
    extends URLClassLoader {
        public JVMAgentClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        static {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

