/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.attributes.CustomAttributeSender;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.PublicApi;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.errors.ErrorServiceImpl;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class NewRelicApiImplementation
implements PublicApi {
    private final AttributeSender attributeSender = new CustomAttributeSender();

    public void noticeError(Throwable throwable, Map<String, ? extends Object> params) {
        this.noticeError(throwable, params, false);
    }

    public void noticeError(Throwable throwable) {
        Map params = Collections.emptyMap();
        this.noticeError(throwable, params, false);
    }

    public void noticeError(String message, Map<String, ? extends Object> params) {
        this.noticeError(message, params, false);
    }

    private static Map<String, String> filterErrorAtts(Map<String, ? extends Object> params, AttributeSender attributeSender) {
        TreeMap<String, String> atts = new TreeMap<String, String>();
        if (params != null) {
            int maxErrorCount = NewRelicApiImplementation.getNumberOfErrorAttsLeft();
            for (Map.Entry<String, ? extends Object> current : params.entrySet()) {
                if (atts.size() >= maxErrorCount) {
                    Agent.LOG.log(Level.FINER, "Unable to add custom attribute for key \"{0}\" because the limit on error attributes has been reached.", current.getKey());
                    continue;
                }
                Object value = attributeSender.verifyParameterAndReturnValue(current.getKey(), current.getValue(), "noticeError");
                if (value == null) continue;
                if (value instanceof Number || value instanceof String || value instanceof Boolean) {
                    atts.put(current.getKey(), value.toString());
                    continue;
                }
                Agent.LOG.log(Level.FINER, "Unable to add custom attribute for key \"{0}\" because it is not a Number, String or Boolean.", current.getKey());
            }
        }
        return atts;
    }

    private static int getNumberOfErrorAttsLeft() {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            return tx.getAgentConfig().getMaxUserParameters() - tx.getErrorAttributes().size();
        }
        return ServiceFactory.getConfigService().getDefaultAgentConfig().getMaxUserParameters() - 1;
    }

    public void noticeError(String message) {
        Map params = Collections.emptyMap();
        this.noticeError(message, params, false);
    }

    public void noticeError(Throwable throwable, Map<String, ? extends Object> params, boolean expected) {
        try {
            ErrorServiceImpl.reportException(throwable, NewRelicApiImplementation.filterErrorAtts(params, this.attributeSender), expected);
            MetricNames.recordApiSupportabilityMetric("NoticeError");
            if (expected) {
                MetricNames.recordApiSupportabilityMetric("ExpectedError/Api/Throwable");
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", throwable);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", throwable, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public void noticeError(Throwable throwable, boolean expected) {
        Map params = Collections.emptyMap();
        this.noticeError(throwable, params, expected);
    }

    public void noticeError(String message, Map<String, ? extends Object> params, boolean expected) {
        try {
            ErrorServiceImpl.reportError(message, NewRelicApiImplementation.filterErrorAtts(params, this.attributeSender), expected);
            MetricNames.recordApiSupportabilityMetric("NoticeError");
            if (expected) {
                MetricNames.recordApiSupportabilityMetric("ExpectedError/Api/Message");
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", message);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", message, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public void noticeError(String message, boolean expected) {
        Map params = Collections.emptyMap();
        this.noticeError(message, params, expected);
    }

    public void addCustomParameter(String key, String value) {
        this.attributeSender.addAttribute(key, value, "addCustomParameter");
    }

    public void addCustomParameter(String key, Number value) {
        this.attributeSender.addAttribute(key, value, "addCustomParameter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionName(String category, String name) {
        TransactionNamePriority namePriority;
        Transaction tx;
        if (Strings.isEmpty(category)) {
            category = "Custom";
        }
        if (name == null || name.length() == 0) {
            Agent.LOG.log(Level.FINER, "Unable to set the transaction name to an empty string");
            return;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((tx = Transaction.getTransaction(false)) == null) {
            return;
        }
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the transaction name to \"{0}\" in NewRelic API - no transaction", name));
            }
            return;
        }
        boolean isWebTransaction = dispatcher.isWebTransaction();
        TransactionNamingPolicy policy = TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy();
        TransactionNamePriority transactionNamePriority = namePriority = "Uri".equals(category) ? TransactionNamePriority.REQUEST_URI : TransactionNamePriority.CUSTOM_HIGH;
        if (Agent.LOG.isLoggable(Level.FINER)) {
            if (policy.canSetTransactionName(tx, namePriority)) {
                String msg = MessageFormat.format("Setting {1} transaction name to \"{0}\" in NewRelic API", name, isWebTransaction ? "web" : "background");
                Agent.LOG.finer(msg);
            } else {
                Agent.LOG.finer("Unable to set the transaction name to " + name);
            }
        }
        Transaction transaction = tx;
        synchronized (transaction) {
            policy.setTransactionName(tx, name, category, namePriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreTransaction() {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.setIgnore(true);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer("Set ignore transaction in NewRelic API");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreApdex() {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.ignoreApdex();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer("Set ignore APDEX in NewRelic API");
            }
        }
    }

    public void setRequestAndResponse(Request request, Response response) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Agent.LOG.finest("Registering custom request dispatcher");
            tx.setRequestAndResponse(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBrowserTimingHeaderForContentType(String contentType) {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to inject browser timing header in a JSP: not running in a transaction");
                return "";
            }
            String header = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                header = tx.getBrowserTransactionState().getBrowserTimingHeaderForJsp();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing header in a JSP: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error injecting browser timing header in a JSP: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserTimingHeader() {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to get browser timing header in NewRelic API: not running in a transaction");
                return "";
            }
            String header = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                header = tx.getBrowserTransactionState().getBrowserTimingHeader();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing header in NewRelic API: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting browser timing header in NewRelic API: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBrowserTimingFooterForContentType(String contentType) {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to inject browser timing footer in a JSP: not running in a transaction");
                return "";
            }
            String footer = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                footer = tx.getBrowserTransactionState().getBrowserTimingFooter();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing footer in a JSP: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error injecting browser timing footer in a JSP: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserTimingFooter() {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to get browser timing footer in NewRelic API: not running in a transaction");
                return "";
            }
            String footer = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                footer = tx.getBrowserTransactionState().getBrowserTimingFooter();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing footer in NewRelic API: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting browser timing footer in NewRelic API: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    public void setUserName(String name) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx == null) {
            return;
        }
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Attempting to set user name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
        MetricNames.recordApiSupportabilityMetric("SetUserName");
        this.attributeSender.addAttribute("user", name, "setUserName");
    }

    public void setAccountName(String name) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Dispatcher dispatcher = tx.getDispatcher();
            if (dispatcher == null) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - no transaction", name));
                return;
            }
            if (!dispatcher.isWebTransaction()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
                return;
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Attempting to set account name to \"{0}\" in NewRelic API", name);
                Agent.LOG.finer(msg);
            }
            this.attributeSender.addAttribute("account", name, "setAccountName");
            MetricNames.recordApiSupportabilityMetric("SetAccountName");
        }
    }

    public void setProductName(String name) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Dispatcher dispatcher = tx.getDispatcher();
            if (dispatcher == null) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - no transaction", name));
                return;
            }
            if (!dispatcher.isWebTransaction()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
                return;
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Attempting to set product name to \"{0}\" in NewRelic API", name);
                Agent.LOG.finer(msg);
            }
            MetricNames.recordApiSupportabilityMetric("SetProductName");
            this.attributeSender.addAttribute("product", name, "setProductName");
        }
    }

    public void setAppServerPort(int port) {
        ServiceFactory.getEnvironmentService().getEnvironment().setServerPort(port);
        MetricNames.recordApiSupportabilityMetric("SetAppServerPort");
    }

    public void setServerInfo(String dispatcherName, String version) {
        ServiceFactory.getEnvironmentService().getEnvironment().setServerInfo(dispatcherName, version);
        MetricNames.recordApiSupportabilityMetric("SetServerInfo");
    }

    public void setInstanceName(String instanceName) {
        ServiceFactory.getEnvironmentService().getEnvironment().setInstanceName(instanceName);
        MetricNames.recordApiSupportabilityMetric("SetInstanceName");
    }

    private static void logException(String msg, Throwable t) {
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.FINEST, msg, t);
        } else if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer(msg);
        }
    }

    public static void initialize() {
        AgentBridge.publicApi = new NewRelicApiImplementation();
    }
}

