/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.external.ExternalMetrics;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.config.DatastoreConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.datastore.DatastoreMetrics;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.CrossProcessNameFormat;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFlags;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.ExternalsUtil;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.DestinationType;
import com.newrelic.api.agent.GenericParameters;
import com.newrelic.api.agent.HttpParameters;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.MessageConsumeParameters;
import com.newrelic.api.agent.MessageProduceParameters;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.SlowQueryDatastoreParameters;
import com.newrelic.api.agent.TracedMethod;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultTracer
extends AbstractTracer {
    public static final MetricNameFormat NULL_METRIC_NAME_FORMATTER = new SimpleMetricNameFormat(null);
    public static final String BACKTRACE_PARAMETER_NAME = "backtrace";
    public static final int DEFAULT_TRACER_FLAGS = 6;
    private static final int INITIAL_PARAMETER_MAP_SIZE = 5;
    private final long startTime;
    private final long timestamp;
    private long duration;
    private long exclusiveDuration;
    private Map<String, Object> attributes;
    private Tracer parentTracer;
    private String guid;
    private final ClassMethodSignature classMethodSignature;
    private Object invocationTarget;
    private MetricNameFormat metricNameFormat;
    private boolean isParent;
    private boolean addedOutboundRequestHeaders;
    private boolean childHasStackTrace;
    private byte tracerFlags;
    private int childCount = 0;
    private com.newrelic.api.agent.ExternalParameters externalParameters = null;
    private InboundHeaders inboundResponseHeaders = null;

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags) {
        this(transaction.getTransactionActivity(), sig, object, metricNameFormatter, tracerFlags);
    }

    public DefaultTracer(TransactionActivity txa, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags) {
        this(txa, sig, object, metricNameFormatter, tracerFlags, System.nanoTime());
    }

    public DefaultTracer(TransactionActivity txa, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags, long pStartTime) {
        super(txa);
        this.metricNameFormat = metricNameFormatter;
        this.classMethodSignature = sig;
        this.startTime = pStartTime;
        this.timestamp = System.currentTimeMillis();
        this.invocationTarget = object;
        this.parentTracer = txa.getLastTracer();
        if (!txa.canCreateTransactionSegment()) {
            tracerFlags = TracerFlags.clearSegment((int)tracerFlags);
        }
        this.tracerFlags = (byte)tracerFlags;
        this.guid = TransactionGuidFactory.generateGuid();
    }

    public DefaultTracer(TransactionActivity txa, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, long pStartTime) {
        this(txa, sig, object, metricNameFormatter, 6, pStartTime);
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
        this(transaction, sig, object, metricNameFormatter, 6);
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object) {
        this(transaction, sig, object, NULL_METRIC_NAME_FORMATTER);
    }

    @Override
    public void removeTransactionSegment() {
        this.tracerFlags = (byte)TracerFlags.clearSegment((int)this.tracerFlags);
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Throwable throwable) {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            TransactionActivity.clear();
            return;
        }
        if (!tx.getTransactionState().finish(tx, this)) {
            return;
        }
        try {
            this.getTransactionActivity().lockTracerStart();
            this.doFinish(throwable);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.WARNING, msg, t);
            } else {
                Agent.LOG.warning(msg);
            }
        }
        finally {
            this.getTransactionActivity().unlockTracerStart();
        }
        this.finish(191, null);
        if (Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINE, "(Debug) Tracer.finish(Throwable)");
        }
    }

    protected void reset() {
        this.invocationTarget = null;
    }

    public void finish(int opcode, Object returnValue) {
        TransactionActivity txa = this.getTransactionActivity();
        if (txa == null) {
            Agent.LOG.log(Level.FINER, "Transaction activity for {0} was null", this);
            return;
        }
        Transaction tx = this.getTransaction();
        if (tx != null && !tx.getTransactionState().finish(tx, this)) {
            return;
        }
        this.performFinishWork(this.finishTime.get() == null ? System.nanoTime() : (Long)this.finishTime.get(), opcode, returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFinishWork(long finishTime, int opcode, Object returnValue) {
        this.duration = Math.max(0L, finishTime - this.getStartTime());
        this.exclusiveDuration += this.duration;
        if (this.exclusiveDuration < 0L || this.exclusiveDuration > this.duration) {
            Agent.LOG.log(Level.FINE, "Invalid exclusive time {0} for tracer {1}", this.exclusiveDuration, this.getClass().getName());
            this.exclusiveDuration = this.duration;
        }
        this.getTransactionActivity().lockTracerStart();
        try {
            String msg;
            block15: {
                try {
                    if (191 != opcode) {
                        this.doFinish(opcode, returnValue);
                    }
                }
                catch (Throwable t) {
                    msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                    Agent.LOG.severe(msg);
                    Agent.LOG.log(Level.FINER, msg, t);
                }
                try {
                    this.attemptToStoreStackTrace();
                }
                catch (Throwable t) {
                    if (!Agent.LOG.isFinestEnabled()) break block15;
                    msg = MessageFormat.format("An error occurred getting stack trace for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                    Agent.LOG.log(Level.FINEST, msg, t);
                }
            }
            if (this.impactsParent(this.parentTracer)) {
                this.parentTracer.childTracerFinished(this);
            }
            try {
                this.recordMetrics(this.getTransactionActivity().getTransactionStats());
            }
            catch (Throwable t) {
                msg = MessageFormat.format("An error occurred recording tracer metrics for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                Agent.LOG.severe(msg);
                Agent.LOG.log(Level.FINER, msg, t);
            }
            try {
                if (!(this instanceof SkipTracer)) {
                    this.getTransactionActivity().tracerFinished(this, opcode);
                }
            }
            catch (Throwable t) {
                msg = MessageFormat.format("An error occurred calling Transaction.tracerFinished() for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                Agent.LOG.severe(msg);
                Agent.LOG.log(Level.FINER, msg, t);
            }
            this.reset();
        }
        finally {
            this.getTransactionActivity().unlockTracerStart();
        }
    }

    @Override
    public long getStartTimeInMillis() {
        return this.timestamp;
    }

    @Override
    public com.newrelic.api.agent.ExternalParameters getExternalParameters() {
        return this.externalParameters;
    }

    protected void doFinish(Throwable throwable) {
    }

    protected void doFinish(int opcode, Object returnValue) {
    }

    protected boolean shouldStoreStackTrace() {
        return this.isTransactionSegment();
    }

    private void attemptToStoreStackTrace() {
        if (this.getTransaction() != null && this.shouldStoreStackTrace()) {
            TransactionTracerConfig transactionTracerConfig = this.getTransaction().getTransactionTracerConfig();
            double stackTraceThresholdInNanos = transactionTracerConfig.getStackTraceThresholdInNanos();
            int stackTraceMax = transactionTracerConfig.getMaxStackTraces();
            if ((double)this.getDuration() > stackTraceThresholdInNanos && (this.childHasStackTrace || this.getTransaction().getTransactionCounts().getStackTraceCount() < stackTraceMax)) {
                this.storeStackTrace();
                if (!this.childHasStackTrace) {
                    this.getTransaction().getTransactionCounts().incrementStackTraceCount();
                    this.childHasStackTrace = true;
                }
            }
        }
    }

    public void storeStackTrace() {
        this.setAttribute(BACKTRACE_PARAMETER_NAME, Thread.currentThread().getStackTrace());
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.setAttribute(key, value, true);
    }

    @Override
    public void removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public void setAttribute(String key, Object value, boolean checkLimits) {
        if (checkLimits && this.getTransaction().getTransactionCounts().isOverTracerSegmentLimit()) {
            return;
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        if (checkLimits) {
            this.getTransaction().getTransactionCounts().incrementSize(DefaultTracer.sizeof(value));
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1, 5.0f);
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    static int sizeof(Object value) {
        int size = 0;
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof StackTraceElement) {
            StackTraceElement elem = (StackTraceElement)value;
            return DefaultTracer.sizeof(elem.getClassName()) + DefaultTracer.sizeof(elem.getFileName()) + DefaultTracer.sizeof(elem.getMethodName()) + 10;
        }
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                size += DefaultTracer.sizeof(obj);
            }
        }
        return size;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public long getRunningDurationInNanos() {
        return this.duration > 0L ? this.duration : Math.max(0L, System.nanoTime() - this.getStartTime());
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getExclusiveDuration() {
        return this.exclusiveDuration;
    }

    @Override
    public long getEndTime() {
        return this.getStartTime() + this.duration;
    }

    @Override
    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getEndTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getStartTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    protected final Object getInvocationTarget() {
        return this.invocationTarget;
    }

    @Override
    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    @Override
    public void setParentTracer(Tracer tracer) {
        this.parentTracer = tracer;
    }

    public String getRequestMetricName() {
        return null;
    }

    public void setMetricNameFormat(MetricNameFormat nameFormat) {
        this.metricNameFormat = nameFormat;
    }

    protected final MetricNameFormat getMetricNameFormat() {
        return this.metricNameFormat;
    }

    @Override
    public final String getMetricName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getMetricName();
    }

    @Override
    public final String getTransactionSegmentName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentName();
    }

    @Override
    public final String getTransactionSegmentUri() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentUri();
    }

    protected void recordMetrics(TransactionStats transactionStats) {
        try {
            this.recordExternalMetrics();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("An error occurred recording external metrics for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t);
        }
        if (this.getTransaction() == null || this.getTransaction().isIgnore()) {
            return;
        }
        if (this.isMetricProducer()) {
            ResponseTimeStats stats;
            String metricName = this.getMetricName();
            if (metricName != null) {
                ResponseTimeStats stats2 = transactionStats.getScopedStats().getResponseTimeStats(metricName);
                stats2.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
            }
            if (this.getRollupMetricNames() != null) {
                for (String name : this.getRollupMetricNames()) {
                    stats = transactionStats.getUnscopedStats().getResponseTimeStats(name);
                    stats.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
                }
            }
            if (this.getExclusiveRollupMetricNames() != null) {
                for (String name : this.getExclusiveRollupMetricNames()) {
                    stats = transactionStats.getUnscopedStats().getResponseTimeStats(name);
                    stats.recordResponseTimeInNanos(this.getExclusiveDuration(), this.getExclusiveDuration());
                }
            }
            this.doRecordMetrics(transactionStats);
        }
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
    }

    @Override
    public final boolean isParent() {
        return this.isParent;
    }

    @Override
    public void childTracerFinished(Tracer child) {
        if (child.isMetricProducer() && !(child instanceof SkipTracer)) {
            ++this.childCount;
            this.exclusiveDuration -= child.getDuration();
            if (this.isTransactionSegment() && child.isTransactionSegment()) {
                this.isParent = true;
                if (child.isChildHasStackTrace()) {
                    this.childHasStackTrace = true;
                }
            }
        }
    }

    @Override
    public int getChildCount() {
        return this.childCount;
    }

    private boolean impactsParent(Tracer parent) {
        return parent != null && parent.getTransactionActivity() == this.getTransactionActivity();
    }

    public void childTracerFinished(long childDurationInNanos) {
        this.exclusiveDuration -= childDurationInNanos;
    }

    @Override
    public ClassMethodSignature getClassMethodSignature() {
        return this.classMethodSignature;
    }

    @Override
    public final boolean isTransactionSegment() {
        return (this.tracerFlags & 4) == 4;
    }

    public boolean isMetricProducer() {
        return (this.tracerFlags & 2) == 2;
    }

    @Override
    public final boolean isLeaf() {
        return (this.tracerFlags & 0x20) == 32;
    }

    @Override
    public final boolean isAsync() {
        return TracerFlags.isAsync((int)this.tracerFlags);
    }

    @Override
    public boolean isChildHasStackTrace() {
        return this.childHasStackTrace;
    }

    @Override
    public TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(ttConfig, sqlObfuscator, startTime, this);
    }

    public void setMetricName(String ... metricNameParts) {
        String metricName = Strings.join('/', metricNameParts);
        if (metricName != null) {
            this.setMetricNameFormat(new SimpleMetricNameFormat(metricName));
        }
        MetricNames.recordApiSupportabilityMetric("Segment/SetMetricName");
    }

    public void setMetricNameFormatInfo(String metricName, String transactionSegmentName, String transactionSegmentUri) {
        SimpleMetricNameFormat format = new SimpleMetricNameFormat(metricName, transactionSegmentName, transactionSegmentUri);
        this.setMetricNameFormat(format);
    }

    @Override
    public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        Transaction transaction = this.getTransactionActivity().getTransaction();
        transaction.getCrossProcessState().processOutboundRequestHeaders(outboundHeaders, (TracedMethod)this);
        this.addedOutboundRequestHeaders = true;
    }

    @Override
    public void readInboundResponseHeaders(InboundHeaders inboundResponseHeaders) {
        Agent.LOG.log(Level.FINE, "Setting inboundResponseHeaders to: " + inboundResponseHeaders);
        this.inboundResponseHeaders = inboundResponseHeaders;
    }

    @Override
    public void reportAsExternal(ExternalParameters externalParameters) {
        this.reportAsExternal((com.newrelic.api.agent.ExternalParameters)externalParameters);
    }

    @Override
    public void reportAsExternal(com.newrelic.api.agent.ExternalParameters externalParameters) {
        if (Agent.LOG.isFineEnabled()) {
            Agent.LOG.log(Level.FINE, "Setting externalParameters to: " + externalParameters);
        }
        MetricNames.recordApiSupportabilityMetric("ReportAsExternal");
        this.externalParameters = externalParameters;
        if (this.externalParameters instanceof HttpParameters) {
            InboundHeaders headers;
            HttpParameters httpParameters = (HttpParameters)this.externalParameters;
            URI uri = httpParameters.getUri();
            if (uri == null || uri.getScheme() == null || uri.getHost() == null || uri.getPort() == -1) {
                Agent.LOG.log(Level.FINE, "URI parameter passed to HttpParameters should include a valid scheme, host, and port.");
            }
            if (null != (headers = httpParameters.getInboundResponseHeaders())) {
                this.readInboundResponseHeaders(headers);
            }
        } else if (this.externalParameters instanceof MessageProduceParameters) {
            this.catForMessaging((MessageProduceParameters)this.externalParameters);
        } else if (this.externalParameters instanceof MessageConsumeParameters) {
            this.catForMessaging((MessageConsumeParameters)this.externalParameters);
        }
    }

    private void recordExternalMetrics() {
        if (null != this.externalParameters) {
            if (this.externalParameters instanceof DatastoreParameters) {
                this.recordExternalMetricsDatastore((DatastoreParameters)this.externalParameters);
                if (this.externalParameters instanceof SlowQueryDatastoreParameters) {
                    this.recordSlowQueryData((SlowQueryDatastoreParameters)this.externalParameters);
                }
            } else if (this.externalParameters instanceof GenericParameters) {
                this.recordExternalMetricsGeneric((GenericParameters)this.externalParameters);
            } else if (this.externalParameters instanceof HttpParameters) {
                this.recordExternalMetricsHttp((HttpParameters)this.externalParameters);
            } else if (this.externalParameters instanceof MessageProduceParameters) {
                this.recordMessageBrokerMetrics((MessageProduceParameters)this.externalParameters);
            } else if (this.externalParameters instanceof MessageConsumeParameters) {
                this.recordMessageBrokerMetrics((MessageConsumeParameters)this.externalParameters);
            } else {
                Agent.LOG.log(Level.SEVERE, "Unknown externalParameters type. This should not happen. {0} -- {1}", this.externalParameters, this.externalParameters.getClass());
            }
        } else if (null == this.externalParameters && null != this.inboundResponseHeaders) {
            Agent.LOG.log(Level.FINE, "Warning: readInboundResponseHeaders was called without a call to reportAsExternal. Inbound headers will not take effect.");
        }
    }

    private void recordInboundResponseHeaders(InboundHeaders inboundResponseHeaders, String host, String uri) {
        Transaction transaction = this.getTransactionActivity().getTransaction();
        if (this.addedOutboundRequestHeaders && inboundResponseHeaders != null) {
            transaction.getCrossProcessState().processInboundResponseHeaders(inboundResponseHeaders, (com.newrelic.agent.bridge.TracedMethod)this, host, uri, false);
            if (this.metricNameFormat instanceof CrossProcessNameFormat) {
                this.addRollupMetricName(((CrossProcessNameFormat)this.metricNameFormat).getHostCrossProcessIdRollupMetricName());
            }
        }
    }

    private void recordExternalMetricsGeneric(GenericParameters externalParameters) {
        Transaction transaction = this.getTransactionActivity().getTransaction();
        URI uri = ExternalsUtil.sanitizeURI(externalParameters.getUri());
        String host = uri == null ? "UnknownHost" : uri.getHost();
        String uriStr = uri == null ? "UnknownHost" : uri.toString();
        String library = externalParameters.getLibrary();
        String procedure = externalParameters.getProcedure();
        ExternalMetrics.makeExternalComponentTrace((boolean)transaction.isWebTransaction(), (com.newrelic.agent.bridge.TracedMethod)this, (String)host, (String)library, (boolean)true, (String)uriStr, (String[])new String[]{procedure});
        this.recordInboundResponseHeaders(this.inboundResponseHeaders, host, uriStr);
    }

    private void recordExternalMetricsHttp(HttpParameters externalParameters) {
        Transaction transaction = this.getTransactionActivity().getTransaction();
        URI uri = ExternalsUtil.sanitizeURI(externalParameters.getUri());
        String host = uri == null ? "UnknownHost" : uri.getHost();
        String uriStr = uri == null ? "UnknownHost" : uri.toString();
        String library = externalParameters.getLibrary();
        String procedure = externalParameters.getProcedure();
        ExternalMetrics.makeExternalComponentTrace((boolean)transaction.isWebTransaction(), (com.newrelic.agent.bridge.TracedMethod)this, (String)host, (String)library, (boolean)true, (String)uriStr, (String[])new String[]{procedure});
        this.recordInboundResponseHeaders(this.inboundResponseHeaders, host, uriStr);
    }

    private void recordExternalMetricsDatastore(DatastoreParameters datastoreParameters) {
        Transaction tx = this.getTransactionActivity().getTransaction();
        if (tx != null && datastoreParameters != null) {
            boolean allUnknown;
            DatastoreMetrics.collectDatastoreMetrics(datastoreParameters.getProduct(), tx, (TracedMethod)this, datastoreParameters.getCollection(), datastoreParameters.getOperation(), datastoreParameters.getHost(), datastoreParameters.getPort(), datastoreParameters.getPathOrId(), datastoreParameters.getDatabaseName());
            DatastoreConfig datastoreConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDatastoreConfig();
            boolean bl = allUnknown = datastoreParameters.getHost() == null && datastoreParameters.getPort() == null && datastoreParameters.getPathOrId() == null;
            if (datastoreConfig.isInstanceReportingEnabled() && !allUnknown) {
                this.setAttribute("host", DatastoreMetrics.replaceLocalhost(datastoreParameters.getHost()));
                this.setAttribute("port_path_or_id", DatastoreMetrics.getIdentifierOrPort(datastoreParameters.getPort(), datastoreParameters.getPathOrId()));
            }
            if (datastoreConfig.isDatabaseNameReportingEnabled() && datastoreParameters.getDatabaseName() != null) {
                this.setAttribute("db.instance", datastoreParameters.getDatabaseName());
            }
        } else {
            Agent.LOG.log(Level.FINE, "Datastore metrics will not be applied because the tracer is not in a transaction.");
        }
    }

    private void catForMessaging(MessageProduceParameters produceParameters) {
        OutboundHeaders outboundHeaders = produceParameters.getOutboundHeaders();
        if (outboundHeaders == null) {
            return;
        }
        DestinationType destinationType = produceParameters.getDestinationType();
        if (destinationType == DestinationType.EXCHANGE) {
            this.addOutboundRequestHeaders(outboundHeaders);
        } else if (destinationType == DestinationType.NAMED_QUEUE || destinationType == DestinationType.NAMED_TOPIC) {
            this.addOutboundRequestHeaders(outboundHeaders);
        } else if (destinationType == DestinationType.TEMP_QUEUE || destinationType == DestinationType.TEMP_TOPIC) {
            this.getTransaction().getCrossProcessState().processOutboundResponseHeaders(outboundHeaders, -1L);
        } else {
            Agent.LOG.log(Level.FINE, "Unexpected destination type when recording CAT metrics for message produce.");
        }
    }

    private void catForMessaging(MessageConsumeParameters consumeParameters) {
        InboundHeaders headers = consumeParameters.getInboundHeaders();
        if (headers == null) {
            return;
        }
        DestinationType destinationType = consumeParameters.getDestinationType();
        if (destinationType == DestinationType.EXCHANGE) {
            this.getTransaction().provideHeaders(headers);
        } else if (destinationType == DestinationType.NAMED_QUEUE || destinationType == DestinationType.NAMED_TOPIC) {
            this.getTransaction().provideHeaders(headers);
        } else if (destinationType == DestinationType.TEMP_QUEUE || destinationType == DestinationType.TEMP_TOPIC) {
            Transaction transaction = this.getTransactionActivity().getTransaction();
            transaction.getCrossProcessState().processInboundResponseHeaders(headers, (com.newrelic.agent.bridge.TracedMethod)this, "Unknown", null, true);
        } else {
            Agent.LOG.log(Level.FINE, "Unexpected destination type when reporting external metrics for message consume.");
        }
    }

    private void recordMessageBrokerMetrics(MessageProduceParameters messageProduceParameters) {
        DestinationType destinationType = messageProduceParameters.getDestinationType();
        if (destinationType == DestinationType.EXCHANGE) {
            this.setMetricName(MessageFormat.format("MessageBroker/{0}/{1}/Produce/Named/{2}", messageProduceParameters.getLibrary(), messageProduceParameters.getDestinationType().getTypeName(), messageProduceParameters.getDestinationName()));
        } else if (destinationType == DestinationType.NAMED_QUEUE || destinationType == DestinationType.NAMED_TOPIC) {
            this.setMetricName(MessageFormat.format("MessageBroker/{0}/{1}/Produce/Named/{2}", messageProduceParameters.getLibrary(), messageProduceParameters.getDestinationType().getTypeName(), messageProduceParameters.getDestinationName()));
        } else if (destinationType == DestinationType.TEMP_QUEUE || destinationType == DestinationType.TEMP_TOPIC) {
            this.setMetricName(MessageFormat.format("MessageBroker/{0}/{1}/Produce/Temp", messageProduceParameters.getLibrary(), messageProduceParameters.getDestinationType().getTypeName()));
        }
    }

    private void recordMessageBrokerMetrics(MessageConsumeParameters messageConsumeParameters) {
        DestinationType destinationType = messageConsumeParameters.getDestinationType();
        if (destinationType == DestinationType.EXCHANGE) {
            this.setMetricName(MessageFormat.format("MessageBroker/{0}/{1}/Consume/Named/{2}", messageConsumeParameters.getLibrary(), messageConsumeParameters.getDestinationType().getTypeName(), messageConsumeParameters.getDestinationName()));
        } else if (destinationType == DestinationType.NAMED_QUEUE || destinationType == DestinationType.NAMED_TOPIC) {
            this.setMetricName(MessageFormat.format("MessageBroker/{0}/{1}/Consume/Named/{2}", messageConsumeParameters.getLibrary(), messageConsumeParameters.getDestinationType().getTypeName(), messageConsumeParameters.getDestinationName()));
        } else if (destinationType == DestinationType.TEMP_QUEUE || destinationType == DestinationType.TEMP_TOPIC) {
            this.setMetricName(MessageFormat.format("MessageBroker/{0}/{1}/Consume/Temp", messageConsumeParameters.getLibrary(), messageConsumeParameters.getDestinationType().getTypeName()));
        }
    }

    private <T> void recordSlowQueryData(SlowQueryDatastoreParameters<T> slowQueryDatastoreParameters) {
        Transaction transaction = this.getTransactionActivity().getTransaction();
        if (transaction != null && slowQueryDatastoreParameters.getRawQuery() != null && slowQueryDatastoreParameters.getQueryConverter() != null) {
            transaction.getSlowQueryListener(true).noticeTracer(this, slowQueryDatastoreParameters);
        }
    }
}

