/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.xray.XRaySession;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class XRayTransactionSampler
implements ITransactionSampler {
    static final int TRACES_TO_KEEP = 10;
    private final XRaySession session;
    private final String applicationName;
    private final List<TransactionData> data = new CopyOnWriteArrayList<TransactionData>();

    public XRayTransactionSampler(XRaySession session) {
        this.session = session;
        this.applicationName = session.getApplicationName();
    }

    @Override
    public boolean noticeTransaction(TransactionData td) {
        String transactionName;
        if (this.session.sessionHasExpired()) {
            return false;
        }
        if (this.data.size() >= 10) {
            return false;
        }
        String appName = td.getApplicationName();
        if (this.isTransactionOfInterest(appName, transactionName = td.getBlameOrRootMetricName())) {
            this.data.add(td);
            this.session.incrementCount();
            return true;
        }
        return false;
    }

    boolean isTransactionOfInterest(String appName, String transactionName) {
        if (!this.applicationName.equals(appName)) {
            return false;
        }
        return transactionName.equals(this.session.getKeyTransactionName());
    }

    @Override
    public List<TransactionTrace> harvest(String appName) {
        ArrayList<TransactionTrace> tracesToReturn = new ArrayList<TransactionTrace>();
        for (TransactionData td : this.data) {
            TransactionTrace trace = TransactionTrace.getTransactionTrace(td);
            trace.setXraySessionId(this.session.getxRayId());
            tracesToReturn.add(trace);
        }
        this.data.clear();
        return tracesToReturn;
    }

    @Override
    public void stop() {
    }
}

