/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.KeyTransactionProfile;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfileSampler;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ProfilingTask;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class XrayProfilingTask
implements ProfilingTask {
    private final List<ProfilerParameters> profilesToAdd = new CopyOnWriteArrayList<ProfilerParameters>();
    private final List<ProfilerParameters> profilesToRemove = new CopyOnWriteArrayList<ProfilerParameters>();
    private final List<IProfile> profiles = new ArrayList<IProfile>();
    private final AtomicBoolean sendProfiles = new AtomicBoolean(false);
    private final ProfileSampler profileSampler = new ProfileSampler();

    @Override
    public void addProfile(ProfilerParameters parameters) {
        this.profilesToAdd.add(parameters);
    }

    @Override
    public void removeProfile(ProfilerParameters parameters) {
        this.profilesToRemove.add(parameters);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    @Override
    public void afterHarvest(String appName) {
        this.sendProfiles.set(true);
    }

    @Override
    public void run() {
        try {
            this.sampleStackTraces();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error sampling stack traces: {0}", t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, t);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void sampleStackTraces() {
        if (this.sendProfiles.getAndSet(false)) {
            this.sendProfiles();
        } else {
            this.removeProfiles();
        }
        this.addProfiles();
        this.profileSampler.sampleStackTraces(this.profiles);
    }

    private void removeProfiles() {
        for (ProfilerParameters parameters : this.profilesToRemove) {
            IProfile profile = this.getProfile(parameters);
            if (profile != null) {
                this.profiles.remove(profile);
                Agent.LOG.info(MessageFormat.format("Stopped xray session profiling: {0}", parameters.getKeyTransaction()));
            }
            this.profilesToRemove.remove(parameters);
        }
    }

    private void addProfiles() {
        for (ProfilerParameters parameters : this.profilesToAdd) {
            IProfile profile = this.getProfile(parameters);
            if (profile == null) {
                profile = this.createProfile(parameters);
                profile.start();
                this.profiles.add(profile);
                Agent.LOG.info(MessageFormat.format("Started xray session profiling: {0}", parameters.getKeyTransaction()));
            }
            this.profilesToAdd.remove(parameters);
        }
    }

    @VisibleForTesting
    List<IProfile> getProfiles() {
        return new CopyOnWriteArrayList<IProfile>(this.profiles);
    }

    private IProfile getProfile(ProfilerParameters parameters) {
        for (IProfile profile : this.profiles) {
            if (!profile.getProfilerParameters().equals(parameters)) continue;
            return profile;
        }
        return null;
    }

    private IProfile createProfile(ProfilerParameters parameters) {
        return new KeyTransactionProfile(new Profile(parameters));
    }

    private void sendProfiles() {
        ListIterator<IProfile> it = this.profiles.listIterator();
        while (it.hasNext()) {
            IProfile profile = it.next();
            int otherCallSiteCount = profile.getProfileTree(ThreadType.BasicThreadType.OTHER).getCallSiteCount();
            if (otherCallSiteCount <= 0) continue;
            it.remove();
            profile.end();
            IProfile nProfile = this.createProfile(profile.getProfilerParameters());
            nProfile.start();
            it.add(nProfile);
            this.sendProfile(profile);
            ProfilerParameters parameters = profile.getProfilerParameters();
            if (!this.profilesToRemove.contains(parameters)) continue;
            this.profiles.remove(profile);
            Agent.LOG.info(MessageFormat.format("Stopped xray session profiling: {0}", parameters.getKeyTransaction()));
        }
    }

    private void sendProfile(IProfile profile) {
        try {
            if (Agent.LOG.isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Sending Xray profile: {0}", profile.getProfilerParameters().getXraySessionId());
                Agent.LOG.fine(msg);
            }
            String appName = profile.getProfilerParameters().getAppName();
            List<Long> ids = ServiceFactory.getRPMService(appName).sendProfileData(Arrays.asList(profile));
            if (Agent.LOG.isLoggable(Level.FINE)) {
                Agent.LOG.fine(MessageFormat.format("Xray profile id: {0}", ids));
            }
        }
        catch (IgnoreSilentlyException appName) {
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to send profile data: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.fine(msg);
        }
    }
}

