/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver.preprocessors;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.api.agent.Trace;
import java.util.Iterator;

public class TracedWeaveInstrumentationTracker {
    private final String weavePackageName;
    private final String className;
    private final Method method;
    private final boolean isWeaveIntoAllMethods;
    private final TraceDetails traceDetails;
    private static final String traceDesc = Type.getDescriptor(Trace.class);

    public TracedWeaveInstrumentationTracker(String weavePackageName, String className, Method method, boolean isWeaveIntoAllMethods, TraceDetails traceDetails) {
        this.weavePackageName = weavePackageName;
        this.className = className;
        this.method = method;
        this.isWeaveIntoAllMethods = isWeaveIntoAllMethods;
        this.traceDetails = traceDetails;
    }

    public void addToInstrumentationContext(InstrumentationContext context, Method method) {
        context.addTrace(method, this.traceDetails);
    }

    public static void removeTraceAnnotations(MethodNode method) {
        if (null != method.visibleAnnotations) {
            Iterator<AnnotationNode> iter = method.visibleAnnotations.iterator();
            while (iter.hasNext()) {
                AnnotationNode compositeAnnotation = iter.next();
                if (!traceDesc.equals(compositeAnnotation.desc)) continue;
                iter.remove();
            }
        }
    }

    public String getWeavePackageName() {
        return this.weavePackageName;
    }

    public String getClassName() {
        return this.className;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isWeaveIntoAllMethods() {
        return this.isWeaveIntoAllMethods;
    }
}

