/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver.preprocessors;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.PrivateApi;
import com.newrelic.agent.bridge.PublicApi;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.bridge.TracedActivity;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMultimap;
import com.newrelic.agent.deps.com.google.common.collect.Multimap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.api.agent.Insights;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Segment;
import com.newrelic.api.agent.TracedMethod;
import com.newrelic.api.agent.Transaction;
import com.newrelic.api.agent.TransactionNamePriority;
import com.newrelic.api.agent.weaver.internal.WeavePackageType;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePostprocessor;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class AgentPostprocessors
implements WeavePostprocessor {
    private WeavePackageType weavePackageType = WeavePackageType.CUSTOM;
    private static Multimap<String, Method> TRACKED_API_INTERNAL_NAME_TO_METHOD_NAMES = ImmutableMultimap.builder().put(Type.getType(Transaction.class).getInternalName(), new Method("getToken", Type.getType(com.newrelic.api.agent.Token.class), new Type[0])).put(Type.getType(com.newrelic.agent.bridge.Transaction.class).getInternalName(), new Method("getToken", Type.getType(Token.class), new Type[0])).put(Type.getType(Transaction.class).getInternalName(), new Method("startSegment", Type.getType(Segment.class), new Type[]{Type.getType(String.class)})).put(Type.getType(Transaction.class).getInternalName(), new Method("startSegment", Type.getType(Segment.class), new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(com.newrelic.agent.bridge.Transaction.class).getInternalName(), new Method("createAndStartTracedActivity", Type.getType(TracedActivity.class), new Type[0])).put(Type.getType(Transaction.class).getInternalName(), new Method("ignore", Type.VOID_TYPE, new Type[0])).put(Type.getType(Transaction.class).getInternalName(), new Method("ignoreApdex", Type.VOID_TYPE, new Type[0])).put(Type.getType(Transaction.class).getInternalName(), new Method("processRequestMetadata", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(Transaction.class).getInternalName(), new Method("processResponseMetadata", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(Transaction.class).getInternalName(), new Method("processResponseMetadata", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(URI.class)})).put(Type.getType(Transaction.class).getInternalName(), new Method("setTransactionName", Type.BOOLEAN_TYPE, new Type[]{Type.getType(TransactionNamePriority.class), Type.BOOLEAN_TYPE, Type.getType(String.class), Type.getType(String[].class)})).put(Type.getType(com.newrelic.agent.bridge.Transaction.class).getInternalName(), new Method("setTransactionName", Type.BOOLEAN_TYPE, new Type[]{Type.getType(TransactionNamePriority.class), Type.BOOLEAN_TYPE, Type.getType(String.class), Type.getType(String[].class)})).put(Type.getType(TracedMethod.class).getInternalName(), new Method("reportAsExternal", Type.VOID_TYPE, new Type[]{Type.getType(com.newrelic.api.agent.ExternalParameters.class)})).put(Type.getType(com.newrelic.agent.bridge.TracedMethod.class).getInternalName(), new Method("reportAsExternal", Type.VOID_TYPE, new Type[]{Type.getType(ExternalParameters.class)})).put(Type.getType(Insights.class).getInternalName(), new Method("recordCustomEvent", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Map.class)})).put(Type.getType(Segment.class).getInternalName(), new Method("end", Type.VOID_TYPE, new Type[0])).put(Type.getType(Segment.class).getInternalName(), new Method("ignore", Type.VOID_TYPE, new Type[0])).put(Type.getType(Segment.class).getInternalName(), new Method("reportAsExternal", Type.VOID_TYPE, new Type[]{Type.getType(com.newrelic.api.agent.ExternalParameters.class)})).put(Type.getType(Segment.class).getInternalName(), new Method("setMetricName", Type.VOID_TYPE, new Type[]{Type.getType(String[].class)})).put(Type.getType(TracedMethod.class).getInternalName(), new Method("setMetricName", Type.VOID_TYPE, new Type[]{Type.getType(String[].class)})).put(Type.getType(com.newrelic.agent.bridge.TracedMethod.class).getInternalName(), new Method("setMetricName", Type.VOID_TYPE, new Type[]{Type.getType(String[].class)})).put(Type.getType(com.newrelic.api.agent.Token.class).getInternalName(), new Method("link", Type.BOOLEAN_TYPE, new Type[0])).put(Type.getType(com.newrelic.api.agent.Token.class).getInternalName(), new Method("expire", Type.BOOLEAN_TYPE, new Type[0])).put(Type.getType(com.newrelic.api.agent.Token.class).getInternalName(), new Method("linkAndExpire", Type.BOOLEAN_TYPE, new Type[0])).put(Type.getType(NewRelic.class).getInternalName(), new Method("addCustomParameter", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Number.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("addCustomParameter", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("addCustomParameter", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Number.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("addCustomParameter", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(PrivateApi.class).getInternalName(), new Method("addCustomAttribute", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Number.class)})).put(Type.getType(PrivateApi.class).getInternalName(), new Method("addCustomAttribute", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(PrivateApi.class).getInternalName(), new Method("addCustomAttribute", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Map.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("ignoreTransaction", Type.VOID_TYPE, new Type[0])).put(Type.getType(PublicApi.class).getInternalName(), new Method("ignoreTransaction", Type.VOID_TYPE, new Type[0])).put(Type.getType(NewRelic.class).getInternalName(), new Method("ignoreApdex", Type.VOID_TYPE, new Type[0])).put(Type.getType(PublicApi.class).getInternalName(), new Method("ignoreApdex", Type.VOID_TYPE, new Type[0])).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.getType(Map.class), Type.BOOLEAN_TYPE})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.BOOLEAN_TYPE})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Map.class), Type.BOOLEAN_TYPE})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.BOOLEAN_TYPE})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.getType(Map.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Map.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.getType(Map.class), Type.BOOLEAN_TYPE})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.BOOLEAN_TYPE})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Map.class), Type.BOOLEAN_TYPE})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.BOOLEAN_TYPE})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.getType(Map.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Map.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("noticeError", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setAppServerPort", Type.VOID_TYPE, new Type[]{Type.INT_TYPE})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setAppServerPort", Type.VOID_TYPE, new Type[]{Type.INT_TYPE})).put(Type.getType(PrivateApi.class).getInternalName(), new Method("setAppServerPort", Type.VOID_TYPE, new Type[]{Type.INT_TYPE})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setInstanceName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setInstanceName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(PrivateApi.class).getInternalName(), new Method("setInstanceName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setProductName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setProductName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setServerInfo", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setServerInfo", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(PrivateApi.class).getInternalName(), new Method("setServerInfo", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setTransactionName", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setTransactionName", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(String.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setUserName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setUserName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(NewRelic.class).getInternalName(), new Method("setAccountName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).put(Type.getType(PublicApi.class).getInternalName(), new Method("setAccountName", Type.VOID_TYPE, new Type[]{Type.getType(String.class)})).build();

    public void setWeavePackageType(WeavePackageType weavePackageType) {
        this.weavePackageType = weavePackageType;
    }

    @Override
    public ClassVisitor postprocess(ClassVisitor cv, Set<String> utilityClassesInternalNames, WeavePackage weavePackage) {
        cv = this.wrapApiCallsForSupportability(cv);
        return cv;
    }

    ClassVisitor wrapApiCallsForSupportability(ClassVisitor cv) {
        return new ClassVisitor(458752, cv){

            @Override
            public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                return new GeneratorAdapter(458752, mv, access, methodName, methodDesc){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        Method currentMethod = new Method(name, desc);
                        Collection methods = TRACKED_API_INTERNAL_NAME_TO_METHOD_NAMES.get(owner);
                        if (methods != null && methods.contains(currentMethod)) {
                            this.setCurrentApiSource(AgentPostprocessors.this.weavePackageType);
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                            this.unsetCurrentApiSource();
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    }

                    private void setCurrentApiSource(WeavePackageType weavePackageType) {
                        this.getStatic(Type.getType(AgentBridge.class), "currentApiSource", Type.getType(ThreadLocal.class));
                        this.getStatic(Type.getType(WeavePackageType.class), weavePackageType.name(), Type.getType(WeavePackageType.class));
                        this.invokeVirtual(Type.getType(ThreadLocal.class), new Method("set", "(Ljava/lang/Object;)V"));
                    }

                    private void unsetCurrentApiSource() {
                        this.getStatic(Type.getType(AgentBridge.class), "currentApiSource", Type.getType(ThreadLocal.class));
                        this.invokeVirtual(Type.getType(ThreadLocal.class), new Method("remove", "()V"));
                    }

                    @Override
                    public void visitMaxs(int maxStack, int maxLocals) {
                        super.visitMaxs(maxStack + 2, maxLocals);
                    }
                };
            }
        };
    }

    void addTrackedApiMethods(Multimap<String, Method> methodsToAdd) {
        ImmutableMultimap<String, Method> updatedMultimap = ImmutableMultimap.builder().putAll(TRACKED_API_INTERNAL_NAME_TO_METHOD_NAMES).putAll(methodsToAdd).build();
        TRACKED_API_INTERNAL_NAME_TO_METHOD_NAMES = updatedMultimap;
    }
}

