/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.glassfish;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.jmx.values.Glassfish2JmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class Glassfish2StartUpPointCut
extends PointCut
implements EntryInvocationHandler {
    private boolean addedJmx = false;

    public Glassfish2StartUpPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(Glassfish2StartUpPointCut.class.getName(), "glassfish_instrumentation", true), Glassfish2StartUpPointCut.createClassMatcher(), Glassfish2StartUpPointCut.createMethodMatcher());
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("com/sun/enterprise/server/PEMain");
    }

    private static MethodMatcher createMethodMatcher() {
        return Glassfish2StartUpPointCut.createExactMethodMatcher("run", "(Ljava/lang/String;)V");
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!this.addedJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new Glassfish2JmxValues());
            this.addedJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Glassfish 2");
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }
}

