/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.StripExceptionConfig;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StripExceptionConfigImpl
extends BaseConfig
implements StripExceptionConfig {
    public static final String ENABLED = "enabled";
    public static final String WHITELIST = "whitelist";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.strip_exception_messages.";
    private boolean isEnabled;
    private final Set<String> whitelist;

    private StripExceptionConfigImpl(Map<String, Object> props, boolean highSecurity) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.isEnabled = this.getProperty(ENABLED, highSecurity);
        this.whitelist = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(WHITELIST)));
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    static StripExceptionConfig createStripExceptionConfig(Map<String, Object> settings, boolean highSecurity) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new StripExceptionConfigImpl(settings, highSecurity);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        Agent.LOG.info(MessageFormat.format("Exception messages will{0} be stripped before sending to New Relic", this.isEnabled() ? "" : " not"));
    }
}

