/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.commands;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.Command;
import com.newrelic.agent.commands.RestartCommand;
import com.newrelic.agent.commands.ShutdownCommand;
import com.newrelic.agent.commands.UnknownCommand;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.util.JSONException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class CommandParser
extends AbstractService
implements HarvestListener,
AgentConfigListener {
    private final Map<String, Command> commands = new HashMap<String, Command>();
    private boolean enabled = true;
    private Set<String> commandBlacklist = new HashSet<String>();
    private List<Map<Long, Object>> unsentCommandData = new ArrayList<Map<Long, Object>>();

    public CommandParser() {
        super(CommandParser.class.getSimpleName());
    }

    public void addCommands(Command ... commands) {
        for (Command command : commands) {
            this.commands.put(command.getName(), command);
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        List<List<?>> commands;
        String msg;
        IRPMService rpmService = ServiceFactory.getRPMService(appName);
        Iterator<Map<Long, Object>> iterator = this.unsentCommandData.iterator();
        while (iterator.hasNext()) {
            Map<Long, Object> result = iterator.next();
            try {
                rpmService.sendCommandResults(result);
                iterator.remove();
            }
            catch (HttpError e) {
                if (e.discardHarvestData()) {
                    iterator.remove();
                    continue;
                }
                msg = MessageFormat.format("Unable to send agent command feedback. Data will be retried on the next harvest. Command results: {0}", result.toString());
                this.getLogger().fine(msg);
            }
            catch (Exception e) {
                iterator.remove();
                msg = MessageFormat.format("Unable to send agent command feedback. Data will be dropped. Command results: {0}", result.toString());
                this.getLogger().fine(msg);
            }
        }
        try {
            commands = rpmService.getAgentCommands();
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Unable to get agent commands - {0}", e.toString());
            this.getLogger().log(Level.FINEST, e, e.toString());
            return;
        }
        Map<Long, Object> commandResults = this.processCommands(rpmService, commands);
        try {
            rpmService.sendCommandResults(commandResults);
        }
        catch (HttpError e) {
            if (!e.discardHarvestData()) {
                this.unsentCommandData.add(commandResults);
                msg = MessageFormat.format("Unable to send agent command feedback. Data will be retried on the next harvest. Command results: {0}", commandResults.toString());
                this.getLogger().fine(msg);
            }
        }
        catch (Exception e) {
            msg = MessageFormat.format("Unable to send agent command feedback. Command results: {0}", commandResults.toString());
            this.getLogger().fine(msg);
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    Command getCommand(String name) throws UnknownCommand {
        Agent.LOG.finer(MessageFormat.format("Process command \"{0}\"", name));
        Command c = this.commands.get(name);
        if (c == null) {
            throw new UnknownCommand("Unknown command " + name);
        }
        return c;
    }

    Map<Long, Object> processCommands(IRPMService rpmService, List<List<?>> commands) {
        HashMap<Long, Object> results = new HashMap<Long, Object>();
        int count = 0;
        for (List<?> agentCommand : commands) {
            if (agentCommand.size() == 2) {
                Object id = agentCommand.get(0);
                if (id instanceof Number) {
                    try {
                        Map commandMap = (Map)agentCommand.get(1);
                        String name = (String)commandMap.get("name");
                        Map args = (Map)commandMap.get("arguments");
                        if (args == null) {
                            args = Collections.EMPTY_MAP;
                        }
                        if (this.isCommandAllowed(name)) {
                            Command command = this.getCommand(name);
                            Map returnValue = command.process(rpmService, args);
                            results.put(((Number)id).longValue(), returnValue);
                            this.getLogger().finer(MessageFormat.format("Agent command \"{0}\" return value: {1}", name, returnValue));
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().severe(MessageFormat.format("Unable to parse command : {0}", e.toString()));
                        this.getLogger().fine(MessageFormat.format("Unable to parse command", e));
                        results.put(((Number)id).longValue(), new JSONException(e));
                    }
                } else {
                    this.invalidCommand(rpmService, count, "Invalid command id " + id, agentCommand);
                }
            } else {
                this.invalidCommand(rpmService, count, "Unable to parse command", agentCommand);
            }
            ++count;
        }
        return results;
    }

    private boolean isCommandAllowed(String name) {
        if (this.commandBlacklist.contains(name)) {
            this.getLogger().fine(MessageFormat.format("Agent command \"{0}\" ignored due to command_parser blacklist", name));
            return false;
        }
        return true;
    }

    private void invalidCommand(IRPMService rpmService, int index, String message, List<?> agentCommand) {
        this.getLogger().severe(MessageFormat.format("Unable to parse command : {0} ({1})", message, agentCommand.toString()));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        IAgent agent = ServiceFactory.getAgent();
        this.addCommands(new ShutdownCommand(agent), new RestartCommand());
        this.updateCommandParserConfig(config);
        if (this.isEnabled()) {
            ServiceFactory.getHarvestService().addHarvestListener(this);
        } else {
            this.getLogger().log(Level.CONFIG, "The command parser is disabled");
        }
    }

    private void updateCommandParserConfig(AgentConfig agentConfig) {
        try {
            Map props = (Map)agentConfig.getProperty("command_parser");
            if (props != null) {
                Boolean enabled = (Boolean)props.get("enabled");
                if (enabled != null && this.enabled != enabled) {
                    this.enabled = enabled;
                    if (this.enabled) {
                        ServiceFactory.getHarvestService().addHarvestListener(this);
                    } else {
                        ServiceFactory.getHarvestService().removeHarvestListener(this);
                    }
                }
                String commandBlacklist = (String)props.get("blacklist");
                HashSet<String> blacklist = new HashSet<String>();
                if (commandBlacklist != null && !commandBlacklist.trim().isEmpty()) {
                    for (String command : commandBlacklist.split(",[\\s]*")) {
                        if (command.equals("shutdown") || command.equals("restart")) continue;
                        blacklist.add(command);
                    }
                }
                this.commandBlacklist = blacklist;
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Unable to parse the command_parser section in newrelic.yml");
        }
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.updateCommandParserConfig(agentConfig);
    }

    @Override
    protected void doStop() {
    }
}

