/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Segment;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.SimpleStatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.transaction.TransactionCache;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.OutboundHeaders;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TransactionActivity {
    public static final int NOT_REPORTED = -1;
    private volatile List<Tracer> tracers;
    private Tracer rootTracer;
    private Tracer lastTracer;
    private final TransactionStats transactionStats;
    private Transaction transaction;
    private final TransactionCache transactionCache;
    private final long threadId;
    private Segment segment;
    private final boolean notInThreadLocal;
    private final long cpuStartTimeInNanos;
    private long totalCpuTimeInNanos;
    private boolean sendsResponse = false;
    private volatile String asyncContext;
    private int tracerStartLock;
    private volatile boolean activityIsIgnored = false;
    private boolean flyweightInProgress;
    private int activityId;
    private volatile boolean isDone = false;
    private static final ThreadLocal<TransactionActivity> activityHolder = new ThreadLocal<TransactionActivity>(){

        @Override
        public TransactionActivity get() {
            return (TransactionActivity)super.get();
        }

        @Override
        public void set(TransactionActivity value) {
            super.set(value);
        }

        @Override
        public void remove() {
            super.remove();
        }
    };
    private static final Tracer FLYWEIGHT_PLACEHOLDER = new Tracer(){

        public void setMetricName(String ... metricNameParts) {
        }

        public void setMetricNameFormatInfo(String metricName, String transactionSegmentName, String transactionSegmentUri) {
        }

        public TracedMethod getParentTracedMethod() {
            return null;
        }

        public void finish(Throwable throwable) {
        }

        public void finish(int opcode, Object returnValue) {
        }

        @Override
        public long getDurationInMilliseconds() {
            return 0L;
        }

        @Override
        public long getDuration() {
            return 0L;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }

        @Override
        public boolean isTransactionSegment() {
            return false;
        }

        @Override
        public boolean isParent() {
            return false;
        }

        @Override
        public void setParentTracer(Tracer tracer) {
        }

        public boolean isMetricProducer() {
            return true;
        }

        @Override
        public boolean isChildHasStackTrace() {
            return false;
        }

        @Override
        public String getTransactionSegmentUri() {
            return null;
        }

        @Override
        public String getTransactionSegmentName() {
            return null;
        }

        @Override
        public TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
            return null;
        }

        @Override
        public long getStartTimeInMilliseconds() {
            return 0L;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getRunningDurationInNanos() {
            return 0L;
        }

        @Override
        public Tracer getParentTracer() {
            return null;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public String getMetricName() {
            return null;
        }

        @Override
        public long getExclusiveDuration() {
            return 0L;
        }

        @Override
        public long getEndTimeInMilliseconds() {
            return 0L;
        }

        @Override
        public long getEndTime() {
            return 0L;
        }

        @Override
        public ClassMethodSignature getClassMethodSignature() {
            return null;
        }

        @Override
        public void childTracerFinished(Tracer child) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public void setRollupMetricNames(String ... metricNames) {
        }

        public void nameTransaction(TransactionNamePriority namePriority) {
        }

        public void addRollupMetricName(String ... metricNameParts) {
        }

        public void addExclusiveRollupMetricName(String ... metricNameParts) {
        }

        @Override
        public void setAttribute(String key, Object value) {
        }

        @Override
        public void removeAttribute(String key) {
        }

        @Override
        public Object getAttribute(String key) {
            return null;
        }

        @Override
        public TransactionActivity getTransactionActivity() {
            return null;
        }

        @Override
        public boolean isAsync() {
            return false;
        }

        public void setCustomMetricPrefix(String prefix) {
        }

        @Override
        public void removeTransactionSegment() {
        }

        public void setTrackChildThreads(boolean shouldTrack) {
        }

        public boolean trackChildThreads() {
            return false;
        }

        public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        }

        public void readInboundResponseHeaders(InboundHeaders inboundResponseHeaders) {
        }

        public void reportAsExternal(com.newrelic.api.agent.ExternalParameters externalParameters) {
        }

        public void reportAsExternal(ExternalParameters externalParameters) {
        }

        @Override
        public void setTransactionActivity(TransactionActivity syncTxa) {
        }

        @Override
        public void markFinishTime() {
        }

        @Override
        public String getGuid() {
            return null;
        }

        @Override
        public long getStartTimeInMillis() {
            return 0L;
        }

        @Override
        public com.newrelic.api.agent.ExternalParameters getExternalParameters() {
            return null;
        }
    };

    public static void clear() {
        activityHolder.remove();
        Agent.LOG.log(Level.FINEST, "TransactionActivity.clear()");
    }

    public static void set(TransactionActivity txa) {
        activityHolder.set(txa);
        Agent.LOG.log(Level.FINEST, "TransactionActivity.set({0})", txa);
    }

    public static TransactionActivity get() {
        TransactionActivity result = activityHolder.get();
        return result;
    }

    public static TransactionActivity create(Transaction transaction, int id) {
        TransactionActivity txa = new TransactionActivity(transaction, Thread.currentThread().getId(), Thread.currentThread().getName(), false);
        txa.activityId = id;
        activityHolder.set(txa);
        Agent.LOG.log(Level.FINE, "created {0} for {1}", txa, transaction);
        return txa;
    }

    public static TransactionActivity createWithoutHolder(Transaction transaction, int id, String asyncContext) {
        TransactionActivity txa = new TransactionActivity(transaction, -1L, asyncContext, true);
        txa.activityId = id;
        Agent.LOG.log(Level.FINE, "created {0} for {1}", txa, transaction);
        return txa;
    }

    public boolean canCreateTransactionSegment() {
        if (this.transaction == null) {
            return ServiceFactory.getTransactionTraceService().isEnabled();
        }
        return this.transaction.shouldGenerateTransactionSegment();
    }

    private TransactionActivity(Transaction tx, long threadId, String asyncContext, boolean notInThreadLocal) {
        this.transaction = tx;
        TransactionTraceService ttService = ServiceFactory.getTransactionTraceService();
        this.tracers = null;
        this.transactionStats = new TransactionStats();
        this.transactionCache = new TransactionCache();
        this.threadId = threadId;
        this.asyncContext = asyncContext;
        this.notInThreadLocal = notInThreadLocal;
        if (ttService.isEnabled()) {
            if (ttService.isThreadCpuTimeEnabled()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                this.cpuStartTimeInNanos = threadMXBean.getCurrentThreadCpuTime();
                this.totalCpuTimeInNanos = 0L;
            } else {
                this.cpuStartTimeInNanos = -1L;
                this.totalCpuTimeInNanos = -1L;
            }
        } else {
            this.cpuStartTimeInNanos = -1L;
            this.totalCpuTimeInNanos = -1L;
        }
    }

    public TransactionActivity() {
        String realClassName = this.getClass().getSimpleName();
        if (!realClassName.startsWith("Mock")) {
            throw new IllegalStateException("the public constructor is only for test purposes.");
        }
        this.tracers = null;
        this.transactionStats = null;
        this.transactionCache = null;
        this.notInThreadLocal = false;
        this.threadId = -1L;
        this.asyncContext = "MockThread";
        this.cpuStartTimeInNanos = -1L;
        this.totalCpuTimeInNanos = -1L;
    }

    public void markAsResponseSender() {
        Agent.LOG.log(Level.FINEST, "Transaction Activity {0} marked as the response sender", this);
        this.sendsResponse = true;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getAsyncContext() {
        return this.asyncContext;
    }

    public void setAsyncContext(String asyncContext) {
        this.asyncContext = asyncContext;
    }

    public TransactionStats getTransactionStats() {
        return this.transactionStats;
    }

    public List<Tracer> getTracers() {
        return Collections.unmodifiableList(this.tracers == null ? Collections.emptyList() : this.tracers);
    }

    public long getTotalCpuTime() {
        return this.totalCpuTimeInNanos;
    }

    public boolean isNotInThreadLocal() {
        return this.notInThreadLocal;
    }

    public void setTotalCpuTime(long totalCpuTimeInNanos) {
        this.totalCpuTimeInNanos = totalCpuTimeInNanos;
    }

    public void setToIgnore() {
        this.activityIsIgnored = true;
    }

    public boolean isIgnored() {
        return this.activityIsIgnored;
    }

    void setOwningTransactionIsIgnored(boolean newState) {
        this.activityIsIgnored = newState;
    }

    public Tracer tracerStarted(Tracer tracer) {
        Tracer tr = this.addTracerToStack(tracer);
        if (tr != null && this.getTransaction() != null && tr.isTransactionSegment()) {
            this.getTransaction().getTransactionCounts().addTracer();
        }
        return tr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tracer addTracerToStack(Tracer tracer) {
        if (this.isTracerStartLocked()) {
            Agent.LOG.log(Level.FINER, "tracerStarted ignored: tracerStartLock is already active");
            return null;
        }
        if (!this.isStarted()) {
            if (!(tracer instanceof TransactionActivityInitiator)) return null;
            this.setRootTracer(tracer);
            return tracer;
        } else if (tracer.getParentTracer() != null) {
            this.lastTracer = tracer;
            this.addTracer(tracer);
            return tracer;
        } else {
            if (!Agent.LOG.isFinestEnabled()) return tracer;
            Agent.LOG.log(Level.FINEST, "tracerStarted: {0} cannot be added: no parent pointer", tracer);
            return null;
        }
    }

    public void tracerFinished(Tracer tracer, int opcode) {
        if (tracer instanceof SkipTracer) {
            return;
        }
        if (tracer != this.lastTracer) {
            this.failed(this, tracer, opcode);
        } else if (tracer == this.rootTracer) {
            this.finished(this.rootTracer, opcode);
        } else {
            this.lastTracer = tracer.getParentTracer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failed(TransactionActivity activity, Tracer tracer, int opcode) {
        Agent.LOG.log(Level.SEVERE, "Inconsistent state!  tracer != last tracer for {0} ({1} != {2})", this, tracer, this.lastTracer);
        try {
            this.transaction.activityFailedOrIgnored(this, opcode);
        }
        finally {
            if (!this.isNotInThreadLocal()) {
                activityHolder.remove();
            }
        }
    }

    private void finished(Tracer tracer, int opcode) {
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.log(Level.FINEST, "tracerFinished: {0} opcode: {1} in transactionActivity {2}", tracer, opcode, this);
        }
        try {
            if (this.transaction != null) {
                if (!this.activityIsIgnored) {
                    this.recordCpu();
                    if (this.sendsResponse) {
                        Agent.LOG.log(Level.FINER, "Txa {0} marked as response sender", this);
                        this.getTransaction().getTransactionTimer().markResponseTime(this.rootTracer.getEndTime());
                        if (this.getTransaction().getDispatcher() != null) {
                            this.getTransaction().getInboundHeaderState();
                            this.getTransaction().getDispatcher().transactionActivityWithResponseFinished();
                        }
                    }
                    this.transaction.activityFinished(this, tracer, opcode);
                } else {
                    this.transaction.activityFailedOrIgnored(this, opcode);
                }
            }
            this.isDone = true;
        }
        finally {
            if (!this.isNotInThreadLocal()) {
                activityHolder.remove();
            }
        }
    }

    public boolean isStarted() {
        return this.rootTracer != null;
    }

    public boolean isFinished() {
        return this.isDone;
    }

    public boolean isLeaf() {
        return this.flyweightInProgress || this.lastTracer != null && this.lastTracer.isLeaf();
    }

    public void recordCpu() {
        if (this.cpuStartTimeInNanos != -1L && this.totalCpuTimeInNanos == 0L) {
            this.totalCpuTimeInNanos = ServiceFactory.getTransactionTraceService().getThreadMXBean().getCurrentThreadCpuTime() - this.cpuStartTimeInNanos;
        }
    }

    public void addTracer(Tracer tracer) {
        if (tracer.isTransactionSegment() && this.getTransaction() != null) {
            if (this.tracers == null) {
                this.tracers = new ArrayList<Tracer>();
            }
            this.tracers.add(tracer);
        }
    }

    private void setRootTracer(Tracer tracer) {
        this.rootTracer = tracer;
        this.lastTracer = tracer;
        if (tracer instanceof DefaultTracer) {
            DefaultTracer dt = (DefaultTracer)tracer;
            dt.setAttribute("async_context", this.asyncContext, !tracer.isAsync());
        }
        if (!tracer.isAsync() && this.transaction != null) {
            this.transaction.activityStarted(this);
        }
    }

    public void setSegment(Segment segment) {
        this.segment = segment;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void lockTracerStart() {
        --this.tracerStartLock;
    }

    public void unlockTracerStart() {
        ++this.tracerStartLock;
    }

    public boolean isTracerStartLocked() {
        return this.tracerStartLock < 0;
    }

    public boolean checkTracerStart() {
        if (this.isTracerStartLocked()) {
            return false;
        }
        if (!this.isLeaf() && !this.activityIsIgnored) {
            this.lockTracerStart();
            return true;
        }
        return false;
    }

    public Tracer getLastTracer() {
        return this.flyweightInProgress ? FLYWEIGHT_PLACEHOLDER : this.lastTracer;
    }

    public TracedMethod startFlyweightTracer() {
        try {
            if (this.rootTracer == null || this.flyweightInProgress || this.lastTracer.isLeaf()) {
                return null;
            }
            this.flyweightInProgress = true;
            return this.lastTracer;
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, t, "Error starting tracer");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishFlyweightTracer(TracedMethod parent, long startInNanos, long finishInNanos, String className, String methodName, String methodDesc, String metricName, String[] rollupMetricNames) {
        try {
            if (parent instanceof DefaultTracer) {
                DefaultTracer parentTracer = (DefaultTracer)parent;
                long duration = finishInNanos - startInNanos;
                if (!this.flyweightInProgress) {
                    Agent.LOG.log(Level.FINEST, "Error finishing tracer - the last tracer is of the wrong type.");
                }
                if (duration < 0L) {
                    Agent.LOG.log(Level.FINEST, "A tracer finished with a negative duration.");
                    return;
                }
                this.transactionStats.getScopedStats().getResponseTimeStats(metricName).recordResponseTimeInNanos(duration);
                if (Agent.isDebugEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Finished flyweight tracer {0} ({1}.{2}{3})", metricName, className, methodName, methodDesc);
                }
                if (rollupMetricNames != null) {
                    SimpleStatsEngine unscopedStats = this.transactionStats.getUnscopedStats();
                    for (String name : rollupMetricNames) {
                        unscopedStats.getResponseTimeStats(name).recordResponseTimeInNanos(duration);
                    }
                }
                parentTracer.childTracerFinished(duration);
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, t, "Error finishing tracer");
        }
        finally {
            this.flyweightInProgress = false;
        }
    }

    public void startAsyncActivity(Transaction transaction, int activityId, Tracer parentTracer) {
        this.transaction = transaction;
        this.activityId = activityId;
        transaction.activityStarted(this);
        this.startAsyncTracerLimitCleanup();
        if (parentTracer != null) {
            this.rootTracer.setParentTracer(parentTracer);
        } else {
            Agent.LOG.log(Level.FINE, "TransactionActivity.startAsyncActivity: parentTracer is null.");
        }
    }

    void startAsyncTracerLimitCleanup() {
        if (this.canCreateTransactionSegment()) {
            int numTracers = this.tracers != null ? this.tracers.size() : 0;
            this.transaction.getTransactionCounts().addTracers(numTracers + 1);
        } else {
            this.rootTracer.removeTransactionSegment();
            this.tracers = Collections.EMPTY_LIST;
        }
    }

    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public TransactionCache getTransactionCache() {
        return this.transactionCache;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public int hashCode() {
        return this.activityId;
    }
}

