/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate3.infinispan;

import java.security.AccessController;
import java.util.Properties;
import org.hibernate.cache.infinispan.impl.ClassLoaderAwareCache;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.jpa.hibernate3.infinispan.InfinispanRegionFactory;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;

public class SharedInfinispanRegionFactory
extends InfinispanRegionFactory {
    public SharedInfinispanRegionFactory() {
    }

    public SharedInfinispanRegionFactory(Properties props) {
        super(props);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager(Properties properties) {
        String container = properties.getProperty("hibernate.cache.infinispan.container", "hibernate");
        ServiceName serviceName = EmbeddedCacheManagerService.getServiceName((String)container);
        ServiceContainer registry = SharedInfinispanRegionFactory.currentServiceContainer();
        return (EmbeddedCacheManager)registry.getRequiredService(serviceName).getValue();
    }

    protected ClassLoaderAwareCache createCacheWrapper(AdvancedCache cache) {
        cache.start();
        return super.createCacheWrapper(cache);
    }

    @Override
    public void stop() {
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

