/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends NavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private Map<String, List<ConfigNavigationCase>> caseListMap;
    private Set<String> wildCardSet;
    private boolean navigationConfigured;

    public NavigationHandlerImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        applicationFactory.getApplication();
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        if (applicationAssociate != null) {
            this.caseListMap = applicationAssociate.getNavigationCaseListMappings();
            this.wildCardSet = applicationAssociate.getNavigationWildCardList();
            this.navigationConfigured = this.wildCardSet != null && this.caseListMap != null;
        }
    }

    NavigationHandlerImpl(ApplicationAssociate applicationAssociate) {
        if (applicationAssociate == null) {
            throw new NullPointerException();
        }
        this.caseListMap = applicationAssociate.getNavigationCaseListMappings();
        this.wildCardSet = applicationAssociate.getNavigationWildCardList();
        this.navigationConfigured = this.wildCardSet != null && this.caseListMap != null;
    }

    public void handleNavigation(FacesContext facesContext, String string, String string2) {
        if (facesContext == null) {
            String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No navigation rule found for null outcome and viewId " + facesContext.getViewRoot().getViewId() + " Explicitly remain on the current view ");
            }
            return;
        }
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (caseStruct != null) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            assert (null != viewHandler);
            if (caseStruct.navCase.hasRedirect()) {
                String string4 = viewHandler.getActionURL(facesContext, caseStruct.viewId);
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Redirecting to path " + string4 + " for outcome " + string2 + "and viewId " + caseStruct.viewId);
                    }
                    externalContext.redirect(externalContext.encodeActionURL(string4));
                }
                catch (IOException iOException) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "jsf.redirect_failed_error", string4);
                    }
                    throw new FacesException(iOException.getMessage(), (Throwable)iOException);
                }
                facesContext.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot uIViewRoot = viewHandler.createView(facesContext, caseStruct.viewId);
                facesContext.setViewRoot(uIViewRoot);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private CaseStruct getViewId(FacesContext facesContext, String string, String string2) {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        String string3 = uIViewRoot != null ? uIViewRoot.getViewId() : null;
        CaseStruct caseStruct = null;
        if (string3 != null && (caseStruct = this.findExactMatch(string3, string, string2)) == null) {
            caseStruct = this.findWildCardMatch(string3, string, string2);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(string, string2);
        }
        if (caseStruct == null && logger.isLoggable(Level.WARNING)) {
            if (string == null) {
                logger.log(Level.FINE, "jsf.navigation.no_matching_outcome", new Object[]{string3, string2});
            } else {
                logger.log(Level.FINE, "jsf.navigation.no_matching_outcome_action", new Object[]{string3, string2, string});
            }
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(String string, String string2, String string3) {
        if (!this.navigationConfigured) {
            return null;
        }
        List<ConfigNavigationCase> list = this.caseListMap.get(string);
        if (list == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(list, string2, string3);
    }

    private CaseStruct findWildCardMatch(String string, String string2, String string3) {
        CaseStruct caseStruct = null;
        if (!this.navigationConfigured) {
            return null;
        }
        for (String string4 : this.wildCardSet) {
            if (!string.startsWith(string4)) continue;
            String string5 = new StringBuilder(32).append(string4).append('*').toString();
            List<ConfigNavigationCase> list = this.caseListMap.get(string5);
            if (list == null) {
                return null;
            }
            caseStruct = this.determineViewFromActionOutcome(list, string2, string3);
            if (caseStruct == null) continue;
            break;
        }
        return caseStruct;
    }

    private CaseStruct findDefaultMatch(String string, String string2) {
        if (!this.navigationConfigured) {
            return null;
        }
        List<ConfigNavigationCase> list = this.caseListMap.get("*");
        if (list == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(list, string, string2);
    }

    private CaseStruct determineViewFromActionOutcome(List<ConfigNavigationCase> list, String string, String string2) {
        CaseStruct caseStruct = new CaseStruct();
        for (ConfigNavigationCase configNavigationCase : list) {
            String string3 = configNavigationCase.getFromAction();
            String string4 = configNavigationCase.getFromOutcome();
            String string5 = configNavigationCase.getToViewId();
            if (string3 != null && string4 != null && string3.equals(string) && string4.equals(string2)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = configNavigationCase;
                return caseStruct;
            }
            if (string3 == null && string4 != null && string4.equals(string2)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = configNavigationCase;
                return caseStruct;
            }
            if (string3 != null && string4 == null && string3.equals(string)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = configNavigationCase;
                return caseStruct;
            }
            if (string3 != null || string4 != null) continue;
            caseStruct.viewId = string5;
            caseStruct.navCase = configNavigationCase;
            return caseStruct;
        }
        return null;
    }

    private static class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        private CaseStruct() {
        }
    }
}

