/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class ActionListenerImpl
implements ActionListener {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public void processAction(ActionEvent actionEvent) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("processAction({0})", actionEvent.getComponent().getId()));
        }
        UIComponent uIComponent = actionEvent.getComponent();
        ActionSource actionSource = (ActionSource)uIComponent;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String string = null;
        MethodBinding methodBinding = actionSource.getAction();
        if (methodBinding != null) {
            try {
                Object object = methodBinding.invoke(facesContext, null);
                if (null != object) {
                    string = object.toString();
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, methodNotFoundException.getMessage(), methodNotFoundException);
                }
                throw new FacesException(methodBinding.getExpressionString() + ": " + methodNotFoundException.getMessage(), (Throwable)methodNotFoundException);
            }
            catch (EvaluationException evaluationException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, evaluationException.getMessage(), evaluationException);
                }
                throw new FacesException(methodBinding.getExpressionString() + ": " + evaluationException.getMessage(), (Throwable)evaluationException);
            }
        }
        NavigationHandler navigationHandler = application.getNavigationHandler();
        navigationHandler.handleNavigation(facesContext, null != methodBinding ? methodBinding.getExpressionString() : null, string);
        facesContext.renderResponse();
    }
}

