/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.web.deployment.ConcurrentReferenceHashMap;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.msc.service.ServiceName;

public class WebInjectionContainer
implements InstanceManager {
    private static final ThreadLocal<WebInjectionContainer> CURRENT_INJECTION_CONTAINER = new ThreadLocal();
    private final ClassLoader classloader;
    private final Map<String, ComponentInstantiator> webComponentInstantiatorMap = new HashMap<String, ComponentInstantiator>();
    private final Set<ServiceName> serviceNames = new HashSet<ServiceName>();
    private final Map<Object, ManagedReference> instanceMap;

    public WebInjectionContainer(ClassLoader classloader) {
        this.classloader = classloader;
        this.instanceMap = new ConcurrentReferenceHashMap<Object, ManagedReference>(256, 0.75f, Runtime.getRuntime().availableProcessors(), ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
    }

    ClassLoader getDefaultClassLoader() {
        return this.classloader;
    }

    public void addInstantiator(String className, ComponentInstantiator instantiator) {
        this.webComponentInstantiatorMap.put(className, instantiator);
        this.serviceNames.addAll(instantiator.getServiceNames());
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        ManagedReference reference = this.instanceMap.remove(instance);
        if (reference != null) {
            reference.release();
        }
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(this.classloader.loadClass(className));
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        ComponentInstantiator instantiator = this.webComponentInstantiatorMap.get(clazz.getName());
        if (instantiator != null) {
            return this.instantiate(instantiator);
        }
        return clazz.newInstance();
    }

    public void newInstance(Object arg0) throws IllegalAccessException, InvocationTargetException, NamingException {
        ComponentInstantiator instantiator = this.webComponentInstantiatorMap.get(arg0.getClass().getName());
        if (instantiator != null) {
            this.instanceMap.put(arg0, instantiator.initializeInstance(arg0));
        }
    }

    public Object newInstance(String className, ClassLoader cl) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        ComponentInstantiator instantiator = this.webComponentInstantiatorMap.get(className);
        if (instantiator != null) {
            return this.instantiate(instantiator);
        }
        return cl.loadClass(className).newInstance();
    }

    private Object instantiate(ComponentInstantiator instantiator) {
        ManagedReference reference = instantiator.getReference();
        this.instanceMap.put(reference.getInstance(), reference);
        return reference.getInstance();
    }

    public Set<ServiceName> getServiceNames() {
        return Collections.unmodifiableSet(this.serviceNames);
    }

    public static void setCurrentInjectionContainer(WebInjectionContainer webInjectionContainer) {
        CURRENT_INJECTION_CONTAINER.set(webInjectionContainer);
    }

    public static WebInjectionContainer getCurrentInjectionContainer() {
        return CURRENT_INJECTION_CONTAINER.get();
    }
}

