/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebConnectorService;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class WebConnectorAdd
extends AbstractAddStepHandler {
    static final WebConnectorAdd INSTANCE = new WebConnectorAdd();

    private WebConnectorAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        model.get(WebConnectorDefinition.NAME.getName()).set(address.getLastElement().getValue());
        for (SimpleAttributeDefinition def : WebConnectorDefinition.CONNECTOR_ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
        WebConnectorDefinition.VIRTUAL_SERVER.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        this.launchServices(context, address, fullModel, verificationHandler, newControllers);
    }

    protected void launchServices(OperationContext context, PathAddress address, ModelNode fullModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = address.getLastElement().getValue();
        String bindingRef = WebConnectorDefinition.SOCKET_BINDING.resolveModelAttribute(context, fullModel).asString();
        boolean enabled = WebConnectorDefinition.ENABLED.resolveModelAttribute(context, fullModel).asBoolean();
        String protocol = WebConnectorDefinition.PROTOCOL.resolveModelAttribute(context, fullModel).asString();
        String scheme = WebConnectorDefinition.SCHEME.resolveModelAttribute(context, fullModel).asString();
        WebConnectorService service = new WebConnectorService(protocol, scheme);
        service.setSecure(WebConnectorDefinition.SECURE.resolveModelAttribute(context, fullModel).asBoolean());
        service.setEnableLookups(WebConnectorDefinition.ENABLE_LOOKUPS.resolveModelAttribute(context, fullModel).asBoolean());
        ModelNode resolved = WebConnectorDefinition.PROXY_NAME.resolveModelAttribute(context, fullModel);
        if (resolved.isDefined()) {
            service.setProxyName(resolved.asString());
        }
        if ((resolved = WebConnectorDefinition.PROXY_PORT.resolveModelAttribute(context, fullModel)).isDefined()) {
            service.setProxyPort(resolved.asInt());
        }
        if ((resolved = WebConnectorDefinition.MAX_POST_SIZE.resolveModelAttribute(context, fullModel)).isDefined()) {
            service.setMaxPostSize(resolved.asInt());
        }
        if ((resolved = WebConnectorDefinition.MAX_SAVE_POST_SIZE.resolveModelAttribute(context, fullModel)).isDefined()) {
            service.setMaxSavePostSize(resolved.asInt());
        }
        if ((resolved = WebConnectorDefinition.MAX_CONNECTIONS.resolveModelAttribute(context, fullModel)).isDefined()) {
            service.setMaxConnections(resolved.asInt());
        }
        if ((resolved = WebConnectorDefinition.VIRTUAL_SERVER.resolveModelAttribute(context, fullModel)).isDefined()) {
            LinkedList<String> vServers = new LinkedList<String>();
            for (ModelNode vServer : resolved.asList()) {
                vServers.add(vServer.asString());
            }
            service.setVirtualServers(vServers);
        }
        if (fullModel.get(new String[]{WebExtension.SSL_PATH.getKey(), WebExtension.SSL_PATH.getValue()}).isDefined()) {
            service.setSsl(this.resolveSslExpressions(context, fullModel.get(new String[]{WebExtension.SSL_PATH.getKey(), WebExtension.SSL_PATH.getValue()})));
        }
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}), (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getServer()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding());
        resolved = WebConnectorDefinition.REDIRECT_BINDING.resolveModelAttribute(context, fullModel);
        if (resolved.isDefined()) {
            serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{resolved.asString()}), SocketBinding.class, service.getRedirect());
        } else {
            resolved = WebConnectorDefinition.REDIRECT_PORT.resolveModelAttribute(context, fullModel);
            if (resolved.isDefined()) {
                service.setRedirectPort(resolved.asInt());
            }
        }
        resolved = WebConnectorDefinition.PROXY_BINDING.resolveModelAttribute(context, fullModel);
        if (resolved.isDefined()) {
            serviceBuilder.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{resolved.asString()}), OutboundSocketBinding.class, service.getProxy());
        }
        if ((resolved = WebConnectorDefinition.EXECUTOR.resolveModelAttribute(context, fullModel)).isDefined()) {
            String executorRef = resolved.asString();
            serviceBuilder.addDependency(ThreadsServices.executorName((String)executorRef), Executor.class, service.getExecutor());
        }
        serviceBuilder.setInitialMode(enabled ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER);
        if (enabled) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController serviceController = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
    }

    private ModelNode resolveSslExpressions(OperationContext context, ModelNode ssl) throws OperationFailedException {
        ModelNode result = new ModelNode();
        for (SimpleAttributeDefinition def : WebSSLDefinition.SSL_ATTRIBUTES) {
            result.get(def.getName()).set(def.resolveModelAttribute(context, ssl));
        }
        return result;
    }
}

