/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.util.PropUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Quota;
import javax.mail.QuotaAwareStore;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;

public class IMAPStore
extends Store
implements QuotaAwareStore,
ResponseHandler {
    public static final int RESPONSE = 1000;
    private final String name;
    private final int defaultPort;
    private final boolean isSSL;
    private final int blksize;
    private final int statusCacheTimeout;
    private final int appendBufferSize;
    private final int minIdleTime;
    private volatile int port;
    private String host;
    private String user;
    private String password;
    private String proxyAuthUser;
    private String authorizationID;
    private String saslRealm;
    private Namespaces namespaces;
    private boolean disableAuthLogin;
    private boolean disableAuthPlain;
    private boolean disableAuthNtlm;
    private boolean enableStartTLS;
    private boolean requireStartTLS;
    private boolean enableSASL;
    private String[] saslMechanisms;
    private boolean forcePasswordRefresh;
    private boolean enableImapEvents;
    private String guid;
    private volatile boolean connectionFailed;
    private volatile boolean forceClose;
    private final Object connectionFailedLock;
    private boolean debugusername;
    private boolean debugpassword;
    private PrintStream out;
    private boolean messageCacheDebug;
    private volatile Constructor folderConstructor;
    private volatile Constructor folderConstructorLI;
    private final ConnectionPool pool;
    private ResponseHandler nonStoreResponseHandler;

    public IMAPStore(Session session, URLName url) {
        this(session, url, "imap", false);
    }

    protected IMAPStore(Session session, URLName url, String name, boolean isSSL) {
        block34: {
            String s;
            boolean partialFetch;
            super(session, url);
            this.port = -1;
            this.disableAuthLogin = false;
            this.disableAuthPlain = false;
            this.disableAuthNtlm = false;
            this.enableStartTLS = false;
            this.requireStartTLS = false;
            this.enableSASL = false;
            this.forcePasswordRefresh = false;
            this.enableImapEvents = false;
            this.connectionFailed = false;
            this.forceClose = false;
            this.connectionFailedLock = new Object();
            this.folderConstructor = null;
            this.folderConstructorLI = null;
            this.nonStoreResponseHandler = new ResponseHandler(){

                @Override
                public void handleResponse(Response r) {
                    if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
                        IMAPStore.this.handleResponseCode(r);
                    }
                    if (IMAPStore.this.debug && r.isBYE()) {
                        IMAPStore.this.out.println("DEBUG: IMAPStore non-store connection dead");
                    }
                }
            };
            if (url != null) {
                name = url.getProtocol();
            }
            this.name = name;
            if (!isSSL) {
                isSSL = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".ssl.enable", false);
            }
            this.defaultPort = isSSL ? 993 : 143;
            this.isSSL = isSSL;
            this.debug = session.getDebug();
            this.debugusername = PropUtil.getBooleanSessionProperty(session, "mail.debug.auth.username", true);
            this.debugpassword = PropUtil.getBooleanSessionProperty(session, "mail.debug.auth.password", false);
            this.out = session.getDebugOut();
            if (this.out == null) {
                this.out = System.out;
            }
            if (!(partialFetch = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".partialfetch", true))) {
                this.blksize = -1;
                if (this.debug) {
                    this.out.println("DEBUG: mail.imap.partialfetch: false");
                }
            } else {
                this.blksize = PropUtil.getIntSessionProperty(session, "mail." + name + ".fetchsize", 16384);
                if (this.debug) {
                    this.out.println("DEBUG: mail.imap.fetchsize: " + this.blksize);
                }
            }
            this.statusCacheTimeout = PropUtil.getIntSessionProperty(session, "mail." + name + ".statuscachetimeout", 1000);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.statuscachetimeout: " + this.statusCacheTimeout);
            }
            this.appendBufferSize = PropUtil.getIntSessionProperty(session, "mail." + name + ".appendbuffersize", -1);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.appendbuffersize: " + this.appendBufferSize);
            }
            this.minIdleTime = PropUtil.getIntSessionProperty(session, "mail." + name + ".minidletime", 10);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.minidletime: " + this.minIdleTime);
            }
            if ((s = session.getProperty("mail." + name + ".proxyauth.user")) != null) {
                this.proxyAuthUser = s;
                if (this.debug) {
                    this.out.println("DEBUG: mail.imap.proxyauth.user: " + this.proxyAuthUser);
                }
            }
            this.disableAuthLogin = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".auth.login.disable", false);
            if (this.debug && this.disableAuthLogin) {
                this.out.println("DEBUG: disable AUTH=LOGIN");
            }
            this.disableAuthPlain = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".auth.plain.disable", false);
            if (this.debug && this.disableAuthPlain) {
                this.out.println("DEBUG: disable AUTH=PLAIN");
            }
            this.disableAuthNtlm = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".auth.ntlm.disable", false);
            if (this.debug && this.disableAuthNtlm) {
                this.out.println("DEBUG: disable AUTH=NTLM");
            }
            this.enableStartTLS = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".starttls.enable", false);
            if (this.debug && this.enableStartTLS) {
                this.out.println("DEBUG: enable STARTTLS");
            }
            this.requireStartTLS = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".starttls.required", false);
            if (this.debug && this.requireStartTLS) {
                this.out.println("DEBUG: require STARTTLS");
            }
            this.enableSASL = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".sasl.enable", false);
            if (this.debug && this.enableSASL) {
                this.out.println("DEBUG: enable SASL");
            }
            if (this.enableSASL && (s = session.getProperty("mail." + name + ".sasl.mechanisms")) != null && s.length() > 0) {
                if (this.debug) {
                    this.out.println("DEBUG: SASL mechanisms allowed: " + s);
                }
                Vector<String> v = new Vector<String>(5);
                StringTokenizer st = new StringTokenizer(s, " ,");
                while (st.hasMoreTokens()) {
                    String m = st.nextToken();
                    if (m.length() <= 0) continue;
                    v.addElement(m);
                }
                this.saslMechanisms = new String[v.size()];
                v.copyInto(this.saslMechanisms);
            }
            if ((s = session.getProperty("mail." + name + ".sasl.authorizationid")) != null) {
                this.authorizationID = s;
                if (this.debug) {
                    this.out.println("DEBUG: mail.imap.sasl.authorizationid: " + this.authorizationID);
                }
            }
            if ((s = session.getProperty("mail." + name + ".sasl.realm")) != null) {
                this.saslRealm = s;
                if (this.debug) {
                    this.out.println("DEBUG: mail.imap.sasl.realm: " + this.saslRealm);
                }
            }
            this.forcePasswordRefresh = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".forcepasswordrefresh", false);
            if (this.debug && this.forcePasswordRefresh) {
                this.out.println("DEBUG: enable forcePasswordRefresh");
            }
            this.enableImapEvents = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".enableimapevents", false);
            if (this.debug && this.enableImapEvents) {
                this.out.println("DEBUG: enable IMAP events");
            }
            this.messageCacheDebug = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".messagecache.debug", false);
            this.guid = session.getProperty("mail." + name + ".yahoo.guid");
            if (this.debug && this.guid != null) {
                this.out.println("DEBUG: mail.imap.yahoo.guid: " + this.guid);
            }
            if ((s = session.getProperty("mail." + name + ".folder.class")) != null) {
                if (this.debug) {
                    this.out.println("DEBUG IMAP: folder class: " + s);
                }
                try {
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class<?> folderClass = null;
                    try {
                        folderClass = Class.forName(s, false, cl);
                    }
                    catch (ClassNotFoundException ex1) {
                        folderClass = Class.forName(s);
                    }
                    Class[] c = new Class[]{String.class, Character.TYPE, IMAPStore.class, Boolean.class};
                    this.folderConstructor = folderClass.getConstructor(c);
                    Class[] c2 = new Class[]{ListInfo.class, IMAPStore.class};
                    this.folderConstructorLI = folderClass.getConstructor(c2);
                }
                catch (Exception ex) {
                    if (!this.debug) break block34;
                    this.out.println("DEBUG IMAP: failed to load folder class: " + ex);
                }
            }
        }
        this.pool = new ConnectionPool(name, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean protocolConnect(String host, int pport, String user, String password) throws MessagingException {
        block16: {
            IMAPProtocol protocol = null;
            if (host == null || password == null || user == null) {
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect returning false, host=" + host + ", user=" + this.traceUser(user) + ", password=" + this.tracePassword(password));
                }
                return false;
            }
            this.port = pport != -1 ? pport : PropUtil.getIntSessionProperty(this.session, "mail." + this.name + ".port", this.port);
            if (this.port == -1) {
                this.port = this.defaultPort;
            }
            try {
                boolean poolEmpty;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    poolEmpty = this.pool.authenticatedConnections.isEmpty();
                }
                if (!poolEmpty) break block16;
                if (this.debug) {
                    this.out.println("DEBUG: trying to connect to host \"" + host + "\", port " + this.port + ", isSSL " + this.isSSL);
                }
                protocol = new IMAPProtocol(this.name, host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect login, host=" + host + ", user=" + this.traceUser(user) + ", password=" + this.tracePassword(password));
                }
                this.login(protocol, user, password);
                protocol.addResponseHandler(this);
                this.host = host;
                this.user = user;
                this.password = password;
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.addElement(protocol);
                }
            }
            catch (CommandFailedException cex) {
                if (protocol != null) {
                    protocol.disconnect();
                }
                protocol = null;
                throw new AuthenticationFailedException(cex.getResponse().getRest());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            catch (IOException ioex) {
                throw new MessagingException(ioex.getMessage(), ioex);
            }
        }
        return true;
    }

    private void login(IMAPProtocol p, String u, String pw) throws ProtocolException {
        if (this.enableStartTLS || this.requireStartTLS) {
            if (p.hasCapability("STARTTLS")) {
                p.startTLS();
                p.capability();
            } else if (this.requireStartTLS) {
                if (this.debug) {
                    this.out.println("DEBUG: STARTTLS required but not supported");
                }
                throw new ProtocolException("STARTTLS required but not supported by server");
            }
        }
        if (p.isAuthenticated()) {
            return;
        }
        this.preLogin(p);
        if (this.guid != null) {
            p.id(this.guid);
        }
        p.getCapabilities().put("__PRELOGIN__", "");
        String authzid = this.authorizationID != null ? this.authorizationID : (this.proxyAuthUser != null ? this.proxyAuthUser : null);
        if (this.enableSASL) {
            p.sasllogin(this.saslMechanisms, this.saslRealm, authzid, u, pw);
        }
        if (!p.isAuthenticated()) {
            if (p.hasCapability("AUTH=PLAIN") && !this.disableAuthPlain) {
                p.authplain(authzid, u, pw);
            } else if ((p.hasCapability("AUTH-LOGIN") || p.hasCapability("AUTH=LOGIN")) && !this.disableAuthLogin) {
                p.authlogin(u, pw);
            } else if (p.hasCapability("AUTH=NTLM") && !this.disableAuthNtlm) {
                p.authntlm(authzid, u, pw);
            } else if (!p.hasCapability("LOGINDISABLED")) {
                p.login(u, pw);
            } else {
                throw new ProtocolException("No login methods supported!");
            }
        }
        if (this.proxyAuthUser != null) {
            p.proxyauth(this.proxyAuthUser);
        }
        if (p.hasCapability("__PRELOGIN__")) {
            try {
                p.capability();
            }
            catch (ConnectionException cex) {
                throw cex;
            }
            catch (ProtocolException pex) {
                // empty catch block
            }
        }
    }

    protected void preLogin(IMAPProtocol p) throws ProtocolException {
    }

    public synchronized void setUsername(String user) {
        this.user = user;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getProtocol(IMAPFolder folder) throws MessagingException {
        IMAPProtocol p = null;
        while (p == null) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.authenticatedConnections.isEmpty() || this.pool.authenticatedConnections.size() == 1 && (this.pool.separateStoreConnection || this.pool.storeConnectionInUse)) {
                    if (this.debug) {
                        this.out.println("DEBUG: no connections in the pool, creating a new one");
                    }
                    try {
                        if (this.forcePasswordRefresh) {
                            this.refreshPassword();
                        }
                        p = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                        this.login(p, this.user, this.password);
                    }
                    catch (Exception ex1) {
                        if (p != null) {
                            try {
                                p.disconnect();
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                        }
                        p = null;
                    }
                    if (p == null) {
                        throw new MessagingException("connection failure");
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: connection available -- size: " + this.pool.authenticatedConnections.size());
                    }
                    p = (IMAPProtocol)this.pool.authenticatedConnections.lastElement();
                    this.pool.authenticatedConnections.removeElement(p);
                    long lastUsed = System.currentTimeMillis() - p.getTimestamp();
                    if (lastUsed > this.pool.serverTimeoutInterval) {
                        try {
                            p.removeResponseHandler(this);
                            p.addResponseHandler(this.nonStoreResponseHandler);
                            p.noop();
                            p.removeResponseHandler(this.nonStoreResponseHandler);
                            p.addResponseHandler(this);
                        }
                        catch (ProtocolException pex) {
                            try {
                                p.removeResponseHandler(this.nonStoreResponseHandler);
                                p.disconnect();
                            }
                            finally {
                                p = null;
                                continue;
                            }
                        }
                    }
                    p.removeResponseHandler(this);
                }
                this.timeoutConnections();
                if (folder != null) {
                    if (this.pool.folders == null) {
                        this.pool.folders = new Vector();
                    }
                    this.pool.folders.addElement(folder);
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMAPProtocol getStoreProtocol() throws ProtocolException {
        IMAPProtocol p = null;
        while (p == null) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                this.waitIfIdle();
                if (this.pool.authenticatedConnections.isEmpty()) {
                    if (this.pool.debug) {
                        this.out.println("DEBUG: getStoreProtocol() - no connections in the pool, creating a new one");
                    }
                    try {
                        if (this.forcePasswordRefresh) {
                            this.refreshPassword();
                        }
                        p = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                        this.login(p, this.user, this.password);
                    }
                    catch (Exception ex1) {
                        if (p != null) {
                            try {
                                p.logout();
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                        }
                        p = null;
                    }
                    if (p == null) {
                        throw new ConnectionException("failed to create new store connection");
                    }
                    p.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(p);
                } else {
                    if (this.pool.debug) {
                        this.out.println("DEBUG: getStoreProtocol() - connection available -- size: " + this.pool.authenticatedConnections.size());
                    }
                    p = (IMAPProtocol)this.pool.authenticatedConnections.firstElement();
                }
                if (this.pool.storeConnectionInUse) {
                    try {
                        p = null;
                        this.pool.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.pool.storeConnectionInUse = true;
                    if (this.pool.debug) {
                        this.out.println("DEBUG: getStoreProtocol() -- storeConnectionInUse");
                    }
                }
                this.timeoutConnections();
            }
        }
        return p;
    }

    IMAPProtocol getFolderStoreProtocol() throws ProtocolException {
        IMAPProtocol p = this.getStoreProtocol();
        p.removeResponseHandler(this);
        p.addResponseHandler(this.nonStoreResponseHandler);
        return p;
    }

    private void refreshPassword() {
        InetAddress addr;
        if (this.debug) {
            this.out.println("DEBUG: refresh password, user: " + this.traceUser(this.user));
        }
        try {
            addr = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            addr = null;
        }
        PasswordAuthentication pa = this.session.requestPasswordAuthentication(addr, this.port, this.name, null, this.user);
        if (pa != null) {
            this.user = pa.getUserName();
            this.password = pa.getPassword();
        }
    }

    boolean allowReadOnlySelect() {
        return PropUtil.getBooleanSessionProperty(this.session, "mail." + this.name + ".allowreadonlyselect", false);
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    boolean getMessageCacheDebug() {
        return this.messageCacheDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug) {
                this.out.println("DEBUG: current size: " + this.pool.authenticatedConnections.size() + "   pool size: " + this.pool.poolSize);
            }
            return this.pool.authenticatedConnections.size() >= this.pool.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseProtocol(IMAPFolder folder, IMAPProtocol protocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (protocol != null) {
                if (!this.isConnectionPoolFull()) {
                    protocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(protocol);
                    if (this.debug) {
                        this.out.println("DEBUG: added an Authenticated connection -- size: " + this.pool.authenticatedConnections.size());
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                    }
                    try {
                        protocol.logout();
                    }
                    catch (ProtocolException pex) {
                        // empty catch block
                    }
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement(folder);
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseStoreProtocol(IMAPProtocol protocol) {
        boolean failed;
        if (protocol == null) {
            this.cleanup();
            return;
        }
        Object object = this.connectionFailedLock;
        synchronized (object) {
            failed = this.connectionFailed;
            this.connectionFailed = false;
        }
        object = this.pool;
        synchronized (object) {
            this.pool.storeConnectionInUse = false;
            this.pool.notifyAll();
            if (this.pool.debug) {
                this.out.println("DEBUG: releaseStoreProtocol()");
            }
            this.timeoutConnections();
        }
        assert (!Thread.holdsLock(this.pool));
        if (failed) {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFolderStoreProtocol(IMAPProtocol protocol) {
        if (protocol == null) {
            return;
        }
        protocol.removeResponseHandler(this.nonStoreResponseHandler);
        protocol.addResponseHandler(this);
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            this.pool.storeConnectionInUse = false;
            this.pool.notifyAll();
            if (this.pool.debug) {
                this.out.println("DEBUG: releaseFolderStoreProtocol()");
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyConnectionPool(boolean force) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            for (int index = this.pool.authenticatedConnections.size() - 1; index >= 0; --index) {
                try {
                    IMAPProtocol p = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(index);
                    p.removeResponseHandler(this);
                    if (force) {
                        p.disconnect();
                        continue;
                    }
                    p.logout();
                    continue;
                }
                catch (ProtocolException pex) {
                    // empty catch block
                }
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug) {
            this.out.println("DEBUG: removed all authenticated connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: checking for connections to prune: " + (System.currentTimeMillis() - this.pool.lastTimePruned));
                    this.out.println("DEBUG: clientTimeoutInterval: " + this.pool.clientTimeoutInterval);
                }
                for (int index = this.pool.authenticatedConnections.size() - 1; index > 0; --index) {
                    IMAPProtocol p = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(index);
                    if (this.pool.debug) {
                        this.out.println("DEBUG: protocol last used: " + (System.currentTimeMillis() - p.getTimestamp()));
                    }
                    if (System.currentTimeMillis() - p.getTimestamp() <= this.pool.clientTimeoutInterval) continue;
                    if (this.pool.debug) {
                        this.out.println("DEBUG: authenticated connection timed out");
                        this.out.println("DEBUG: logging out the connection");
                    }
                    p.removeResponseHandler(this);
                    this.pool.authenticatedConnections.removeElementAt(index);
                    try {
                        p.logout();
                        continue;
                    }
                    catch (ProtocolException pex) {
                        // empty catch block
                    }
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return this.session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    int getMinIdleTime() {
        return this.minIdleTime;
    }

    public synchronized boolean hasCapability(String capability) throws MessagingException {
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            boolean bl = p.hasCapability(capability);
            return bl;
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            p.noop();
        }
        catch (ProtocolException protocolException) {
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return super.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws MessagingException {
        ConnectionPool connectionPool;
        IMAPProtocol protocol;
        block13: {
            boolean isEmpty;
            if (!super.isConnected()) {
                return;
            }
            protocol = null;
            connectionPool = this.pool;
            synchronized (connectionPool) {
                isEmpty = this.pool.authenticatedConnections.isEmpty();
            }
            if (!isEmpty) break block13;
            if (this.pool.debug) {
                this.out.println("DEBUG: close() - no connections ");
            }
            this.cleanup();
            this.releaseStoreProtocol(protocol);
            return;
        }
        try {
            protocol = this.getStoreProtocol();
            connectionPool = this.pool;
            synchronized (connectionPool) {
                this.pool.authenticatedConnections.removeElement(protocol);
            }
            protocol.logout();
            this.releaseStoreProtocol(protocol);
        }
        catch (ProtocolException pex) {
            try {
                throw new MessagingException(pex.getMessage(), pex);
            }
            catch (Throwable throwable) {
                this.releaseStoreProtocol(protocol);
                throw throwable;
            }
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() {
        boolean force;
        if (!super.isConnected()) {
            if (this.debug) {
                this.out.println("DEBUG: IMAPStore cleanup, not connected");
            }
            return;
        }
        Object object = this.connectionFailedLock;
        synchronized (object) {
            force = this.forceClose;
            this.forceClose = false;
            this.connectionFailed = false;
        }
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup, force " + force);
        }
        Vector foldersCopy = null;
        boolean done = true;
        block14: while (true) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    done = false;
                    foldersCopy = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    done = true;
                }
            }
            if (done) break;
            int i = 0;
            int fsize = foldersCopy.size();
            while (true) {
                if (i >= fsize) continue block14;
                IMAPFolder f = (IMAPFolder)foldersCopy.elementAt(i);
                try {
                    if (force) {
                        if (this.debug) {
                            this.out.println("DEBUG: force folder to close");
                        }
                        f.forceClose();
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG: close folder");
                        }
                        f.close(false);
                    }
                }
                catch (MessagingException mex) {
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                ++i;
            }
            break;
        }
        ConnectionPool i = this.pool;
        synchronized (i) {
            this.emptyConnectionPool(force);
        }
        try {
            super.close();
        }
        catch (MessagingException mex) {
            // empty catch block
        }
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup done");
        }
    }

    @Override
    public synchronized Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    @Override
    public synchronized Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return this.newIMAPFolder(name, '\uffff');
    }

    @Override
    public synchronized Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.newIMAPFolder(url.getFile(), '\uffff');
    }

    protected IMAPFolder newIMAPFolder(String fullName, char separator, Boolean isNamespace) {
        IMAPFolder f;
        block4: {
            f = null;
            if (this.folderConstructor != null) {
                try {
                    Object[] o = new Object[]{fullName, new Character(separator), this, isNamespace};
                    f = (IMAPFolder)this.folderConstructor.newInstance(o);
                }
                catch (Exception ex) {
                    if (!this.debug) break block4;
                    this.out.println("DEBUG IMAP: exception creating IMAPFolder class: " + ex.toString());
                }
            }
        }
        if (f == null) {
            f = new IMAPFolder(fullName, separator, this, isNamespace);
        }
        return f;
    }

    protected IMAPFolder newIMAPFolder(String fullName, char separator) {
        return this.newIMAPFolder(fullName, separator, null);
    }

    protected IMAPFolder newIMAPFolder(ListInfo li) {
        IMAPFolder f;
        block4: {
            f = null;
            if (this.folderConstructorLI != null) {
                try {
                    Object[] o = new Object[]{li, this};
                    f = (IMAPFolder)this.folderConstructorLI.newInstance(o);
                }
                catch (Exception ex) {
                    if (!this.debug) break block4;
                    this.out.println("DEBUG IMAP: exception creating IMAPFolder class LI: " + ex.toString());
                }
            }
        }
        if (f == null) {
            f = new IMAPFolder(li, this);
        }
        return f;
    }

    @Override
    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(ns.personal, null);
    }

    @Override
    public Folder[] getUserNamespaces(String user) throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.otherUsers == null) {
            return super.getUserNamespaces(user);
        }
        return this.namespaceToFolders(ns.otherUsers, user);
    }

    @Override
    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(ns.shared, null);
    }

    private synchronized Namespaces getNamespaces() throws MessagingException {
        this.checkConnected();
        IMAPProtocol p = null;
        if (this.namespaces == null) {
            try {
                p = this.getStoreProtocol();
                this.namespaces = p.namespace();
            }
            catch (BadCommandException bex) {
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            finally {
                this.releaseStoreProtocol(p);
            }
        }
        return this.namespaces;
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] ns, String user) {
        Folder[] fa = new Folder[ns.length];
        for (int i = 0; i < fa.length; ++i) {
            String name = ns[i].prefix;
            if (user == null) {
                int len = name.length();
                if (len > 0 && name.charAt(len - 1) == ns[i].delimiter) {
                    name = name.substring(0, len - 1);
                }
            } else {
                name = name + user;
            }
            fa[i] = this.newIMAPFolder(name, ns[i].delimiter, user == null);
        }
        return fa;
    }

    @Override
    public synchronized Quota[] getQuota(String root) throws MessagingException {
        this.checkConnected();
        Quota[] qa = null;
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            qa = p.getQuotaRoot(root);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", bex);
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return qa;
    }

    @Override
    public synchronized void setQuota(Quota quota) throws MessagingException {
        this.checkConnected();
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            p.setQuota(quota);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", bex);
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    private void checkConnected() {
        assert (Thread.holdsLock(this));
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(Response r) {
        if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
            this.handleResponseCode(r);
        }
        if (r.isBYE()) {
            if (this.debug) {
                this.out.println("DEBUG: IMAPStore connection dead");
            }
            Object object = this.connectionFailedLock;
            synchronized (object) {
                this.connectionFailed = true;
                if (r.isSynthetic()) {
                    this.forceClose = true;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle() throws MessagingException {
        IMAPProtocol p = null;
        assert (!Thread.holdsLock(this.pool));
        Object object = this;
        synchronized (object) {
            this.checkConnected();
        }
        try {
            object = this.pool;
            synchronized (object) {
                p = this.getStoreProtocol();
                if (this.pool.idleState != 0) {
                    try {
                        this.pool.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    return;
                }
                p.idleStart();
                this.pool.idleState = 1;
                this.pool.idleProtocol = p;
            }
            while (true) {
                Response r = p.readIdleResponse();
                ConnectionPool ex = this.pool;
                synchronized (ex) {
                    if (r == null || !p.processIdleResponse(r)) {
                        this.pool.idleState = 0;
                        this.pool.notifyAll();
                        break;
                    }
                }
                if (!this.enableImapEvents || !r.isUnTagged()) continue;
                this.notifyStoreListeners(1000, r.toString());
            }
            int minidle = this.getMinIdleTime();
            if (minidle > 0) {
                try {
                    Thread.sleep(minidle);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("IDLE not supported", bex);
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                this.pool.idleProtocol = null;
            }
            this.releaseStoreProtocol(p);
        }
    }

    private void waitIfIdle() throws ProtocolException {
        assert (Thread.holdsLock(this.pool));
        while (this.pool.idleState != 0) {
            if (this.pool.idleState == 1) {
                this.pool.idleProtocol.idleAbort();
                this.pool.idleState = 2;
            }
            try {
                this.pool.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void handleResponseCode(Response r) {
        String s = r.getRest();
        boolean isAlert = false;
        if (s.startsWith("[")) {
            int i = s.indexOf(93);
            if (i > 0 && s.substring(0, i + 1).equalsIgnoreCase("[ALERT]")) {
                isAlert = true;
            }
            s = s.substring(i + 1).trim();
        }
        if (isAlert) {
            this.notifyStoreListeners(1, s);
        } else if (r.isUnTagged() && s.length() > 0) {
            this.notifyStoreListeners(2, s);
        }
    }

    private String traceUser(String user) {
        return this.debugusername ? user : "<user name suppressed>";
    }

    private String tracePassword(String password) {
        return this.debugpassword ? password : (password == null ? "<null>" : "<non-null>");
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean storeConnectionInUse = false;
        private long lastTimePruned = System.currentTimeMillis();
        private final boolean separateStoreConnection;
        private final long clientTimeoutInterval;
        private final long serverTimeoutInterval;
        private final int poolSize;
        private final long pruningInterval;
        private final boolean debug;
        private static final int RUNNING = 0;
        private static final int IDLE = 1;
        private static final int ABORTING = 2;
        private int idleState = 0;
        private IMAPProtocol idleProtocol;

        ConnectionPool(String name, Session session) {
            int pruning;
            int serverTimeout;
            int connectionPoolTimeout;
            PrintStream out = session.getDebugOut();
            if (out == null) {
                out = System.out;
            }
            this.debug = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".connectionpool.debug", false);
            int size = PropUtil.getIntSessionProperty(session, "mail." + name + ".connectionpoolsize", -1);
            if (size > 0) {
                this.poolSize = size;
                if (this.debug) {
                    out.println("DEBUG: mail.imap.connectionpoolsize: " + this.poolSize);
                }
            } else {
                this.poolSize = 1;
            }
            if ((connectionPoolTimeout = PropUtil.getIntSessionProperty(session, "mail." + name + ".connectionpooltimeout", -1)) > 0) {
                this.clientTimeoutInterval = connectionPoolTimeout;
                if (this.debug) {
                    out.println("DEBUG: mail.imap.connectionpooltimeout: " + this.clientTimeoutInterval);
                }
            } else {
                this.clientTimeoutInterval = 45000L;
            }
            if ((serverTimeout = PropUtil.getIntSessionProperty(session, "mail." + name + ".servertimeout", -1)) > 0) {
                this.serverTimeoutInterval = serverTimeout;
                if (this.debug) {
                    out.println("DEBUG: mail.imap.servertimeout: " + this.serverTimeoutInterval);
                }
            } else {
                this.serverTimeoutInterval = 1800000L;
            }
            if ((pruning = PropUtil.getIntSessionProperty(session, "mail." + name + ".pruninginterval", -1)) > 0) {
                this.pruningInterval = pruning;
                if (this.debug) {
                    out.println("DEBUG: mail.imap.pruninginterval: " + this.pruningInterval);
                }
            } else {
                this.pruningInterval = 60000L;
            }
            this.separateStoreConnection = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".separatestoreconnection", false);
            if (this.debug && this.separateStoreConnection) {
                out.println("DEBUG: dedicate a store connection");
            }
        }
    }
}

