/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.pool.strictmax;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.pool.AbstractPool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;

public class StrictMaxPool<T>
extends AbstractPool<T> {
    private final Semaphore semaphore;
    private final int maxSize;
    private final long timeout;
    private final TimeUnit timeUnit;
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();

    public StrictMaxPool(StatelessObjectFactory<T> factory, int maxSize, long timeout, TimeUnit timeUnit) {
        super(factory);
        this.maxSize = maxSize;
        this.semaphore = new Semaphore(maxSize, false);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void discard(T ctx) {
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("Discard instance %s#%s", this, ctx);
        }
        this.semaphore.release();
        super.doRemove(ctx);
    }

    @Override
    public int getCurrentSize() {
        return this.getCreateCount() - this.getRemoveCount();
    }

    @Override
    public int getAvailableCount() {
        return this.semaphore.availablePermits();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        throw EjbMessages.MESSAGES.methodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        try {
            boolean acquired = this.semaphore.tryAcquire(this.timeout, this.timeUnit);
            if (!acquired) {
                throw EjbMessages.MESSAGES.failedToAcquirePermit(this.timeout, this.timeUnit);
            }
        }
        catch (InterruptedException e) {
            throw EjbMessages.MESSAGES.acquireSemaphoreInterrupted();
        }
        T bean = this.pool.poll();
        if (bean != null) {
            return bean;
        }
        try {
            bean = this.create();
        }
        finally {
            if (bean == null) {
                this.semaphore.release();
            }
        }
        return bean;
    }

    @Override
    public void release(T obj) {
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("%s/%s Free instance: %s", this.pool.size(), this.maxSize, this);
        }
        this.pool.add(obj);
        this.semaphore.release();
    }

    @Override
    @Deprecated
    public void remove(T ctx) {
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("Removing instance: %s#%s", this, ctx);
        }
        this.semaphore.release();
        super.doRemove(ctx);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        T obj = this.pool.poll();
        while (obj != null) {
            this.destroy(obj);
            obj = this.pool.poll();
        }
    }
}

