/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.GroupAwareBackingCache;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntry;
import org.jboss.logging.Logger;

public class SerializationGroupMemberImpl<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends AbstractBackingCacheEntry<K, V>
implements SerializationGroupMember<K, V, G> {
    private static final long serialVersionUID = 7268142730501106252L;
    private static final Logger log = Logger.getLogger(SerializationGroupMemberImpl.class);
    private K id;
    private transient V value;
    private transient SerializationGroup<K, V, G> group;
    private G groupId;
    private boolean clustered;
    private boolean preReplicated;
    private transient ReentrantLock lock = new ReentrantLock();
    private transient boolean groupLockHeld;
    private transient GroupAwareBackingCache<K, V, G, SerializationGroupMember<K, V, G>> cache;

    public SerializationGroupMemberImpl(V obj, GroupAwareBackingCache<K, V, G, SerializationGroupMember<K, V, G>> cache) {
        this.value = obj;
        this.id = (Serializable)obj.getId();
        this.cache = cache;
        this.clustered = cache.isClustered();
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public boolean isModified() {
        boolean localModified;
        boolean bl = localModified = this.value != null && this.value.isModified();
        if (localModified && this.group != null) {
            this.group.setGroupModified(true);
        }
        return this.group == null ? localModified : this.group.isGroupModified();
    }

    public boolean isClustered() {
        return this.clustered;
    }

    @Override
    public V getUnderlyingItem() {
        return this.value;
    }

    @Override
    public void setUnderlyingItem(V obj) {
        this.value = obj;
    }

    @Override
    public SerializationGroup<K, V, G> getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(SerializationGroup<K, V, G> group) {
        if (this.group != group) {
            if (group == null && this.groupLockHeld) {
                this.group.unlock();
                this.groupLockHeld = false;
            }
            this.group = group;
            if (this.groupId == null && group != null) {
                this.groupId = (Serializable)group.getId();
            }
            if (group != null && this.lock.isHeldByCurrentThread()) {
                group.lock();
                this.groupLockHeld = true;
            }
        }
    }

    @Override
    public G getGroupId() {
        return this.groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prePassivate() {
        if (this.tryLock(2L)) {
            try {
                this.setGroup(null);
                this.cache.passivate(this.id);
            }
            finally {
                this.unlock();
            }
        } else {
            throw EjbMessages.MESSAGES.cacheEntryInUse(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preReplicate() {
        if (this.tryLock(2L)) {
            try {
                this.setGroup(null);
                this.cache.notifyPreReplicate(this);
            }
            finally {
                this.unlock();
            }
        } else {
            throw EjbMessages.MESSAGES.cacheEntryInUse(this);
        }
    }

    public void postActivate() {
    }

    @Override
    public boolean isPreReplicated() {
        return this.preReplicated;
    }

    @Override
    public void setPreReplicated(boolean preReplicated) {
        this.preReplicated = preReplicated;
    }

    public void postReplicate() {
    }

    @Override
    public synchronized void increaseUsageCount() {
        boolean inUse = this.isInUse();
        super.increaseUsageCount();
        if (!inUse) {
            this.setInUse(true);
        }
    }

    @Override
    public synchronized void decreaseUsageCount() {
        super.decreaseUsageCount();
        if (!this.isInUse()) {
            this.setInUse(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInUse(boolean inUse) {
        if (this.group != null) {
            boolean localGroupLock = false;
            if (!this.groupLockHeld) {
                this.group.lock();
                this.groupLockHeld = true;
                localGroupLock = true;
            }
            try {
                if (inUse) {
                    this.group.addInUse(this.id);
                } else {
                    this.group.removeInUse(this.id);
                }
            }
            finally {
                if (localGroupLock) {
                    this.group.unlock();
                    this.groupLockHeld = false;
                }
            }
        }
    }

    @Override
    public void setPassivatingCache(GroupAwareBackingCache<K, V, G, SerializationGroupMember<K, V, G>> delegate) {
        this.cache = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw EjbMessages.MESSAGES.lockAcquisitionInterrupted(e, this);
        }
        if (!this.groupLockHeld && this.group != null) {
            try {
                this.group.lock();
                this.groupLockHeld = true;
            }
            finally {
                if (!this.groupLockHeld) {
                    this.lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock() {
        boolean success = this.lock.tryLock();
        if (success) {
            boolean bl = success = this.groupLockHeld || this.group == null;
            if (!success) {
                try {
                    success = this.groupLockHeld = this.group.tryLock();
                    if (!success) {
                        log.tracef("Member %s cannot lock serialization group %s", this.id, this.groupId);
                    }
                }
                finally {
                    if (!success) {
                        this.lock.unlock();
                    }
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock(long wait) {
        boolean success = false;
        try {
            success = this.lock.tryLock(wait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (success) {
            boolean bl = success = this.groupLockHeld || this.group == null;
            if (!success) {
                try {
                    success = this.groupLockHeld = this.group.tryLock();
                    if (!success) {
                        log.tracef("Member %s cannot lock serialization group %s", this.id, this.groupId);
                    }
                }
                finally {
                    if (!success) {
                        this.lock.unlock();
                    }
                }
            }
        }
        return success;
    }

    @Override
    public void unlock() {
        if (this.groupLockHeld && this.lock.getHoldCount() == 1) {
            this.group.unlock();
            this.groupLockHeld = false;
        }
        this.lock.unlock();
    }

    public String toString() {
        return this.id.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new ReentrantLock();
        if (this.groupId == null) {
            this.value = (Cacheable)in.readObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.groupId != null) {
            this.setGroup(null);
        }
        out.defaultWriteObject();
        if (this.groupId == null) {
            out.writeObject(this.value);
        }
    }
}

