/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import java.util.Map;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.tomcat.websocket.InstanceHandle;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoEndpointBase;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.jboss.web.WebsocketsMessages;

public class PojoEndpointServer
extends PojoEndpointBase {
    public static final String POJO_PATH_PARAM_KEY = "org.apache.tomcat.websocket.pojo.PojoEndpoint.pathParams";
    public static final String POJO_METHOD_MAPPING_KEY = "org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping";

    @Override
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        Object pojo;
        ServerEndpointConfig sec = (ServerEndpointConfig)endpointConfig;
        InstanceHandle instanceHandle = null;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((WsSession)session).getClassLoader());
            pojo = sec.getConfigurator().getEndpointInstance(sec.getEndpointClass());
            if (pojo instanceof InstanceHandle) {
                instanceHandle = (InstanceHandle)pojo;
                pojo = instanceHandle.getInstance();
            }
        }
        catch (InstantiationException e) {
            throw WebsocketsMessages.MESSAGES.pojoInstanceFailed(sec.getEndpointClass().getName(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.setPojo(pojo);
        this.setInstanceHandle(instanceHandle);
        Map pathParameters = (Map)sec.getUserProperties().get(POJO_PATH_PARAM_KEY);
        this.setPathParameters(pathParameters);
        PojoMethodMapping methodMapping = (PojoMethodMapping)sec.getUserProperties().get(POJO_METHOD_MAPPING_KEY);
        this.setMethodMapping(methodMapping);
        this.doOnOpen(session, endpointConfig);
    }
}

