/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class ShortConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Short";
    public static final String SHORT_ID = "javax.faces.converter.ShortConverter.SHORT";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        try {
            return Short.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, SHORT_ID, string, "32456", MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)numberFormatException);
        }
        catch (Exception exception) {
            throw new ConverterException(exception);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return Short.toString(((Number)object).shortValue());
        }
        catch (Exception exception) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)exception);
        }
    }
}

