/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.TypedCollections;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueBindingValueExpressionAdapter;
import javax.faces.component.ValueExpressionValueBindingAdapter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponentBase
extends UIComponent {
    private static Logger log = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    private static Map<Class<?>, Map<String, PropertyDescriptor>> descriptors = new WeakHashMap();
    private Map<String, PropertyDescriptor> pdMap = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String IS_SAVE_BINDINGS_STATE_PARAM_NAME = "com.sun.faces.IS_SAVE_BINDINGS_STATE";
    private AttributesMap attributes = null;
    private String clientId = null;
    private String id = null;
    private UIComponent parent = null;
    private boolean rendered = true;
    private boolean renderedSet = false;
    private String rendererType = null;
    private List<UIComponent> children = null;
    private static final String SEPARATOR_STRING = String.valueOf(':');
    private Map<String, UIComponent> facets = null;
    private List<FacesListener> listeners;
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private Object[] values;
    private boolean transientFlag = false;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator<UIComponent> EMPTY_ITERATOR = new Iterator<UIComponent>(){

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UIComponent next() {
            throw new NoSuchElementException("Empty Iterator");
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public UIComponentBase() {
        this.populateDescriptorsMapIfNecessary();
    }

    private void populateDescriptorsMapIfNecessary() {
        Class<?> clazz = this.getClass();
        this.pdMap = descriptors.get(clazz);
        if (null != this.pdMap) {
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors();
        if (propertyDescriptorArray != null) {
            this.pdMap = new HashMap<String, PropertyDescriptor>(propertyDescriptorArray.length, 1.0f);
            Object object = propertyDescriptorArray;
            int n = ((PropertyDescriptor[])object).length;
            for (int i = 0; i < n; ++i) {
                PropertyDescriptor propertyDescriptor = object[i];
                this.pdMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "fine.component.populating_descriptor_map", new Object[]{clazz, Thread.currentThread().getName()});
            }
            if (null != (object = descriptors.get(clazz))) {
                return;
            }
            descriptors.put(clazz, this.pdMap);
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] propertyDescriptorArray;
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            throw new FacesException(introspectionException);
        }
        return propertyDescriptorArray;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap((UIComponent)this);
        }
        return this.attributes;
    }

    @Override
    public ValueBinding getValueBinding(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ValueBinding valueBinding = null;
        ValueExpression valueExpression = this.getValueExpression(string);
        if (null != valueExpression) {
            valueBinding = valueExpression.getClass().equals(ValueExpressionValueBindingAdapter.class) ? ((ValueExpressionValueBindingAdapter)valueExpression).getWrapped() : new ValueBindingValueExpressionAdapter(valueExpression);
        }
        return valueBinding;
    }

    @Override
    public void setValueBinding(String string, ValueBinding valueBinding) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (valueBinding != null) {
            ValueExpressionValueBindingAdapter valueExpressionValueBindingAdapter = new ValueExpressionValueBindingAdapter(valueBinding);
            this.setValueExpression(string, valueExpressionValueBindingAdapter);
        } else {
            this.setValueExpression(string, null);
        }
    }

    @Override
    public String getClientId(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.clientId == null) {
            Object object;
            UIComponent uIComponent = this.getNamingContainer();
            String string = null;
            if (uIComponent != null) {
                string = uIComponent.getContainerClientId(facesContext);
            }
            this.clientId = this.getId();
            if (this.clientId == null) {
                this.setId(facesContext.getViewRoot().createUniqueId());
                this.clientId = this.getId();
            }
            if (string != null) {
                object = new StringBuilder(string.length() + 1 + this.clientId.length());
                this.clientId = ((StringBuilder)object).append(string).append(':').append(this.clientId).toString();
            }
            if ((object = this.getRenderer(facesContext)) != null) {
                this.clientId = ((Renderer)object).convertClientId(facesContext, this.clientId);
            }
        }
        return this.clientId;
    }

    private UIComponent getNamingContainer() {
        for (UIComponent uIComponent = this.getParent(); uIComponent != null; uIComponent = uIComponent.getParent()) {
            if (!(uIComponent instanceof NamingContainer)) continue;
            return uIComponent;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        if (this.id == null || !this.id.equals(string)) {
            UIComponentBase.validateId(string);
            this.id = string;
        }
        this.clientId = null;
    }

    @Override
    public UIComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UIComponent uIComponent) {
        this.parent = uIComponent;
    }

    @Override
    public boolean isRendered() {
        if (this.renderedSet) {
            return this.rendered;
        }
        ValueExpression valueExpression = this.getValueExpression("rendered");
        if (valueExpression != null) {
            try {
                return !Boolean.FALSE.equals(valueExpression.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return this.rendered;
    }

    @Override
    public void setRendered(boolean bl) {
        this.rendered = bl;
        this.renderedSet = true;
    }

    @Override
    public String getRendererType() {
        if (this.rendererType != null) {
            return this.rendererType;
        }
        ValueExpression valueExpression = this.getValueExpression("rendererType");
        if (valueExpression != null) {
            try {
                return (String)valueExpression.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return null;
    }

    @Override
    public void setRendererType(String string) {
        this.rendererType = string;
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer;
        boolean bl = false;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            bl = renderer.getRendersChildren();
        }
        return bl;
    }

    @Override
    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList(this);
        }
        return this.children;
    }

    @Override
    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    private static void eraseParent(UIComponent uIComponent) {
        Object object;
        int n;
        UIComponent uIComponent2 = uIComponent.getParent();
        if (uIComponent2 == null) {
            return;
        }
        if (uIComponent2.getChildCount() > 0 && (n = (object = uIComponent2.getChildren()).indexOf(uIComponent)) >= 0) {
            object.remove(n);
            return;
        }
        if (uIComponent2.getFacetCount() > 0) {
            object = uIComponent2.getFacets();
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() != uIComponent) continue;
                iterator.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private static void validateId(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n < 1) {
            throw new IllegalArgumentException("The id attribute may not be empty");
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public UIComponent findComponent(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("\"\"");
        }
        UIComponent uIComponent = this;
        if (string.charAt(0) == ':') {
            while (uIComponent.getParent() != null) {
                uIComponent = uIComponent.getParent();
            }
            string = string.substring(1);
        } else if (!(uIComponent instanceof NamingContainer)) {
            while (uIComponent.getParent() != null && !(uIComponent instanceof NamingContainer)) {
                uIComponent = uIComponent.getParent();
            }
        }
        UIComponent uIComponent2 = null;
        String[] stringArray = string.split(SEPARATOR_STRING);
        int n = 0;
        int n2 = stringArray.length - 1;
        while (n < stringArray.length) {
            uIComponent2 = UIComponentBase.findComponent(uIComponent, stringArray[n], n == 0);
            if (n == 0 && uIComponent2 == null && stringArray[n].equals(uIComponent.getId())) {
                uIComponent2 = uIComponent;
            }
            if (uIComponent2 != null && !(uIComponent2 instanceof NamingContainer) && n2 > 0) {
                throw new IllegalArgumentException(stringArray[n]);
            }
            if (uIComponent2 == null) break;
            uIComponent = uIComponent2;
            ++n;
            --n2;
        }
        return uIComponent2;
    }

    private static UIComponent findComponent(UIComponent uIComponent, String string, boolean bl) {
        if (bl && string.equals(uIComponent.getId())) {
            return uIComponent;
        }
        UIComponent uIComponent2 = null;
        Iterator<UIComponent> iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent3 = iterator.next();
            if (!(uIComponent3 instanceof NamingContainer)) {
                if (bl && string.equals(uIComponent3.getId())) {
                    uIComponent2 = uIComponent3;
                    break;
                }
                uIComponent2 = UIComponentBase.findComponent(uIComponent3, string, true);
                if (uIComponent2 == null) continue;
                break;
            }
            if (!string.equals(uIComponent3.getId())) continue;
            uIComponent2 = uIComponent3;
            break;
        }
        return uIComponent2;
    }

    @Override
    public boolean invokeOnComponent(FacesContext facesContext, String string, ContextCallback contextCallback) throws FacesException {
        return super.invokeOnComponent(facesContext, string, contextCallback);
    }

    @Override
    public Map<String, UIComponent> getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap(this);
        }
        return this.facets;
    }

    @Override
    public int getFacetCount() {
        if (this.facets != null) {
            return this.facets.size();
        }
        return 0;
    }

    @Override
    public UIComponent getFacet(String string) {
        if (this.facets != null) {
            return this.facets.get(string);
        }
        return null;
    }

    @Override
    public Iterator<UIComponent> getFacetsAndChildren() {
        Iterator<UIComponent> iterator;
        int n = this.getChildCount();
        int n2 = this.getFacetCount();
        if (0 == n && 0 == n2) {
            iterator = EMPTY_ITERATOR;
        } else if (0 == n) {
            Collection<UIComponent> collection = Collections.unmodifiableCollection(this.getFacets().values());
            iterator = collection.iterator();
        } else if (0 == n2) {
            List<UIComponent> list = Collections.unmodifiableList(this.getChildren());
            iterator = list.iterator();
        } else {
            iterator = new FacetsAndChildrenIterator(this);
        }
        return iterator;
    }

    @Override
    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        if (facesEvent == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        for (FacesListener facesListener : this.listeners) {
            if (!facesEvent.isAppropriateListener(facesListener)) continue;
            facesEvent.processListener(facesListener);
        }
    }

    @Override
    public void decode(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        String string = this.getRendererType();
        if (string != null) {
            Renderer renderer = this.getRenderer(facesContext);
            if (renderer != null) {
                renderer.decode(facesContext, this);
            } else {
                log.fine("Can't get Renderer for type " + string);
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String string = this.getRendererType();
        if (string != null) {
            Renderer renderer = this.getRenderer(facesContext);
            if (renderer != null) {
                renderer.encodeBegin(facesContext, this);
            } else {
                log.fine("Can't get Renderer for type " + string);
            }
        }
    }

    @Override
    public void encodeChildren(FacesContext facesContext) throws IOException {
        Renderer renderer;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String string = this.getRendererType();
        if (string != null && (renderer = this.getRenderer(facesContext)) != null) {
            renderer.encodeChildren(facesContext, this);
        }
    }

    @Override
    public void encodeEnd(FacesContext facesContext) throws IOException {
        Renderer renderer;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String string = this.getRendererType();
        if (string != null && (renderer = this.getRenderer(facesContext)) != null) {
            renderer.encodeEnd(facesContext, this);
        }
    }

    @Override
    protected void addFacesListener(FacesListener facesListener) {
        if (facesListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<FacesListener>();
        }
        this.listeners.add(facesListener);
    }

    @Override
    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> arrayList = new ArrayList<FacesListener>();
        for (FacesListener facesListener : this.listeners) {
            if (!clazz.isAssignableFrom(facesListener.getClass())) continue;
            arrayList.add(facesListener);
        }
        return arrayList.toArray((FacesListener[])Array.newInstance(clazz, arrayList.size()));
    }

    @Override
    protected void removeFacesListener(FacesListener facesListener) {
        if (facesListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(facesListener);
    }

    @Override
    public void queueEvent(FacesEvent facesEvent) {
        if (facesEvent == null) {
            throw new NullPointerException();
        }
        UIComponent uIComponent = this.getParent();
        if (uIComponent == null) {
            throw new IllegalStateException();
        }
        uIComponent.queueEvent(facesEvent);
    }

    @Override
    public void processDecodes(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> iterator = this.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent = iterator.next();
            uIComponent.processDecodes(facesContext);
        }
        try {
            this.decode(facesContext);
        }
        catch (RuntimeException runtimeException) {
            facesContext.renderResponse();
            throw runtimeException;
        }
    }

    @Override
    public void processValidators(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> iterator = this.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent = iterator.next();
            uIComponent.processValidators(facesContext);
        }
    }

    @Override
    public void processUpdates(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> iterator = this.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent = iterator.next();
            uIComponent.processUpdates(facesContext);
        }
    }

    @Override
    public Object processSaveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = EMPTY_ARRAY;
        objectArray[0] = this.saveState(facesContext);
        int n = this.getChildCount() + this.getFacetCount();
        if (n > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            if (this.getChildCount() > 0) {
                for (UIComponent uIComponent : this.getChildren()) {
                    if (uIComponent.isTransient()) continue;
                    arrayList.add(uIComponent.processSaveState(facesContext));
                }
            }
            if (this.getFacetCount() > 0) {
                for (Map.Entry entry : this.getFacets().entrySet()) {
                    UIComponent uIComponent;
                    uIComponent = (UIComponent)entry.getValue();
                    if (uIComponent.isTransient()) continue;
                    Object object = uIComponent.processSaveState(facesContext);
                    Object[] objectArray3 = new Object[]{entry.getKey(), object};
                    arrayList.add(objectArray3);
                }
            }
            objectArray2 = arrayList.toArray();
        }
        objectArray[1] = objectArray2;
        return objectArray;
    }

    @Override
    public void processRestoreState(FacesContext facesContext, Object object) {
        Object[] objectArray;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object[] objectArray2 = (Object[])object;
        Object[] objectArray3 = (Object[])objectArray2[1];
        this.restoreState(facesContext, objectArray2[0]);
        int n = 0;
        if (this.getChildCount() > 0) {
            for (UIComponent uIComponent : this.getChildren()) {
                if (uIComponent.isTransient() || (objectArray = objectArray3[n++]) == null) continue;
                uIComponent.processRestoreState(facesContext, objectArray);
            }
        }
        if (this.getFacetCount() > 0) {
            int n2 = this.getFacets().size();
            for (int i = 0; i < n2; ++i) {
                if (null == (objectArray = (Object[])objectArray3[n++])) continue;
                String string = (String)objectArray[0];
                Object object2 = objectArray[1];
                UIComponent uIComponent = this.getFacets().get(string);
                uIComponent.processRestoreState(facesContext, object2);
            }
        }
    }

    @Override
    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    protected Renderer getRenderer(FacesContext facesContext) {
        String string = this.getRendererType();
        Renderer renderer = null;
        if (string != null) {
            renderer = facesContext.getRenderKit().getRenderer(this.getFamily(), string);
            if (null == renderer && log.isLoggable(Level.FINE)) {
                log.fine("Can't get Renderer for type " + string);
            }
        } else if (log.isLoggable(Level.FINE)) {
            String string2 = this.getId();
            string2 = null != string2 ? string2 : this.getClass().getName();
            log.fine("No renderer-type for component " + string2);
        }
        return renderer;
    }

    private static boolean isSaveBindingsState(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, Object> map = externalContext.getRequestMap();
        Boolean bl = Boolean.TRUE;
        bl = (Boolean)map.get(IS_SAVE_BINDINGS_STATE_PARAM_NAME);
        if (null == bl) {
            Map<String, Object> map2 = externalContext.getApplicationMap();
            bl = (Boolean)map2.get(IS_SAVE_BINDINGS_STATE_PARAM_NAME);
            if (null == bl) {
                String string = externalContext.getInitParameter(IS_SAVE_BINDINGS_STATE_PARAM_NAME);
                bl = string == null || Boolean.parseBoolean(string);
                map2.put(IS_SAVE_BINDINGS_STATE_PARAM_NAME, bl);
            }
            map.put(IS_SAVE_BINDINGS_STATE_PARAM_NAME, bl);
        }
        return bl;
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        Object object;
        if (this.values == null) {
            this.values = new Object[9];
        }
        if (this.attributes != null && (object = this.attributes.getBackingAttributes()) != null && !object.isEmpty()) {
            this.values[0] = object;
        }
        object = this.saveBindingsState(facesContext);
        if (UIComponentBase.isSaveBindingsState(facesContext)) {
            this.values[1] = object;
        }
        this.values[2] = this.clientId;
        this.values[3] = this.id;
        this.values[4] = this.rendered ? Boolean.TRUE : Boolean.FALSE;
        this.values[5] = this.renderedSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[6] = this.rendererType;
        this.values[7] = UIComponentBase.saveAttachedState(facesContext, this.listeners);
        this.values[8] = this.attributesThatAreSet;
        assert (!this.transientFlag);
        return this.values;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object object) {
        this.values = (Object[])object;
        if (this.values[0] != null) {
            this.attributes = new AttributesMap(this, (HashMap)TypedCollections.dynamicallyCastMap((Map)this.values[0], String.class, Object.class));
        }
        this.bindings = UIComponentBase.restoreBindingsState(facesContext, this.values[1]);
        this.clientId = (String)this.values[2];
        this.id = (String)this.values[3];
        this.rendered = (Boolean)this.values[4];
        this.renderedSet = (Boolean)this.values[5];
        this.rendererType = (String)this.values[6];
        List<FacesListener> list = TypedCollections.dynamicallyCastList((List)UIComponentBase.restoreAttachedState(facesContext, this.values[7]), FacesListener.class);
        if (null != list) {
            if (null != this.listeners) {
                this.listeners.addAll(list);
            } else {
                this.listeners = list;
            }
        }
        this.attributesThatAreSet = (List)this.values[8];
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    public static Object saveAttachedState(FacesContext facesContext, Object object) {
        Serializable serializable;
        if (null == facesContext) {
            throw new NullPointerException();
        }
        if (null == object) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<StateHolderSaver> arrayList = new ArrayList<StateHolderSaver>(list.size());
            for (Object e : list) {
                if (null == e) continue;
                arrayList.add(new StateHolderSaver(facesContext, e));
            }
            serializable = arrayList;
        } else {
            serializable = new StateHolderSaver(facesContext, object);
        }
        return serializable;
    }

    public static Object restoreAttachedState(FacesContext facesContext, Object object) throws IllegalStateException {
        ArrayList<Object> arrayList;
        if (null == facesContext) {
            throw new NullPointerException();
        }
        if (null == object) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list.size());
            for (Object e : list) {
                try {
                    arrayList2.add(((StateHolderSaver)e).restore(facesContext));
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Unknown object type");
                }
            }
            arrayList = arrayList2;
        } else if (object instanceof StateHolderSaver) {
            StateHolderSaver stateHolderSaver = (StateHolderSaver)object;
            arrayList = stateHolderSaver.restore(facesContext);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return arrayList;
    }

    private static Map<String, ValueExpression> restoreBindingsState(FacesContext facesContext, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        String[] stringArray = (String[])objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[1];
        HashMap<String, ValueExpression> hashMap = new HashMap<String, ValueExpression>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], (ValueExpression)UIComponentBase.restoreAttachedState(facesContext, objectArray2[i]));
        }
        return hashMap;
    }

    private Object saveBindingsState(FacesContext facesContext) {
        if (this.bindings == null) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.bindings.keySet().toArray(new String[this.bindings.size()]);
        Object[] objectArray2 = this.bindings.values().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = UIComponentBase.saveAttachedState(facesContext, objectArray2[i]);
        }
        objectArray[1] = objectArray2;
        return objectArray;
    }

    Map<String, PropertyDescriptor> getDescriptorMap() {
        return this.pdMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapValuesIterator
    implements Iterator<UIComponent> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Object last = null;

        public FacetsMapValuesIterator(FacetsMap facetsMap) {
            this.map = facetsMap;
            this.iterator = facetsMap.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.last = this.iterator.next();
            return (UIComponent)this.map.get(this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapValues
    extends AbstractCollection<UIComponent> {
        private FacetsMap map;

        public FacetsMapValues(FacetsMap facetsMap) {
            this.map = facetsMap;
        }

        @Override
        public boolean add(UIComponent uIComponent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new FacetsMapValuesIterator(this.map);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapKeySetIterator
    implements Iterator<String> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private String last = null;

        public FacetsMapKeySetIterator(FacetsMap facetsMap) {
            this.map = facetsMap;
            this.iterator = facetsMap.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapKeySet
    extends AbstractSet<String> {
        private FacetsMap map = null;

        public FacetsMapKeySet(FacetsMap facetsMap) {
            this.map = facetsMap;
        }

        @Override
        public boolean add(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.map.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new FacetsMapKeySetIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            if (this.map.containsKey(object)) {
                this.map.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean bl = false;
            for (Object e : collection) {
                if (!this.map.containsKey(e)) continue;
                this.map.remove(e);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator<String> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySetIterator
    implements Iterator<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;
        private Iterator<String> iterator = null;
        private Map.Entry<String, UIComponent> last = null;

        public FacetsMapEntrySetIterator(FacetsMap facetsMap) {
            this.map = facetsMap;
            this.iterator = facetsMap.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, UIComponent> next() {
            this.last = new FacetsMapEntrySetEntry(this.map, this.iterator.next());
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last.getKey());
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySetEntry
    implements Map.Entry<String, UIComponent> {
        private FacetsMap map;
        private String key;

        public FacetsMapEntrySetEntry(FacetsMap facetsMap, String string) {
            this.map = facetsMap;
            this.key = string;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null ? entry.getKey() != null : !this.key.equals(entry.getKey())) {
                return false;
            }
            UIComponent uIComponent = (UIComponent)this.map.get(this.key);
            return !(uIComponent == null ? entry.getValue() != null : !uIComponent.equals(entry.getValue()));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public UIComponent getValue() {
            return (UIComponent)this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object v = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        @Override
        public UIComponent setValue(UIComponent uIComponent) {
            UIComponent uIComponent2 = (UIComponent)this.map.get(this.key);
            this.map.put(this.key, uIComponent);
            return uIComponent2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMapEntrySet
    extends AbstractSet<Map.Entry<String, UIComponent>> {
        private FacetsMap map = null;

        public FacetsMapEntrySet(FacetsMap facetsMap) {
            this.map = facetsMap;
        }

        @Override
        public boolean add(Map.Entry<String, UIComponent> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, UIComponent>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, UIComponent>> iterator() {
            return new FacetsMapEntrySetIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)object).getKey();
            if (this.map.containsKey(k)) {
                this.map.remove(k);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean bl = false;
            Iterator<Map.Entry<String, UIComponent>> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacetsMap
    extends HashMap<String, UIComponent> {
        UIComponent component;

        public FacetsMap(UIComponent uIComponent) {
            super(3, 1.0f);
            this.component = uIComponent;
        }

        @Override
        public void clear() {
            Iterator<String> iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            super.clear();
        }

        @Override
        public Set<Map.Entry<String, UIComponent>> entrySet() {
            return new FacetsMapEntrySet(this);
        }

        @Override
        public Set<String> keySet() {
            return new FacetsMapKeySet(this);
        }

        @Override
        public UIComponent put(String string, UIComponent uIComponent) {
            if (string == null || uIComponent == null) {
                throw new NullPointerException();
            }
            if (!(string instanceof String) || !(uIComponent instanceof UIComponent)) {
                throw new ClassCastException();
            }
            UIComponent uIComponent2 = (UIComponent)super.get(string);
            if (uIComponent2 != null) {
                uIComponent2.setParent(null);
            }
            UIComponentBase.eraseParent(uIComponent);
            uIComponent.setParent(this.component);
            return super.put(string, uIComponent);
        }

        @Override
        public void putAll(Map<? extends String, ? extends UIComponent> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<? extends String, ? extends UIComponent> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public UIComponent remove(Object object) {
            UIComponent uIComponent = (UIComponent)this.get(object);
            if (uIComponent != null) {
                uIComponent.setParent(null);
            }
            super.remove(object);
            return uIComponent;
        }

        @Override
        public Collection<UIComponent> values() {
            return new FacetsMapValues(this);
        }

        Iterator<String> keySetIterator() {
            return new ArrayList(super.keySet()).iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FacetsAndChildrenIterator
    implements Iterator<UIComponent> {
        private Iterator<UIComponent> iterator;
        private boolean childMode;
        private UIComponent c;

        public FacetsAndChildrenIterator(UIComponent uIComponent) {
            this.c = uIComponent;
            this.childMode = false;
        }

        private void update() {
            if (this.iterator == null) {
                if (this.c.getFacetCount() != 0) {
                    this.iterator = this.c.getFacets().values().iterator();
                    this.childMode = false;
                } else if (this.c.getChildCount() != 0) {
                    this.iterator = this.c.getChildren().iterator();
                    this.childMode = true;
                } else {
                    this.iterator = EMPTY_ITERATOR;
                    this.childMode = true;
                }
            } else if (!this.childMode && !this.iterator.hasNext() && this.c.getChildCount() != 0) {
                this.iterator = this.c.getChildren().iterator();
                this.childMode = true;
            }
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.iterator.hasNext();
        }

        @Override
        public UIComponent next() {
            this.update();
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenListIterator
    implements ListIterator<UIComponent> {
        private ChildrenList list;
        private int index;
        private int last = -1;

        public ChildrenListIterator(ChildrenList childrenList) {
            this.list = childrenList;
            this.index = 0;
        }

        public ChildrenListIterator(ChildrenList childrenList, int n) {
            this.list = childrenList;
            if (n < 0 || n > childrenList.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public UIComponent next() {
            try {
                UIComponent uIComponent = (UIComponent)this.list.get(this.index);
                this.last = this.index++;
                return uIComponent;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }

        @Override
        public void add(UIComponent uIComponent) {
            this.last = -1;
            this.list.add(this.index++, uIComponent);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public UIComponent previous() {
            try {
                int n = this.index - 1;
                UIComponent uIComponent = (UIComponent)this.list.get(n);
                this.last = n;
                this.index = n;
                return uIComponent;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(UIComponent uIComponent) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.last, uIComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenList
    extends ArrayList<UIComponent> {
        private UIComponent component;

        public ChildrenList(UIComponent uIComponent) {
            super(6);
            this.component = uIComponent;
        }

        @Override
        public void add(int n, UIComponent uIComponent) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponentBase.eraseParent(uIComponent);
            uIComponent.setParent(this.component);
            super.add(n, uIComponent);
        }

        @Override
        public boolean add(UIComponent uIComponent) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            UIComponentBase.eraseParent(uIComponent);
            uIComponent.setParent(this.component);
            return super.add(uIComponent);
        }

        @Override
        public boolean addAll(Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> iterator = new ArrayList<UIComponent>(collection).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                if (uIComponent == null) {
                    throw new NullPointerException();
                }
                this.add(uIComponent);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean addAll(int n, Collection<? extends UIComponent> collection) {
            Iterator<? extends UIComponent> iterator = new ArrayList<UIComponent>(collection).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                UIComponent uIComponent = iterator.next();
                if (uIComponent == null) {
                    throw new NullPointerException();
                }
                this.add(n++, uIComponent);
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            int n = this.size();
            if (n < 1) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                UIComponent uIComponent = (UIComponent)this.get(i);
                uIComponent.setParent(null);
            }
            super.clear();
        }

        @Override
        public Iterator<UIComponent> iterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator() {
            return new ChildrenListIterator(this);
        }

        @Override
        public ListIterator<UIComponent> listIterator(int n) {
            return new ChildrenListIterator(this, n);
        }

        @Override
        public UIComponent remove(int n) {
            UIComponent uIComponent = (UIComponent)this.get(n);
            super.remove(n);
            uIComponent.setParent(null);
            return uIComponent;
        }

        @Override
        public boolean remove(Object object) {
            UIComponent uIComponent = (UIComponent)object;
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            if (super.remove(uIComponent)) {
                uIComponent.setParent(null);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<UIComponent> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public UIComponent set(int n, UIComponent uIComponent) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UIComponentBase.eraseParent(uIComponent);
            UIComponent uIComponent2 = (UIComponent)this.get(n);
            uIComponent2.setParent(null);
            uIComponent.setParent(this.component);
            super.set(n, uIComponent);
            return uIComponent2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributesMap
    implements Map<String, Object>,
    Serializable {
        private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
        private HashMap<String, Object> attributes;
        private transient Map<String, PropertyDescriptor> pdMap;
        private transient UIComponent component;
        private static final long serialVersionUID = -6773035086539772945L;

        private AttributesMap(UIComponent uIComponent) {
            this.component = uIComponent;
            this.pdMap = ((UIComponentBase)uIComponent).getDescriptorMap();
        }

        private AttributesMap(UIComponent uIComponent, HashMap<String, Object> hashMap) {
            this(uIComponent);
            this.attributes = hashMap;
        }

        @Override
        public boolean containsKey(Object object) {
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(object)) {
                return true;
            }
            String string = (String)object;
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor == null) {
                if (this.attributes != null) {
                    return this.attributes.containsKey(string);
                }
                return false;
            }
            return false;
        }

        @Override
        public Object get(Object object) {
            String string = (String)object;
            if (string == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(string)) {
                return this.component.getAttributesThatAreSet(false);
            }
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor != null) {
                try {
                    Method method = propertyDescriptor.getReadMethod();
                    if (method != null) {
                        return method.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    throw new IllegalArgumentException(string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FacesException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FacesException(invocationTargetException.getTargetException());
                }
            }
            if (this.attributes != null && this.attributes.containsKey(string)) {
                return this.attributes.get(string);
            }
            ValueExpression valueExpression = this.component.getValueExpression(string);
            if (valueExpression != null) {
                try {
                    return valueExpression.getValue(this.component.getFacesContext().getELContext());
                }
                catch (ELException eLException) {
                    throw new FacesException(eLException);
                }
            }
            return null;
        }

        @Override
        public Object put(String string, Object object) {
            List<String> list;
            if (string == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(string)) {
                if (this.component.attributesThatAreSet == null && object instanceof List) {
                    this.component.attributesThatAreSet = (List)object;
                    return this.component.attributesThatAreSet;
                }
                return null;
            }
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor != null) {
                try {
                    Method method;
                    Object object2 = null;
                    Method method2 = propertyDescriptor.getReadMethod();
                    if (method2 != null) {
                        object2 = method2.invoke((Object)this.component, EMPTY_OBJECT_ARRAY);
                    }
                    if ((method = propertyDescriptor.getWriteMethod()) == null) {
                        throw new IllegalArgumentException("Setter not found for property " + string);
                    }
                    method.invoke((Object)this.component, object);
                    return object2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FacesException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FacesException(invocationTargetException.getTargetException());
                }
            }
            if (object == null) {
                throw new NullPointerException();
            }
            if (this.attributes == null) {
                this.initMap();
            }
            if ((list = this.component.getAttributesThatAreSet(true)) != null && !list.contains(string)) {
                list.add(string);
            }
            return this.attributes.put(string, object);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object object) {
            String string = (String)object;
            if (string == null) {
                throw new NullPointerException();
            }
            if (ATTRIBUTES_THAT_ARE_SET_KEY.equals(string)) {
                return null;
            }
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
            if (propertyDescriptor != null) {
                throw new IllegalArgumentException(string);
            }
            if (this.attributes != null) {
                List<String> list = this.component.getAttributesThatAreSet(false);
                if (list != null) {
                    list.remove(string);
                }
                return this.attributes.remove(string);
            }
            return null;
        }

        @Override
        public int size() {
            return this.attributes != null ? this.attributes.size() : 0;
        }

        @Override
        public boolean isEmpty() {
            return this.attributes == null || this.attributes.isEmpty();
        }

        @Override
        public boolean containsValue(Object object) {
            return this.attributes != null && this.attributes.containsValue(object);
        }

        @Override
        public void clear() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
        }

        @Override
        public Set<String> keySet() {
            if (this.attributes != null) {
                return this.attributes.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            if (this.attributes != null) {
                return this.attributes.values();
            }
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.attributes != null) {
                return this.attributes.entrySet();
            }
            return Collections.emptySet();
        }

        Map getBackingAttributes() {
            return this.attributes;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map)) {
                return false;
            }
            Map map = (Map)object;
            if (map.size() != this.size()) {
                return false;
            }
            try {
                Iterator<Map.Entry<String, Object>> iterator = this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry;
                    Map.Entry<String, Object> entry2 = entry = iterator.next();
                    String string = entry2.getKey();
                    Object object2 = entry2.getValue();
                    if (!(object2 == null ? map.get(string) != null || !map.containsKey(string) : !object2.equals(map.get(string)))) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (Map.Entry<String, Object> entry : this.entrySet()) {
                n += ((Object)entry).hashCode();
            }
            return n;
        }

        private void initMap() {
            this.attributes = new HashMap(8);
        }

        PropertyDescriptor getPropertyDescriptor(String string) {
            if (this.pdMap != null) {
                return this.pdMap.get(string);
            }
            return null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            if (this.attributes == null) {
                objectOutputStream.writeObject(new HashMap(1, 1.0f));
            } else {
                objectOutputStream.writeObject(this.attributes);
            }
            objectOutputStream.writeObject(this.component.getClass());
            objectOutputStream.writeObject(this.component.saveState(FacesContext.getCurrentInstance()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.attributes = null;
            this.pdMap = null;
            this.component = null;
            this.attributes = (HashMap)objectInputStream.readObject();
            Class clazz = (Class)objectInputStream.readObject();
            try {
                this.component = (UIComponent)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.component.restoreState(FacesContext.getCurrentInstance(), objectInputStream.readObject());
        }
    }
}

