/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote.wrapper;

import java.io.IOException;
import java.util.Arrays;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.remote.logging.Log;
import org.infinispan.marshall.BufferSizePredictor;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.LogFactory;

public class HotRodEntryMarshaller
implements Marshaller {
    private static final Log log = (Log)LogFactory.getLog(HotRodEntryMarshaller.class, Log.class);
    BufferSizePredictor predictor = new IdentityBufferSizePredictor();

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        if (obj instanceof ByteArrayKey) {
            return ((ByteArrayKey)obj).getData();
        }
        throw log.unsupportedMarshallingForObject(obj.getClass().getName());
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException, InterruptedException {
        return (byte[])obj;
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return buf;
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        return Arrays.copyOfRange(buf, offset, offset + length);
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        byte[] b = (byte[])o;
        return new ByteBuffer(b, 0, b.length);
    }

    public boolean isMarshallable(Object o) throws Exception {
        return o instanceof ByteArrayKey;
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.predictor;
    }

    class IdentityBufferSizePredictor
    implements BufferSizePredictor {
        IdentityBufferSizePredictor() {
        }

        public int nextSize(Object obj) {
            return ((byte[])obj).length;
        }

        public void recordSize(int previousSize) {
        }
    }
}

