/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.operations.HttpManagementAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.dmr.ModelNode;

public class HttpManagementRemoveHandler
extends AbstractRemoveStepHandler {
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;

    public HttpManagementRemoveHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        HttpManagementRemoveHandler.removeHttpManagementService(context);
        HttpManagementRemoveHandler.clearHostControllerInfo(this.hostControllerInfo);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        HttpManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        HttpManagementAddHandler.installHttpManagementServices(context.getRunningMode(), context.getServiceTarget(), this.hostControllerInfo, this.environment, null, false);
    }

    static void clearHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo) {
        hostControllerInfo.setHttpManagementInterface(null);
        hostControllerInfo.setHttpManagementPort(0);
        hostControllerInfo.setHttpManagementSecureInterface(null);
        hostControllerInfo.setHttpManagementSecurePort(0);
        hostControllerInfo.setHttpManagementSecurityRealm(null);
    }

    static void removeHttpManagementService(OperationContext context) {
        context.removeService(HttpManagementService.SERVICE_NAME);
    }
}

