/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ManagedServerProxy;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.server.DomainServerCommunicationServices;
import org.jboss.as.server.ServerStartTask;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceActivator;

class ManagedServer {
    private static final Logger.Level DEBUG_LEVEL = Logger.Level.TRACE;
    private static final MarshallerFactory MARSHALLER_FACTORY;
    private static final MarshallingConfiguration CONFIG;
    private static final String SERVER_PROCESS_NAME_PREFIX = "Server:";
    private final byte[] authKey;
    private final String serverName;
    private final String serverProcessName;
    private final String hostControllerName;
    private final InetSocketAddress managementSocket;
    private final ProcessControllerClient processControllerClient;
    private final ManagedServerProxy protocolClient;
    private final TransformingProxyController proxyController;
    private volatile boolean requiresReload;
    private volatile InternalState requiredState = InternalState.STOPPED;
    private volatile InternalState internalState = InternalState.STOPPED;
    private volatile int operationID = CurrentOperationIdHolder.getCurrentOperationID();
    private volatile ManagedServerBootConfiguration bootConfiguration;

    static String getServerProcessName(String serverName) {
        return SERVER_PROCESS_NAME_PREFIX + serverName;
    }

    static boolean isServerProcess(String serverProcessName) {
        return serverProcessName.startsWith(SERVER_PROCESS_NAME_PREFIX);
    }

    static String getServerName(String serverProcessName) {
        return serverProcessName.substring(SERVER_PROCESS_NAME_PREFIX.length());
    }

    ManagedServer(String hostControllerName, String serverName, byte[] authKey, ProcessControllerClient processControllerClient, InetSocketAddress managementSocket, TransformationTarget transformationTarget) {
        assert (hostControllerName != null) : "hostControllerName is null";
        assert (serverName != null) : "serverName is null";
        assert (processControllerClient != null) : "processControllerSlave is null";
        assert (managementSocket != null) : "managementSocket is null";
        this.hostControllerName = hostControllerName;
        this.serverName = serverName;
        this.serverProcessName = ManagedServer.getServerProcessName(serverName);
        this.processControllerClient = processControllerClient;
        this.managementSocket = managementSocket;
        this.authKey = authKey;
        PathElement serverPath = PathElement.pathElement((String)"server", (String)serverName);
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"host", (String)hostControllerName), serverPath});
        this.protocolClient = new ManagedServerProxy(this, address);
        this.proxyController = TransformingProxyController.Factory.create((TransactionalProtocolClient)this.protocolClient, (Transformers)Transformers.Factory.create((TransformationTarget)transformationTarget), (PathAddress)address, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.SERVER, (boolean)true);
    }

    byte[] getAuthKey() {
        return this.authKey;
    }

    public String getServerName() {
        return this.serverName;
    }

    public TransformingProxyController getProxyController() {
        return this.proxyController;
    }

    public ServerStatus getState() {
        InternalState requiredState = this.requiredState;
        InternalState state = this.internalState;
        if (requiredState == InternalState.FAILED) {
            return ServerStatus.FAILED;
        }
        switch (state) {
            case STOPPED: {
                return ServerStatus.STOPPED;
            }
            case SERVER_STARTED: {
                return ServerStatus.STARTED;
            }
        }
        if (requiredState == InternalState.SERVER_STARTED) {
            return ServerStatus.STARTING;
        }
        return ServerStatus.STOPPING;
    }

    protected boolean isRequiresReload() {
        return this.requiresReload;
    }

    protected void requireReload() {
        this.requiresReload = true;
    }

    protected synchronized void start(ManagedServerBootCmdFactory factory) {
        InternalState current;
        InternalState required = this.requiredState;
        if (required == InternalState.SERVER_STARTED) {
            return;
        }
        if (required != InternalState.FAILED && (current = this.internalState) != required) {
            throw new IllegalStateException();
        }
        this.operationID = CurrentOperationIdHolder.getCurrentOperationID();
        this.bootConfiguration = factory.createConfiguration();
        this.requiredState = InternalState.SERVER_STARTED;
        HostControllerLogger.ROOT_LOGGER.startingServer(this.serverName);
        this.transition();
    }

    protected synchronized void stop() {
        InternalState required = this.requiredState;
        if (required != InternalState.STOPPED) {
            this.requiredState = InternalState.STOPPED;
            HostControllerLogger.ROOT_LOGGER.stoppingServer(this.serverName);
            this.transition(false);
        }
    }

    protected synchronized void destroy() {
        InternalState required = this.requiredState;
        if (required == InternalState.STOPPED) {
            if (this.internalState != InternalState.STOPPED) {
                try {
                    this.processControllerClient.destroyProcess(this.serverProcessName);
                }
                catch (IOException e) {
                    HostControllerLogger.ROOT_LOGGER.debugf(e, "failed to send destroy_process message to %s", this.serverName);
                }
            }
        } else {
            this.stop();
        }
    }

    protected synchronized void kill() {
        InternalState required = this.requiredState;
        if (required == InternalState.STOPPED) {
            if (this.internalState != InternalState.STOPPED) {
                try {
                    this.processControllerClient.killProcess(this.serverProcessName);
                }
                catch (IOException e) {
                    HostControllerLogger.ROOT_LOGGER.debugf(e, "failed to send kill_process message to %s", this.serverName);
                }
            }
        } else {
            this.stop();
        }
    }

    protected synchronized void reconnectServerProcess(ManagedServerBootCmdFactory factory) {
        if (this.requiredState != InternalState.SERVER_STARTED) {
            this.bootConfiguration = factory;
            this.requiredState = InternalState.SERVER_STARTED;
            HostControllerLogger.ROOT_LOGGER.reconnectingServer(this.serverName);
            this.internalSetState(new ReconnectTask(), InternalState.STOPPED, InternalState.SEND_STDIN);
        }
    }

    protected synchronized void removeServerProcess() {
        this.requiredState = InternalState.STOPPED;
        this.internalSetState(new ProcessRemoveTask(), InternalState.STOPPED, InternalState.PROCESS_REMOVING);
    }

    protected synchronized void setServerProcessStopping() {
        this.requiredState = InternalState.STOPPED;
        this.internalSetState(null, InternalState.STOPPED, InternalState.PROCESS_STOPPING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean awaitState(InternalState expected) {
        ManagedServer managedServer = this;
        synchronized (managedServer) {
            InternalState initialRequired = this.requiredState;
            InternalState required;
            while ((required = this.requiredState) != InternalState.FAILED) {
                if (initialRequired != required) {
                    return false;
                }
                InternalState current = this.internalState;
                if (expected == current) {
                    return true;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return false;
        }
    }

    protected void processAdded() {
        this.finishTransition(InternalState.PROCESS_ADDING, InternalState.PROCESS_ADDED);
    }

    protected void processStarted() {
        this.finishTransition(InternalState.PROCESS_STARTING, InternalState.PROCESS_STARTED);
    }

    protected synchronized TransactionalProtocolClient channelRegistered(ManagementChannelHandler channelAssociation) {
        InternalState current = this.internalState;
        channelAssociation.getAttachments().attach(TransactionalProtocolClient.SEND_SUBJECT, (Object)Boolean.TRUE);
        final TransactionalProtocolClient remoteClient = TransactionalProtocolHandlers.createClient((ManagementChannelHandler)channelAssociation);
        if (current == InternalState.SERVER_STARTED && this.proxyController == null) {
            this.protocolClient.connected(remoteClient);
            this.requiresReload = false;
        } else {
            this.internalSetState(new TransitionTask(){

                @Override
                public void execute(ManagedServer server) throws Exception {
                    ManagedServer.this.protocolClient.connected(remoteClient);
                }
            }, InternalState.SEND_STDIN, InternalState.SERVER_STARTING);
        }
        return remoteClient;
    }

    protected synchronized void serverStarted(TransitionTask task) {
        this.internalSetState(task, InternalState.SERVER_STARTING, InternalState.SERVER_STARTED);
    }

    protected synchronized void serverStartFailed() {
        this.internalSetState(null, InternalState.SERVER_STARTING, InternalState.FAILED);
    }

    protected synchronized boolean callbackUnregistered(TransactionalProtocolClient old, boolean shuttingDown) {
        this.protocolClient.disconnected(old);
        if (!shuttingDown && this.requiredState == InternalState.SERVER_STARTED) {
            InternalState state = this.internalState;
            if (state == InternalState.PROCESS_STOPPED || state == InternalState.PROCESS_STOPPING || state == InternalState.STOPPED) {
                return true;
            }
            try {
                HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, "trying to reconnect to %s current-state (%s) required-state (%s)", this.serverName, (Object)state, (Object)this.requiredState);
                this.internalSetState(new ReconnectTask(), state, InternalState.SEND_STDIN);
            }
            catch (Exception e) {
                HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, e, "failed to send reconnect task", new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected synchronized void processFinished() {
        InternalState required = this.requiredState;
        InternalState state = this.internalState;
        if (required == InternalState.STOPPED && state == InternalState.PROCESS_STOPPING) {
            this.finishTransition(InternalState.PROCESS_STOPPING, InternalState.PROCESS_STOPPED);
        } else {
            this.requiredState = InternalState.FAILED;
            this.internalSetState(null, state, InternalState.PROCESS_STOPPED);
        }
    }

    protected void processRemoved() {
        this.finishTransition(InternalState.PROCESS_REMOVING, InternalState.STOPPED);
    }

    private void transition() {
        this.transition(true);
    }

    private synchronized void transition(boolean checkAsync) {
        InternalState required = this.requiredState;
        InternalState current = this.internalState;
        if (checkAsync && current.isAsync()) {
            return;
        }
        InternalState next = ManagedServer.nextState(current, required);
        if (next != null) {
            TransitionTask task = this.getTransitionTask(next);
            this.internalSetState(task, current, next);
        }
    }

    synchronized void transitionFailed(InternalState state) {
        InternalState current = this.internalState;
        if (state == current) {
            switch (current) {
                case PROCESS_ADDING: {
                    this.internalState = InternalState.PROCESS_STOPPED;
                    break;
                }
                case PROCESS_STARTED: {
                    this.internalSetState(this.getTransitionTask(InternalState.PROCESS_STOPPING), InternalState.PROCESS_STARTED, InternalState.PROCESS_ADDED);
                    break;
                }
                case PROCESS_STARTING: {
                    this.internalState = InternalState.PROCESS_ADDED;
                    break;
                }
                case SEND_STDIN: 
                case SERVER_STARTING: {
                    this.internalState = InternalState.PROCESS_STARTED;
                }
            }
            this.requiredState = InternalState.FAILED;
            this.notifyAll();
        }
    }

    private synchronized void finishTransition(InternalState current, InternalState next) {
        this.internalSetState(this.getTransitionTask(next), current, next);
        this.transition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetState(TransitionTask task, InternalState current, InternalState next) {
        assert (Thread.holdsLock(this));
        InternalState internalState = this.internalState;
        HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, "changing server state (%s) from %s to %s", this.serverName, (Object)current, (Object)next);
        if (internalState == current) {
            try {
                if (task != null) {
                    task.execute(this);
                }
                this.internalState = next;
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, e, "transition (%s > %s) failed for server \"%s\"", (Object)current, (Object)next, this.serverName);
                this.transitionFailed(current);
            }
            finally {
                this.notifyAll();
            }
        }
        return false;
    }

    private TransitionTask getTransitionTask(InternalState next) {
        switch (next) {
            case PROCESS_ADDING: {
                return new ProcessAddTask();
            }
            case PROCESS_STARTING: {
                return new ProcessStartTask();
            }
            case SEND_STDIN: {
                return new SendStdInTask();
            }
            case SERVER_STARTED: {
                return new ServerStartedTask();
            }
            case PROCESS_STOPPING: {
                return new ServerStopTask();
            }
            case PROCESS_REMOVING: {
                return new ProcessRemoveTask();
            }
        }
        return null;
    }

    private static InternalState nextState(InternalState state, InternalState required) {
        switch (state) {
            case STOPPED: {
                if (required != InternalState.SERVER_STARTED) break;
                return InternalState.PROCESS_ADDING;
            }
            case PROCESS_ADDING: {
                if (required != InternalState.SERVER_STARTED) break;
                return InternalState.PROCESS_ADDED;
            }
            case PROCESS_ADDED: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.PROCESS_STARTING;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_REMOVING;
            }
            case PROCESS_STARTING: {
                if (required != InternalState.SERVER_STARTED) break;
                return InternalState.PROCESS_STARTED;
            }
            case PROCESS_STARTED: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SEND_STDIN;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case SEND_STDIN: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SERVER_STARTING;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case SERVER_STARTING: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SERVER_STARTED;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case SERVER_STARTED: {
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case PROCESS_STOPPING: {
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPED;
            }
            case PROCESS_STOPPED: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.PROCESS_STARTING;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_REMOVING;
            }
            case PROCESS_REMOVING: {
                if (required != InternalState.STOPPED) break;
                return InternalState.STOPPED;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private static Map<String, String> parseLaunchProperties(List<String> commands) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String cmd : commands) {
            if (!cmd.startsWith("-D")) continue;
            String[] parts = cmd.substring(2).split("=");
            if (parts.length == 2) {
                result.put(parts[0], parts[1]);
                continue;
            }
            if (parts.length != 1) continue;
            result.put(parts[0], "true");
        }
        return result;
    }

    static {
        try {
            MARSHALLER_FACTORY = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)"org.jboss.marshalling.river")).getClassLoader());
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
        ClassLoader cl = ManagedServer.class.getClassLoader();
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setVersion(2);
        config.setClassResolver((ClassResolver)new SimpleClassResolver(cl));
        CONFIG = config;
    }

    private class ReconnectTask
    implements TransitionTask {
        private ReconnectTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            String hostName = ManagedServer.this.managementSocket.toString().indexOf("/") == 0 ? ManagedServer.this.managementSocket.getAddress().getHostAddress() : ManagedServer.this.managementSocket.getHostName();
            int port = ManagedServer.this.managementSocket.getPort();
            ManagedServer.this.processControllerClient.reconnectProcess(ManagedServer.this.serverProcessName, NetworkUtils.formatPossibleIpv6Address((String)hostName), port, ManagedServer.this.bootConfiguration.isManagementSubsystemEndpoint(), ManagedServer.this.authKey);
        }
    }

    private class ServerStopTask
    implements TransitionTask {
        private ServerStopTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            ManagedServer.this.processControllerClient.stopProcess(ManagedServer.this.serverProcessName);
        }
    }

    private class ServerStartedTask
    implements TransitionTask {
        private ServerStartedTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
        }
    }

    private class SendStdInTask
    implements TransitionTask {
        private SendStdInTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            List bootUpdates = Collections.emptyList();
            Map launchProperties = ManagedServer.parseLaunchProperties(ManagedServer.this.bootConfiguration.getServerLaunchCommand());
            boolean useSubsystemEndpoint = ManagedServer.this.bootConfiguration.isManagementSubsystemEndpoint();
            ModelNode endpointConfig = ManagedServer.this.bootConfiguration.getSubsystemEndpointConfiguration();
            ServiceActivator hostControllerCommActivator = DomainServerCommunicationServices.create((ModelNode)endpointConfig, (InetSocketAddress)ManagedServer.this.managementSocket, (String)ManagedServer.this.serverName, (String)ManagedServer.this.serverProcessName, (byte[])ManagedServer.this.authKey, (int)ManagedServer.this.operationID, (boolean)useSubsystemEndpoint);
            ServerStartTask startTask = new ServerStartTask(ManagedServer.this.hostControllerName, ManagedServer.this.serverName, 0, Collections.singletonList(hostControllerCommActivator), bootUpdates, launchProperties);
            Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(CONFIG);
            OutputStream os = ManagedServer.this.processControllerClient.sendStdin(ManagedServer.this.serverProcessName);
            marshaller.start(Marshalling.createByteOutput((OutputStream)os));
            marshaller.writeObject((Object)startTask);
            marshaller.finish();
            marshaller.close();
            os.close();
        }
    }

    private class ProcessStartTask
    implements TransitionTask {
        private ProcessStartTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            ManagedServer.this.processControllerClient.startProcess(ManagedServer.this.serverProcessName);
        }
    }

    private class ProcessRemoveTask
    implements TransitionTask {
        private ProcessRemoveTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            ManagedServer.this.processControllerClient.removeProcess(ManagedServer.this.serverProcessName);
        }
    }

    private class ProcessAddTask
    implements TransitionTask {
        private ProcessAddTask() {
        }

        @Override
        public void execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            List<String> command = ManagedServer.this.bootConfiguration.getServerLaunchCommand();
            Map<String, String> env = ManagedServer.this.bootConfiguration.getServerLaunchEnvironment();
            HostControllerEnvironment environment = ManagedServer.this.bootConfiguration.getHostControllerEnvironment();
            ManagedServer.this.processControllerClient.addProcess(ManagedServer.this.serverProcessName, ManagedServer.this.authKey, command.toArray(new String[command.size()]), environment.getHomeDir().getAbsolutePath(), env);
        }
    }

    static interface TransitionTask {
        public void execute(ManagedServer var1) throws Exception;
    }

    static enum InternalState {
        STOPPED,
        PROCESS_ADDING(true),
        PROCESS_ADDED,
        PROCESS_STARTING(true),
        PROCESS_STARTED,
        SEND_STDIN(true),
        SERVER_STARTING(true),
        SERVER_STARTED,
        PROCESS_STOPPING(true),
        PROCESS_STOPPED,
        PROCESS_REMOVING(true),
        FAILED;

        private final boolean async;

        private InternalState() {
            this(false);
        }

        private InternalState(boolean async) {
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }
    }

    static interface ManagedServerBootConfiguration {
        public Map<String, String> getServerLaunchEnvironment();

        public List<String> getServerLaunchCommand();

        public HostControllerEnvironment getHostControllerEnvironment();

        public boolean isManagementSubsystemEndpoint();

        public ModelNode getSubsystemEndpointConfiguration();
    }
}

