/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.ejb.EJBException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.logging.Logger;

public final class JDBCStoreEntityCommand {
    private final JDBCEntityBridge entity;
    private final JDBCFieldBridge[] primaryKeyFields;
    private final Logger log;

    public JDBCStoreEntityCommand(JDBCStoreManager manager) {
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.primaryKeyFields = this.entity.getPrimaryKeyFields();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.FieldIterator dirtyIterator = this.entity.getDirtyIterator(ctx);
        if (!dirtyIterator.hasNext() || this.entity.isBeingRemoved(ctx) || this.entity.isScheduledForBatchCascadeDelete(ctx)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Store command NOT executed. Entity is not dirty , is being removed or scheduled for *batch* cascade delete: pk=" + ctx.getPrimaryKeyUnchecked()));
            }
            return;
        }
        StringBuffer sql = new StringBuffer(200);
        sql.append("UPDATE ").append(this.entity.getQualifiedTableName()).append(" SET ");
        SQLUtil.getSetClause(dirtyIterator, sql).append(" WHERE ");
        SQLUtil.getWhereClause(this.primaryKeyFields, sql);
        boolean hasLockedFields = this.entity.hasLockedFields(ctx);
        JDBCEntityBridge.FieldIterator lockedIterator = null;
        if (hasLockedFields) {
            lockedIterator = this.entity.getLockedIterator(ctx);
            while (lockedIterator.hasNext()) {
                sql.append(" AND ");
                JDBCCMPFieldBridge field = lockedIterator.next();
                if (field.getLockedValue(ctx) == null) {
                    SQLUtil.getIsNullClause(false, field, "", sql);
                    lockedIterator.remove();
                    continue;
                }
                SQLUtil.getWhereClause(field, sql);
            }
        }
        Connection con = null;
        PreparedStatement ps = null;
        int rowsAffected = 0;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + sql));
            }
            con = this.entity.getDataSource().getConnection();
            ps = con.prepareStatement(sql.toString());
            int index = 1;
            dirtyIterator.reset();
            while (dirtyIterator.hasNext()) {
                index = dirtyIterator.next().setInstanceParameters(ps, index, ctx);
            }
            index = this.entity.setPrimaryKeyParameters(ps, index, ctx.getPrimaryKeyUnchecked());
            if (hasLockedFields) {
                lockedIterator.reset();
                while (lockedIterator.hasNext()) {
                    JDBCCMPFieldBridge field = lockedIterator.next();
                    Object value = field.getLockedValue(ctx);
                    index = field.setArgumentParameters(ps, index, value);
                }
            }
            rowsAffected = ps.executeUpdate();
        }
        catch (EJBException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw CmpMessages.MESSAGES.storeFailed(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        if (rowsAffected != 1) {
            throw CmpMessages.MESSAGES.updateFailedTooManyRowsAffected(rowsAffected, ctx.getPrimaryKeyUnchecked());
        }
        dirtyIterator.reset();
        while (dirtyIterator.hasNext()) {
            dirtyIterator.next().setClean(ctx);
        }
        return;
    }
}

