/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.Configuration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

class SecurityActions {
    SecurityActions() {
    }

    protected static void addShutdownHook(Thread hook) {
        TCLAction.UTIL.addShutdownHook(hook);
    }

    protected static String getSystemProperty(String name) {
        return TCLAction.UTIL.getSystemProperty(name);
    }

    protected static void setSystemProperty(String name, String value) {
        TCLAction.UTIL.setSystemProperty(name, value);
    }

    protected static ClassLoader getClassLoader(Class<?> cls) {
        return TCLAction.UTIL.getClassLoader(cls);
    }

    protected static String getEnvironmentVariable(String name) {
        return TCLAction.UTIL.getEnvironmentVariable(name);
    }

    static <T> T loadAndInstantiateFromClassClassLoader(final Class<?> base, final Class<T> iface, final String name) throws Exception {
        if (System.getSecurityManager() == null) {
            return SecurityActions.internalLoadAndInstantiateFromClassClassLoader(base, iface, name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return SecurityActions.internalLoadAndInstantiateFromClassClassLoader(base, iface, name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Exception(t);
        }
    }

    private static <T> T internalLoadAndInstantiateFromClassClassLoader(Class<?> base, Class<T> iface, String name) throws Exception {
        ClassLoader cl = base.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Class<?> clazz = cl.loadClass(name);
        return iface.cast(clazz.newInstance());
    }

    static <T> T loadAndInstantiateFromModule(final String moduleId, final Class<T> iface, final String name) throws Exception {
        if (System.getSecurityManager() == null) {
            return SecurityActions.internalLoadAndInstantiateFromModule(moduleId, iface, name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return SecurityActions.internalLoadAndInstantiateFromModule(moduleId, iface, name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Exception(t);
        }
    }

    private static <T> T internalLoadAndInstantiateFromModule(String moduleId, Class<T> iface, String name) throws Exception {
        ModuleLoader loader = Module.getCallerModuleLoader();
        Module module = loader.loadModule(ModuleIdentifier.fromString((String)moduleId));
        ModuleClassLoader cl = module.getClassLoader();
        Class<?> clazz = cl.loadClass(name);
        return iface.cast(clazz.newInstance());
    }

    static Configuration getGlobalJaasConfiguration() throws SecurityException {
        if (System.getSecurityManager() == null) {
            return SecurityActions.internalGetGlobalJaasConfiguration();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Configuration>(){

                @Override
                public Configuration run() throws Exception {
                    return SecurityActions.internalGetGlobalJaasConfiguration();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SecurityException)e.getCause();
        }
    }

    private static Configuration internalGetGlobalJaasConfiguration() throws SecurityException {
        return Configuration.getConfiguration();
    }

    static void setGlobalJaasConfiguration(final Configuration configuration) throws SecurityException {
        if (System.getSecurityManager() == null) {
            SecurityActions.internalSetGlobalJaasConfiguration(configuration);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SecurityActions.internalSetGlobalJaasConfiguration(configuration);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SecurityException)e.getCause();
            }
        }
    }

    private static void internalSetGlobalJaasConfiguration(Configuration configuration) throws SecurityException {
        Configuration.setConfiguration(configuration);
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public void addShutdownHook(Thread t) {
                Runtime.getRuntime().addShutdownHook(t);
            }

            @Override
            public String getSystemProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public void setSystemProperty(String name, String value) {
                System.setProperty(name, value);
            }

            @Override
            public ClassLoader getClassLoader(Class<?> cls) {
                return cls.getClassLoader();
            }

            @Override
            public String getEnvironmentVariable(String name) {
                return System.getenv(name);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public void addShutdownHook(final Thread thread) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Runtime.getRuntime().addShutdownHook(thread);
                        return null;
                    }
                });
            }

            @Override
            public String getSystemProperty(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty(name);
                    }
                });
            }

            @Override
            public void setSystemProperty(final String name, final String value) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty(name, value);
                        return null;
                    }
                });
            }

            @Override
            public ClassLoader getClassLoader(final Class<?> cls) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return cls.getClassLoader();
                    }
                });
            }

            @Override
            public String getEnvironmentVariable(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getenv(name);
                    }
                });
            }
        };

        public void addShutdownHook(Thread var1);

        public ClassLoader getClassLoader(Class<?> var1);

        public String getSystemProperty(String var1);

        public void setSystemProperty(String var1, String var2);

        public String getEnvironmentVariable(String var1);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static void addShutdownHook(Thread hook) {
                UTIL.getTCLAction().addShutdownHook(hook);
            }

            public static String getSystemProperty(String name) {
                return UTIL.getTCLAction().getSystemProperty(name);
            }

            public static void setSystemProperty(String name, String value) {
                UTIL.getTCLAction().setSystemProperty(name, value);
            }

            public static ClassLoader getClassLoader(Class<?> cls) {
                return UTIL.getTCLAction().getClassLoader(cls);
            }

            public static String getEnvironmentVariable(String name) {
                return UTIL.getTCLAction().getEnvironmentVariable(name);
            }
        }
    }
}

