/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.SingleFunction;
import org.apache.solr.search.function.ValueSource;

public abstract class SimpleFloatFunction
extends SingleFunction {
    public SimpleFloatFunction(ValueSource source) {
        super(source);
    }

    protected abstract float func(int var1, DocValues var2);

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return SimpleFloatFunction.this.func(doc, vals);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SimpleFloatFunction.this.name() + '(' + vals.toString(doc) + ')';
            }
        };
    }
}

