/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;

public class ShortFieldSource
extends FieldCacheSource {
    FieldCache.ShortParser parser;

    public ShortFieldSource(String field) {
        this(field, null);
    }

    public ShortFieldSource(String field, FieldCache.ShortParser parser) {
        super(field);
        this.parser = parser;
    }

    @Override
    public String description() {
        return "short(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final short[] arr = this.parser == null ? this.cache.getShorts(reader, this.field) : this.cache.getShorts(reader, this.field, this.parser);
        return new DocValues(){

            @Override
            public byte byteVal(int doc) {
                return (byte)arr[doc];
            }

            @Override
            public short shortVal(int doc) {
                return arr[doc];
            }

            @Override
            public float floatVal(int doc) {
                return arr[doc];
            }

            @Override
            public int intVal(int doc) {
                return arr[doc];
            }

            @Override
            public long longVal(int doc) {
                return arr[doc];
            }

            @Override
            public double doubleVal(int doc) {
                return arr[doc];
            }

            @Override
            public String strVal(int doc) {
                return Short.toString(arr[doc]);
            }

            @Override
            public String toString(int doc) {
                return ShortFieldSource.this.description() + '=' + this.shortVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != ShortFieldSource.class) {
            return false;
        }
        ShortFieldSource other = (ShortFieldSource)o;
        return super.equals(other) && (this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass());
    }

    @Override
    public int hashCode() {
        int h = this.parser == null ? Short.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

