/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.StringIndexDocValues;
import org.apache.solr.search.function.ValueSource;

public class OrdFieldSource
extends ValueSource {
    protected String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public OrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "ord(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new StringIndexDocValues(this, reader, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public float floatVal(int doc) {
                return this.order[doc];
            }

            @Override
            public int intVal(int doc) {
                return this.order[doc];
            }

            @Override
            public long longVal(int doc) {
                return this.order[doc];
            }

            @Override
            public double doubleVal(int doc) {
                return this.order[doc];
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(this.order[doc]);
            }

            @Override
            public String toString(int doc) {
                return OrdFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == OrdFieldSource.class && this.field.equals(((OrdFieldSource)o).field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

