/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public abstract class DualFloatFunction
extends ValueSource {
    protected final ValueSource a;
    protected final ValueSource b;

    public DualFloatFunction(ValueSource a, ValueSource b) {
        this.a = a;
        this.b = b;
    }

    protected abstract String name();

    protected abstract float func(int var1, DocValues var2, DocValues var3);

    @Override
    public String description() {
        return this.name() + "(" + this.a.description() + "," + this.b.description() + ")";
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues aVals = this.a.getValues(context, reader);
        final DocValues bVals = this.b.getValues(context, reader);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return DualFloatFunction.this.func(doc, aVals, bVals);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                return DualFloatFunction.this.name() + '(' + aVals.toString(doc) + ',' + bVals.toString(doc) + ')';
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.a.createWeight(context, searcher);
        this.b.createWeight(context, searcher);
    }

    @Override
    public int hashCode() {
        int h = this.a.hashCode();
        h ^= h << 13 | h >>> 20;
        h += this.b.hashCode();
        h ^= h << 23 | h >>> 10;
        return h += this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DualFloatFunction other = (DualFloatFunction)o;
        return this.a.equals(other.a) && this.b.equals(other.b);
    }
}

