/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.PropertyResourceTransformers;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.as.remoting.RemotingSubsystem12Parser;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.RemotingSubsystemXMLPersister;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.as.remoting.SaslResourceTransformers;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";
    private static final String RESOURCE_NAME = RemotingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String NODE_NAME_PROPERTY = "jboss.node.name";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 4;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final SensitivityClassification REMOTING_SECURITY = new SensitivityClassification("remoting", "remoting-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition REMOTING_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(REMOTING_SECURITY);
    private static final ModelVersion VERSION_1_1 = ModelVersion.create((int)1, (int)1);
    private static final ModelVersion VERSION_1_2 = ModelVersion.create((int)1, (int)2);
    private static final ModelVersion VERSION_1_3 = ModelVersion.create((int)1, (int)3);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, RemotingExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 4, 0);
        registration.registerXMLElementWriter((XMLElementWriter)RemotingSubsystemXMLPersister.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new RemotingSubsystemRootResource(context.getProcessType()));
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration connector = subsystem.registerSubModel((ResourceDefinition)ConnectorResource.INSTANCE);
        connector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration sasl = connector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE);
        sasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE);
        sasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        subsystem.registerSubModel((ResourceDefinition)RemoteOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)LocalOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)GenericOutboundConnectionResourceDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_1(registration);
            this.registerTransformers_1_3(registration, VERSION_1_2);
            this.registerTransformers_1_3(registration, VERSION_1_3);
        }
    }

    private void registerTransformers_1_1(SubsystemRegistration registration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, RemotingSubsystemRootResource.ATTRIBUTES);
        ResourceTransformationDescriptionBuilder connector = ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(ConnectorResource.PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, ConnectorResource.ATTRIBUTES)).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ConnectorCommon.SASL_PROTOCOL.getDefaultValue()}), new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SERVER_NAME})).end();
        PropertyResourceTransformers.registerTransformers(connector);
        SaslResourceTransformers.registerTransformers(connector);
        ResourceTransformationDescriptionBuilder remoteOutboundConnection = ((AttributeTransformationDescriptionBuilder)builder.addChildResource(RemoteOutboundConnectionResourceDefinition.ADDRESS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.USERNAME})).end();
        PropertyResourceTransformers.registerTransformers(remoteOutboundConnection);
        ResourceTransformationDescriptionBuilder localOutboundConnection = builder.addChildResource(LocalOutboundConnectionResourceDefinition.ADDRESS);
        PropertyResourceTransformers.registerTransformers(localOutboundConnection);
        ResourceTransformationDescriptionBuilder outboundConnection = builder.addChildResource(GenericOutboundConnectionResourceDefinition.ADDRESS);
        PropertyResourceTransformers.registerTransformers(outboundConnection);
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)registration, (ModelVersionRange)VERSION_1_1);
    }

    private void registerTransformers_1_3(SubsystemRegistration registration, ModelVersion version) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(ConnectorResource.PATH).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ConnectorCommon.SASL_PROTOCOL.getDefaultValue()}), new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SERVER_NAME});
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)registration, (ModelVersionRange)version);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_0.getUriString(), (XMLElementReader)RemotingSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_1.getUriString(), (XMLElementReader)RemotingSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_2.getUriString(), (XMLElementReader)RemotingSubsystem12Parser.INSTANCE);
    }

    static final class RemotingSubsystem10Parser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private static final RemotingSubsystem10Parser INSTANCE = new RemotingSubsystem10Parser();

        RemotingSubsystem10Parser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", RemotingExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
            list.add(subsystem);
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                boolean doneWorkerThreadPool = false;
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case WORKER_THREAD_POOL: {
                                if (doneWorkerThreadPool) {
                                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.WORKER_THREAD_POOL.getLocalName());
                                }
                                doneWorkerThreadPool = true;
                                this.parseWorkerThreadPool(reader, subsystem);
                                continue block7;
                            }
                            case CONNECTOR: {
                                this.parseConnector(reader, address, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseWorkerThreadPool(XMLExtendedStreamReader reader, ModelNode subsystemAdd) throws XMLStreamException {
            int count = reader.getAttributeCount();
            block8: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case WORKER_READ_THREADS: {
                        if (subsystemAdd.hasDefined("worker-read-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-read-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_READ_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_CORE_THREADS: {
                        if (subsystemAdd.hasDefined("worker-task-core-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-core-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_CORE_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_KEEPALIVE: {
                        if (subsystemAdd.hasDefined("worker-task-keepalive")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-keepalive");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_KEEPALIVE.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_LIMIT: {
                        if (subsystemAdd.hasDefined("worker-task-limit")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-limit");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_LIMIT.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_MAX_THREADS: {
                        if (subsystemAdd.hasDefined("worker-task-max-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-max-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_MAX_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_WRITE_THREADS: {
                        if (subsystemAdd.hasDefined("worker-write-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-write-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_WRITE_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            String name = null;
            String socketBinding = null;
            EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                required.remove((Object)attribute);
                switch (attribute) {
                    case NAME: {
                        name = value;
                        continue block12;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = value;
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            assert (name != null);
            assert (socketBinding != null);
            ModelNode connector = new ModelNode();
            connector.get("operation").set("add");
            connector.get("address").set(address).add("connector", name);
            connector.get("socket-binding").set(socketBinding);
            list.add(connector);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block13: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case SASL: {
                                this.parseSaslElement(reader, connector.get("address"), list);
                                continue block13;
                            }
                            case PROPERTIES: {
                                this.parseProperties(reader, connector.get("address"), list);
                                continue block13;
                            }
                            case AUTHENTICATION_PROVIDER: {
                                connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                                continue block13;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseSaslElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            ModelNode saslElement = new ModelNode();
            saslElement.get("operation").set("add");
            saslElement.get("address").set(address).add(SaslResource.SASL_CONFIG_PATH.getKey(), SaslResource.SASL_CONFIG_PATH.getValue());
            list.add(saslElement);
            int count = reader.getAttributeCount();
            if (count > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block16: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case INCLUDE_MECHANISMS: {
                                ModelNode includes = saslElement.get("include-mechanisms");
                                for (String s : (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    includes.add().set(s);
                                }
                                continue block16;
                            }
                            case POLICY: {
                                this.parsePolicyElement(reader, saslElement.get("address"), list);
                                continue block16;
                            }
                            case PROPERTIES: {
                                this.parseProperties(reader, saslElement.get("address"), list);
                                continue block16;
                            }
                            case QOP: {
                                String[] qop;
                                for (String q : qop = (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    try {
                                        saslElement.get("qop").add(SaslQop.fromString((String)q).getString().toLowerCase(Locale.ENGLISH));
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw RemotingMessages.MESSAGES.invalidQOPV(q);
                                    }
                                }
                                continue block16;
                            }
                            case REUSE_SESSION: {
                                saslElement.get("reuse-session").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block16;
                            }
                            case SERVER_AUTH: {
                                saslElement.get("server-auth").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block16;
                            }
                            case STRENGTH: {
                                String[] strength;
                                for (String s : strength = (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    try {
                                        saslElement.get("strength").add(SaslStrength.valueOf((String)s.toUpperCase(Locale.ENGLISH)).name().toLowerCase(Locale.ENGLISH));
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw RemotingMessages.MESSAGES.invalidStrength(s);
                                    }
                                }
                                continue block16;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        ModelNode parsePolicyElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            ModelNode policy = new ModelNode();
            policy.get("operation").set("add");
            policy.get("address").set(address).add(SaslPolicyResource.SASL_POLICY_CONFIG_PATH.getKey(), SaslPolicyResource.SASL_POLICY_CONFIG_PATH.getValue());
            list.add(policy);
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block11: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case FORWARD_SECRECY: {
                                policy.get("forward-secrecy").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_ACTIVE: {
                                policy.get("no-active").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_ANONYMOUS: {
                                policy.get("no-anonymous").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_DICTIONARY: {
                                policy.get("no-dictionary").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_PLAIN_TEXT: {
                                policy.get("no-plain-text").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case PASS_CREDENTIALS: {
                                policy.get("pass-credentials").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return policy;
        }

        private void parseProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            while (reader.nextTag() != 2) {
                reader.require(1, Namespace.REMOTING_1_0.getUriString(), Element.PROPERTY.getLocalName());
                Property property = ParseUtils.readProperty((XMLExtendedStreamReader)reader);
                ModelNode propertyOp = new ModelNode();
                propertyOp.get("operation").set("add");
                propertyOp.get("address").set(address).add("property", property.getName());
                propertyOp.get("value").set(property.getValue());
                list.add(propertyOp);
            }
        }
    }
}

