/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import org.jboss.as.repository.HashUtil;

public class ContentReference {
    private final String contentIdentifier;
    private final String hexHash;

    public ContentReference(String contentIdentifier, String hexHash) {
        this.contentIdentifier = contentIdentifier;
        this.hexHash = hexHash == null ? "" : hexHash;
    }

    public ContentReference(String contentIdentifier, byte[] hash) {
        this(contentIdentifier, hash, System.currentTimeMillis());
    }

    public ContentReference(String contentIdentifier, byte[] hash, long timestamp) {
        this.contentIdentifier = contentIdentifier;
        this.hexHash = hash == null || hash.length == 0 ? "" : HashUtil.bytesToHexString(hash);
    }

    public String getContentIdentifier() {
        return this.contentIdentifier;
    }

    public String getHexHash() {
        return this.hexHash;
    }

    public byte[] getHash() {
        if (this.hexHash.isEmpty()) {
            return new byte[0];
        }
        return HashUtil.hexStringToByteArray(this.hexHash);
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode = 43 * hashCode + (this.contentIdentifier != null ? this.contentIdentifier.hashCode() : 0);
        hashCode = 43 * hashCode + (this.hexHash != null ? this.hexHash.hashCode() : 0);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentReference other = (ContentReference)obj;
        if (!(this.contentIdentifier == other.contentIdentifier || this.contentIdentifier != null && this.contentIdentifier.equals(other.contentIdentifier))) {
            return false;
        }
        return this.hexHash == other.hexHash || this.hexHash != null && this.hexHash.equals(other.hexHash);
    }

    public String toString() {
        return "ContentReference{contentIdentifier=" + this.contentIdentifier + ", hexHash=" + this.hexHash + '}';
    }
}

