/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.lock;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.ClusteringApiMessages;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.lock.LocalLockHandler;
import org.jboss.as.clustering.lock.TimeoutException;
import org.jboss.as.clustering.lock.YieldingGloballyExclusiveClusterLockSupport;

public class SharedLocalYieldingClusterLockManager {
    ClusterNode localNode;
    ConcurrentMap<Serializable, LocalLock> localLocks = new ConcurrentHashMap<Serializable, LocalLock>();
    private final YieldingGloballyExclusiveClusterLockSupport clusterSupport;

    public SharedLocalYieldingClusterLockManager(String serviceHAName, GroupRpcDispatcher rpcDispatcher, GroupMembershipNotifier membershipNotifier) {
        ClusterHandler handler = new ClusterHandler();
        this.clusterSupport = new YieldingGloballyExclusiveClusterLockSupport(serviceHAName, rpcDispatcher, membershipNotifier, handler);
    }

    public LockResult lock(Serializable lockName, long timeout) throws TimeoutException, InterruptedException {
        return this.lock(lockName, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(Serializable lockName, long timeout, boolean newLock) throws TimeoutException, InterruptedException {
        LockState lockState;
        LockResult result = null;
        LocalLock localLock = this.getLocalLock(lockName, false);
        if (localLock == null) {
            localLock = this.getLocalLock(lockName, true);
            if (newLock) {
                lockState = localLock.lockForLocalNode();
                LockResult lockResult = result = lockState.localLockCount == 1 ? LockResult.NEW_LOCK : LockResult.ALREADY_HELD;
            }
        }
        if (result == null) {
            boolean decrement;
            lockState = localLock.registerForLocalLock();
            try {
                long remaining = timeout;
                do {
                    if (this.localNode == lockState.lockHolder) {
                        result = LockResult.ALREADY_HELD;
                        if (!localLock.removable || localLock == this.getLocalLock(lockName, false)) continue;
                        result = this.lock(lockName, remaining, newLock);
                        continue;
                    }
                    if (lockState.invalid) {
                        result = this.lock(lockName, remaining, newLock);
                        continue;
                    }
                    if (lockState.localLockCount == 1) {
                        if (!this.clusterSupport.lock(lockName, remaining)) continue;
                        result = LockResult.ACQUIRED_FROM_CLUSTER;
                        continue;
                    }
                    long start = System.currentTimeMillis();
                    LocalLock localLock2 = localLock;
                    synchronized (localLock2) {
                        lockState = localLock.lockState.get();
                        if (lockState.lockHolder != this.localNode) {
                            localLock.wait(remaining);
                        }
                    }
                    lockState = localLock.lockState.get();
                    remaining = timeout - (System.currentTimeMillis() - start);
                } while (result == null && remaining > 0L);
                if (result == null) {
                    SharedLocalYieldingClusterLockManager.throwTimeoutException(lockName, lockState);
                }
                decrement = result != LockResult.ALREADY_HELD;
            }
            catch (Throwable throwable) {
                boolean decrement2 = result != LockResult.ALREADY_HELD;
                boolean updated = false;
                while (this.localLocks.get(lockName) == localLock && !updated) {
                    LockState currentState = localLock.lockState.get();
                    LockState unregistered = currentState.unregister(decrement2);
                    updated = localLock.lockState.compareAndSet(currentState, unregistered);
                }
                throw throwable;
            }
            boolean updated = false;
            while (this.localLocks.get(lockName) == localLock && !updated) {
                LockState currentState = localLock.lockState.get();
                LockState unregistered = currentState.unregister(decrement);
                updated = localLock.lockState.compareAndSet(currentState, unregistered);
            }
        }
        return result;
    }

    public void unlock(Serializable lockName, boolean remove) {
        LocalLock lock;
        if (remove && (lock = this.getLocalLock(lockName, false)) != null) {
            lock.removable = true;
        }
        this.clusterSupport.unlock(lockName);
        lock = this.getLocalLock(lockName, false);
        if (lock != null && lock.removable && lock.lockState.get().lockHolder == null) {
            this.localLocks.remove(lockName, lock);
        }
    }

    public void start() throws Exception {
        this.clusterSupport.start();
        if (this.localNode == null) {
            throw ClusteringApiMessages.MESSAGES.nullVar("localNode");
        }
    }

    public void stop() throws Exception {
        this.clusterSupport.stop();
    }

    LocalLock getLocalLock(Serializable categoryName, boolean create) {
        LocalLock existing;
        LocalLock category = (LocalLock)this.localLocks.get(categoryName);
        if (category == null && create && (existing = this.localLocks.putIfAbsent(categoryName, category = new LocalLock())) != null) {
            category = existing;
        }
        return category;
    }

    private static void throwTimeoutException(Serializable lockName, LockState lockState) throws TimeoutException {
        TimeoutException te = lockState.lockHolder == null ? new TimeoutException(ClusteringApiMessages.MESSAGES.cannotAcquireLock(lockName)) : new TimeoutException(lockState.lockHolder);
        throw te;
    }

    class ClusterHandler
    implements LocalLockHandler {
        ClusterHandler() {
        }

        @Override
        public ClusterNode getLocalNode(ClusterNode localNode) {
            return SharedLocalYieldingClusterLockManager.this.localNode;
        }

        @Override
        public void setLocalNode(ClusterNode localNode) {
            SharedLocalYieldingClusterLockManager.this.localNode = localNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockFromCluster(Serializable lockName, ClusterNode caller, long timeout) throws TimeoutException, InterruptedException {
            LocalLock lock = SharedLocalYieldingClusterLockManager.this.getLocalLock(lockName, true);
            if (SharedLocalYieldingClusterLockManager.this.localNode.equals(caller)) {
                LockState lockState = lock.lockForLocalNode();
                if (lockState.latestRegistrant != Thread.currentThread()) {
                    LocalLock localLock = lock;
                    synchronized (localLock) {
                        lock.notifyAll();
                    }
                }
            } else {
                LockState currentState = lock.lockForRemoteNode(caller, timeout);
                SharedLocalYieldingClusterLockManager.this.localLocks.remove(lockName, lock);
                LockState invalidated = null;
                while (!lock.lockState.compareAndSet(currentState, invalidated = currentState.invalidate())) {
                    currentState = lock.lockState.get();
                }
                if (invalidated.latestRegistrant != null) {
                    LocalLock localLock = lock;
                    synchronized (localLock) {
                        lock.notifyAll();
                    }
                }
            }
        }

        @Override
        public ClusterNode getLockHolder(Serializable lockName) {
            LocalLock lock = SharedLocalYieldingClusterLockManager.this.getLocalLock(lockName, false);
            return lock == null ? null : lock.lockState.get().lockHolder;
        }

        @Override
        public void unlockFromCluster(Serializable lockName, ClusterNode caller) {
            LocalLock lock = SharedLocalYieldingClusterLockManager.this.getLocalLock(lockName, false);
            if (lock != null) {
                lock.unlock(caller);
            }
        }
    }

    private static class LockState {
        static final LockState AVAILABLE = new LockState(0, null, null, null, false);
        final int localLockCount;
        final ClusterNode lockHolder;
        private final ClusterNode lastHolder;
        final Thread latestRegistrant;
        final boolean invalid;

        private LockState(int localLockCount, ClusterNode lockHolder, ClusterNode lastHolder, Thread latestRegistrant, boolean invalid) {
            this.localLockCount = localLockCount;
            this.lockHolder = lockHolder;
            this.lastHolder = lastHolder;
            this.latestRegistrant = latestRegistrant;
            this.invalid = invalid;
        }

        LockState register(ClusterNode registrant) {
            ClusterNode newHolder = this.lockHolder == null && this.lastHolder == registrant ? registrant : this.lockHolder;
            ClusterNode newLast = newHolder == null ? this.lastHolder : null;
            return new LockState(this.localLockCount + 1, newHolder, newLast, Thread.currentThread(), this.invalid);
        }

        LockState unregister(boolean decrement) {
            Thread registrant = this.latestRegistrant == Thread.currentThread() ? null : this.latestRegistrant;
            int newCount = decrement ? this.localLockCount - 1 : this.localLockCount;
            return new LockState(newCount, this.lockHolder, this.lastHolder, registrant, this.invalid);
        }

        LockState takeLocal(ClusterNode owner) {
            Thread registrant = this.latestRegistrant == Thread.currentThread() ? null : this.latestRegistrant;
            return new LockState(this.localLockCount + 1, owner, null, registrant, this.invalid);
        }

        LockState releaseLock() {
            return this.localLockCount == 1 ? new LockState(0, null, this.lockHolder, this.latestRegistrant, this.invalid) : new LockState(this.localLockCount - 1, this.lockHolder, this.lastHolder, this.latestRegistrant, this.invalid);
        }

        LockState takeRemote(ClusterNode owner) {
            return new LockState(this.localLockCount, owner, null, this.latestRegistrant, this.invalid);
        }

        LockState invalidate() {
            return new LockState(this.localLockCount, this.lockHolder, null, this.latestRegistrant, true);
        }
    }

    class LocalLock {
        volatile boolean removable;
        private final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
        final AtomicReference<LockState> lockState = new AtomicReference<LockState>(LockState.AVAILABLE);

        LocalLock() {
        }

        LockState lockForLocalNode() {
            LockState current;
            LockState lockedState = null;
            while (!this.lockState.compareAndSet(current = this.lockState.get(), lockedState = current.takeLocal(SharedLocalYieldingClusterLockManager.this.localNode))) {
            }
            return lockedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockState lockForRemoteNode(ClusterNode caller, long timeout) throws TimeoutException {
            LockState lockedState = null;
            long deadline = System.currentTimeMillis() + timeout;
            boolean wasInterrupted = false;
            Thread currentThread = Thread.currentThread();
            this.waiters.add(currentThread);
            try {
                LockState currentState = this.lockState.get();
                lockedState = currentState.takeRemote(caller);
                while (this.waiters.peek() != currentThread || currentState.lockHolder == SharedLocalYieldingClusterLockManager.this.localNode || !this.lockState.compareAndSet(currentState, lockedState)) {
                    LockSupport.parkUntil(deadline);
                    if (Thread.interrupted()) {
                        wasInterrupted = true;
                    }
                    currentState = this.lockState.get();
                    lockedState = currentState.takeRemote(caller);
                    if (System.currentTimeMillis() < deadline) continue;
                    if (this.waiters.peek() == currentThread && currentState.lockHolder != SharedLocalYieldingClusterLockManager.this.localNode && this.lockState.compareAndSet(currentState, lockedState)) break;
                    throw new TimeoutException(SharedLocalYieldingClusterLockManager.this.localNode);
                }
            }
            finally {
                this.waiters.remove();
                if (wasInterrupted) {
                    currentThread.interrupt();
                }
            }
            return lockedState;
        }

        void unlock(ClusterNode caller) {
            LockState current = this.lockState.get();
            if (caller.equals(current.lockHolder)) {
                LockState newState = null;
                if (SharedLocalYieldingClusterLockManager.this.localNode == current.lockHolder) {
                    while (!this.lockState.compareAndSet(current, newState = current.releaseLock())) {
                        current = this.lockState.get();
                    }
                } else {
                    throw ClusteringApiMessages.MESSAGES.receivedUnlockForRemoteNode(caller);
                }
                if (newState.lockHolder == null) {
                    LockSupport.unpark(this.waiters.peek());
                }
            }
        }

        LockState registerForLocalLock() {
            LockState current = this.lockState.get();
            LockState newState = null;
            while (!this.lockState.compareAndSet(current, newState = current.register(SharedLocalYieldingClusterLockManager.this.localNode))) {
                current = this.lockState.get();
            }
            return newState;
        }
    }

    public static enum LockResult {
        ACQUIRED_FROM_CLUSTER,
        ALREADY_HELD,
        NEW_LOCK;

    }
}

