/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.HeuristicInformation;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.HeuristicStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.LogRecordWrapperMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ParticipantStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;

@Deprecated
public class LogRecordWrapper
extends OSEntryBean
implements LogRecordWrapperMBean {
    protected ActionBean parent;
    protected AbstractRecord rec;
    protected boolean activated;
    protected ParticipantStatus listType;

    public LogRecordWrapper(Uid uid) {
        super(null);
        this._uidWrapper.setName("jboss.jta:type=ObjectStore,itype=uninitialised,puid=" + uid.fileStringForm());
    }

    public LogRecordWrapper(ActionBean parent, AbstractRecord rec, ParticipantStatus listType, UidWrapper wrapper) {
        super(wrapper);
        this.init(parent, rec, listType);
    }

    public LogRecordWrapper(ActionBean parent, AbstractRecord rec, ParticipantStatus listType) {
        this(parent, rec, listType, LogRecordWrapper.makeWrapper(parent, rec, LogRecordWrapper.class.getName()));
    }

    private static UidWrapper makeWrapper(ActionBean parent, AbstractRecord rec, String beanType) {
        UidWrapper w = new UidWrapper(parent._uidWrapper.getBrowser(), beanType, rec.type(), rec.getClass().getName(), rec.order(), false);
        w.setName(parent.getName() + ",puid=" + rec.order().fileStringForm());
        return w;
    }

    public void init(ActionBean parent, AbstractRecord rec, ParticipantStatus listType) {
        this.parent = parent;
        this.rec = rec;
        this.listType = listType;
        this._uidWrapper.setName(parent.getName() + ",puid=" + rec.order().fileStringForm());
    }

    @Override
    public boolean isParticipant() {
        return true;
    }

    @Override
    public String getStatus() {
        String type;
        if (this.isHeuristic() && !(type = this.getHeuristicStatus()).equals(HeuristicStatus.UNKNOWN.name())) {
            return type;
        }
        return this.listType.toString();
    }

    @Override
    public void setStatus(String newState) {
        this.doSetStatus(newState);
    }

    @Override
    public String clearHeuristic() {
        return this.doSetStatus("PREPARED");
    }

    public String doSetStatus(String newState) {
        try {
            return this.setStatus(Enum.valueOf(ParticipantStatus.class, newState.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder("Valid status values are: ");
            for (ParticipantStatus lt : ParticipantStatus.values()) {
                sb.append(lt.name()).append(", ");
            }
            sb.append(" and only HEURISTIC and PREPARED will persist after JVM restart.");
            return sb.toString();
        }
    }

    public String setStatus(ParticipantStatus newState) {
        HeuristicStatus heuristicStatus;
        if (this.getListType().equals((Object)newState)) {
            return "participant is prepared for recovery";
        }
        if (newState.equals((Object)ParticipantStatus.PREPARED) && this.getListType().equals((Object)ParticipantStatus.HEURISTIC) && ((heuristicStatus = HeuristicStatus.valueOf(this.getHeuristicStatus())).equals((Object)HeuristicStatus.HEURISTIC_COMMIT) || heuristicStatus.equals((Object)HeuristicStatus.HEURISTIC_ROLLBACK))) {
            return "participant has already committed or rolled back";
        }
        if (this.parent != null && this.parent.setStatus(this, newState)) {
            this.listType = newState;
            if (newState == ParticipantStatus.PREPARED) {
                return "participant recovery will be attempted during the next recovery pass";
            }
            return "participant status change was successful";
        }
        return "participant status change failed";
    }

    @Override
    public String getType() {
        return this.rec == null ? "uninitialised" : this.rec.type();
    }

    public AbstractRecord getRecord() {
        return this.rec;
    }

    public ParticipantStatus getListType() {
        return this.listType;
    }

    @Override
    public boolean activate() {
        if (!this.activated && this.rec != null) {
            try {
                this.activated = this.rec.activate();
            }
            catch (Exception e) {
                this.activated = false;
                tsLogger.logger.warn((Object)("Activate of " + this.rec + " failed: " + e.getMessage()));
            }
        }
        return this.activated;
    }

    @Override
    public StringBuilder toString(String prefix, StringBuilder sb) {
        prefix = prefix + "\t";
        if (this.parent != null && this.rec != null) {
            sb.append('\n').append(prefix).append(this.parent.getUid(this.rec));
            sb.append('\n').append(prefix).append(this.listType.toString());
            sb.append('\n').append(prefix).append(this.rec.type());
            sb.append('\n').append(prefix).append(this.parent.getCreationTime());
            sb.append('\n').append(prefix).append(this.parent.getAgeInSeconds());
        } else {
            sb.append('\n').append(prefix).append(this._uidWrapper.getName());
        }
        return sb;
    }

    public String callMethod(Object object, String mName) {
        try {
            return (String)object.getClass().getMethod(mName, new Class[0]).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return "Not supported";
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    public boolean isHeuristic() {
        return this.listType.equals((Object)ParticipantStatus.HEURISTIC);
    }

    @Override
    public String getHeuristicStatus() {
        HeuristicStatus hs;
        Object heuristicInformation = this.rec.value();
        if (heuristicInformation != null && heuristicInformation instanceof HeuristicInformation) {
            HeuristicInformation hi = (HeuristicInformation)heuristicInformation;
            hs = HeuristicStatus.intToStatus(hi.getHeuristicType());
        } else {
            hs = HeuristicStatus.UNKNOWN;
        }
        return hs.name();
    }

    @Override
    public String remove(boolean reprobe) {
        if (this.parent != null) {
            this.parent.remove(this);
            this._uidWrapper.unregister();
            if (reprobe) {
                this._uidWrapper.probe();
            }
        }
        return "Record successfully removed";
    }

    @Override
    public String remove() {
        return this.remove(true);
    }
}

