/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class LdapConnectionPropertyResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"property");
    public static final SimpleAttributeDefinition VALUE = new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).build();
    static final ResourceDefinition INSTANCE = new LdapConnectionPropertyResourceDefinition();

    private LdapConnectionPropertyResourceDefinition() {
        super(RESOURCE_PATH, ControllerResolver.getDeprecatedResolver((String)"core.management.ldap-connection", (String[])new String[]{"core.management.ldap-connection.property"}), (OperationStepHandler)new PropertyAddHandler(), (OperationStepHandler)new PropertyRemoveHandler(), OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)VALUE, null, (OperationStepHandler)new ValueWriteHandler());
    }

    private static class ValueWriteHandler
    extends AbstractWriteAttributeHandler<Void> {
        private ValueWriteHandler() {
            super(new AttributeDefinition[]{VALUE});
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            new PropertyManipulator(context, operation).setValue(resolvedValue.asString());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            new PropertyManipulator(context, operation).setValue(valueToRestore.asString());
        }
    }

    private static class PropertyRemoveHandler
    extends AbstractRemoveStepHandler {
        private PropertyRemoveHandler() {
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            new PropertyManipulator(context, operation).remove();
        }
    }

    private static class PropertyAddHandler
    extends AbstractAddStepHandler {
        private PropertyAddHandler() {
            super(new AttributeDefinition[]{VALUE});
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            new PropertyManipulator(context, operation).setValue(VALUE.resolveModelAttribute(context, model).asString());
        }
    }

    private static class PropertyManipulator {
        private final LdapConnectionManagerService service;
        private final boolean isBooting;
        private final String propertyName;

        private PropertyManipulator(OperationContext context, ModelNode operation) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            LdapConnectionManagerService service = null;
            String propertyName = null;
            for (PathElement current : address) {
                String currentKey = current.getKey();
                if (currentKey.equals("ldap-connection")) {
                    String connectionName = current.getValue();
                    ServiceName svcName = LdapConnectionManagerService.ServiceUtil.createServiceName(connectionName);
                    ServiceRegistry registry = context.getServiceRegistry(true);
                    ServiceController controller = registry.getService(svcName);
                    service = (LdapConnectionManagerService)LdapConnectionManagerService.class.cast(controller.getValue());
                    continue;
                }
                if (!currentKey.equals("property")) continue;
                propertyName = current.getValue();
            }
            this.service = service;
            this.propertyName = propertyName;
            this.isBooting = context.isBooting();
        }

        private void setValue(String value) {
            if (this.isBooting) {
                this.service.setPropertyImmediate(this.propertyName, value);
            } else {
                this.service.setProperty(this.propertyName, value);
            }
        }

        private void remove() {
            this.service.removeProperty(this.propertyName);
        }
    }
}

