/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.lucene.facet.search.Heap;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.results.FacetResultNode;
import org.apache.lucene.util.PriorityQueue;

public class ResultSortUtils {
    public static Heap<FacetResultNode> createSuitableHeap(FacetRequest facetRequest) {
        boolean accending;
        int nresults = facetRequest.getNumResults();
        boolean bl = accending = facetRequest.getSortOrder() == FacetRequest.SortOrder.ASCENDING;
        if (nresults == Integer.MAX_VALUE) {
            return new AllValueHeap(accending);
        }
        if (accending) {
            switch (facetRequest.getSortBy()) {
                case VALUE: {
                    return new MaxValueHeap(nresults);
                }
                case ORDINAL: {
                    return new MaxOrdinalHeap(nresults);
                }
            }
        } else {
            switch (facetRequest.getSortBy()) {
                case VALUE: {
                    return new MinValueHeap(nresults);
                }
                case ORDINAL: {
                    return new MinOrdinalHeap(nresults);
                }
            }
        }
        throw new IllegalArgumentException("none supported facet request: " + facetRequest);
    }

    private static class AllValueHeap
    implements Heap<FacetResultNode> {
        private ArrayList<FacetResultNode> resultNodes = new ArrayList();
        final boolean accending;
        private boolean isReady = false;

        public AllValueHeap(boolean accending) {
            this.accending = accending;
        }

        @Override
        public FacetResultNode insertWithOverflow(FacetResultNode node) {
            this.resultNodes.add(node);
            return null;
        }

        @Override
        public FacetResultNode pop() {
            if (!this.isReady) {
                Collections.sort(this.resultNodes, new Comparator<FacetResultNode>(){

                    @Override
                    public int compare(FacetResultNode o1, FacetResultNode o2) {
                        int value = Double.compare(o1.getValue(), o2.getValue());
                        if (value == 0) {
                            value = o1.getOrdinal() - o2.getOrdinal();
                        }
                        if (AllValueHeap.this.accending) {
                            value = -value;
                        }
                        return value;
                    }
                });
                this.isReady = true;
            }
            return this.resultNodes.remove(0);
        }

        @Override
        public int size() {
            return this.resultNodes.size();
        }

        @Override
        public FacetResultNode top() {
            if (this.resultNodes.size() > 0) {
                return this.resultNodes.get(0);
            }
            return null;
        }

        @Override
        public FacetResultNode add(FacetResultNode frn) {
            this.resultNodes.add(frn);
            return null;
        }

        @Override
        public void clear() {
            this.resultNodes.clear();
        }
    }

    private static class MaxOrdinalHeap
    extends PriorityQueue<FacetResultNode>
    implements Heap<FacetResultNode> {
        public MaxOrdinalHeap(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(FacetResultNode arg0, FacetResultNode arg1) {
            return arg0.getOrdinal() > arg1.getOrdinal();
        }
    }

    private static class MinOrdinalHeap
    extends PriorityQueue<FacetResultNode>
    implements Heap<FacetResultNode> {
        public MinOrdinalHeap(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(FacetResultNode arg0, FacetResultNode arg1) {
            return arg0.getOrdinal() < arg1.getOrdinal();
        }
    }

    private static class MaxValueHeap
    extends PriorityQueue<FacetResultNode>
    implements Heap<FacetResultNode> {
        public MaxValueHeap(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(FacetResultNode arg0, FacetResultNode arg1) {
            double value1;
            double value0 = arg0.getValue();
            int valueCompare = Double.compare(value0, value1 = arg1.getValue());
            if (valueCompare == 0) {
                return arg0.getOrdinal() > arg1.getOrdinal();
            }
            return valueCompare > 0;
        }
    }

    private static class MinValueHeap
    extends PriorityQueue<FacetResultNode>
    implements Heap<FacetResultNode> {
        public MinValueHeap(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(FacetResultNode arg0, FacetResultNode arg1) {
            double value1;
            double value0 = arg0.getValue();
            int valueCompare = Double.compare(value0, value1 = arg1.getValue());
            if (valueCompare == 0) {
                return arg0.getOrdinal() < arg1.getOrdinal();
            }
            return valueCompare < 0;
        }
    }
}

