/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.multiCL;

import java.util.List;
import java.util.Random;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.example.simple.SimpleUtils;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.index.params.PerDimensionIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class MultiCLIndexer {
    public static int NUM_DOCS = 100;
    public static int NUM_FACETS_PER_DOC = 10;
    public static int TITLE_LENGTH = 5;
    public static int TEXT_LENGTH = 100;
    static String words = "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem Ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iurereprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur vel illum qui dolorem eum fugiat quo voluptas nulla pariatur";
    public static PerDimensionIndexingParams MULTI_IPARAMS = new PerDimensionIndexingParams();

    public static void index(Directory indexDir, Directory taxoDir) throws Exception {
        Random random = new Random(2003L);
        String[] docTitles = new String[NUM_DOCS];
        String[] docTexts = new String[NUM_DOCS];
        CategoryPath[][] cPaths = new CategoryPath[NUM_DOCS][NUM_FACETS_PER_DOC];
        String[] tokens = words.split(" ");
        for (int docNum = 0; docNum < NUM_DOCS; ++docNum) {
            int j;
            String title = "";
            String text = "";
            for (j = 0; j < TITLE_LENGTH; ++j) {
                title = title + tokens[random.nextInt(tokens.length)] + " ";
            }
            docTitles[docNum] = title;
            for (j = 0; j < TEXT_LENGTH; ++j) {
                text = text + tokens[random.nextInt(tokens.length)] + " ";
            }
            docTexts[docNum] = text;
            for (int facetNum = 0; facetNum < NUM_FACETS_PER_DOC; ++facetNum) {
                cPaths[docNum][facetNum] = new CategoryPath(Integer.toString(random.nextInt(7)), Integer.toString(random.nextInt(10)));
            }
        }
        MultiCLIndexer.index(indexDir, taxoDir, (FacetIndexingParams)MULTI_IPARAMS, docTitles, docTexts, cPaths);
    }

    public static void index(Directory indexDir, Directory taxoDir, FacetIndexingParams iParams, String[] docTitles, String[] docTexts, CategoryPath[][] cPaths) throws Exception {
        IndexWriter iw = new IndexWriter(indexDir, new IndexWriterConfig(ExampleUtils.EXAMPLE_VER, SimpleUtils.analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        DirectoryTaxonomyWriter taxo = new DirectoryTaxonomyWriter(taxoDir, IndexWriterConfig.OpenMode.CREATE);
        MultiCLIndexer.index(iw, taxo, iParams, docTitles, docTexts, cPaths);
    }

    public static void index(IndexWriter iw, DirectoryTaxonomyWriter taxo, FacetIndexingParams iParams, String[] docTitles, String[] docTexts, CategoryPath[][] cPaths) throws Exception {
        int nDocsAdded = 0;
        int nFacetsAdded = 0;
        for (int docNum = 0; docNum < SimpleUtils.docTexts.length; ++docNum) {
            List<CategoryPath> facetList = SimpleUtils.categoryPathArrayToList(cPaths[docNum]);
            CategoryDocumentBuilder categoryDocBuilder = new CategoryDocumentBuilder(taxo, iParams).setCategoryPaths(facetList);
            Document doc = new Document();
            doc.add((Fieldable)new Field("title", docTitles[docNum], Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("text", docTexts[docNum], Field.Store.NO, Field.Index.ANALYZED));
            categoryDocBuilder.build(doc);
            iw.addDocument(doc);
            ++nDocsAdded;
            nFacetsAdded += facetList.size();
        }
        taxo.commit();
        iw.commit();
        taxo.close();
        iw.close();
        ExampleUtils.log("Indexed " + nDocsAdded + " documents with overall " + nFacetsAdded + " facets.");
    }

    public static void main(String[] args) throws Exception {
        MultiCLIndexer.index((Directory)new RAMDirectory(), (Directory)new RAMDirectory());
    }

    static {
        MULTI_IPARAMS.addCategoryListParams(new CategoryPath("0"), new CategoryListParams(new Term("$Digits", "Zero")));
        MULTI_IPARAMS.addCategoryListParams(new CategoryPath("1"), new CategoryListParams(new Term("$Digits", "One")));
        MULTI_IPARAMS.addCategoryListParams(new CategoryPath("2"), new CategoryListParams(new Term("$Digits", "Two")));
        MULTI_IPARAMS.addCategoryListParams(new CategoryPath("3"), new CategoryListParams(new Term("$Digits", "Three")));
        MULTI_IPARAMS.addCategoryListParams(new CategoryPath("4"), new CategoryListParams(new Term("$Digits", "Four")));
        MULTI_IPARAMS.addCategoryListParams(new CategoryPath("5"), new CategoryListParams(new Term("$Digits", "Five")));
    }
}

