/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements.params;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.enhancements.CategoryEnhancement;
import org.apache.lucene.facet.enhancements.params.EnhancementsIndexingParams;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.PerDimensionIndexingParams;

public class DefaultEnhancementsIndexingParams
extends PerDimensionIndexingParams
implements EnhancementsIndexingParams {
    private List<CategoryEnhancement> enhancedCategories;

    public DefaultEnhancementsIndexingParams(CategoryEnhancement ... enhancements) {
        this.validateparams(enhancements);
        this.addCategoryEnhancements(enhancements);
    }

    private void validateparams(CategoryEnhancement ... enhancements) {
        if (enhancements == null || enhancements.length < 1) {
            throw new IllegalArgumentException("at least one enhancement is required");
        }
    }

    public DefaultEnhancementsIndexingParams(CategoryListParams categoryListParams, CategoryEnhancement ... enhancements) {
        super(categoryListParams);
        this.validateparams(enhancements);
        this.addCategoryEnhancements(enhancements);
    }

    @Override
    public void addCategoryEnhancements(CategoryEnhancement ... enhancements) {
        if (this.enhancedCategories == null) {
            this.enhancedCategories = new ArrayList<CategoryEnhancement>();
        }
        for (CategoryEnhancement categoryEnhancement : enhancements) {
            this.enhancedCategories.add(categoryEnhancement);
        }
    }

    @Override
    public List<CategoryEnhancement> getCategoryEnhancements() {
        if (this.enhancedCategories == null || this.enhancedCategories.isEmpty()) {
            return null;
        }
        return this.enhancedCategories;
    }

    @Override
    public List<Class<? extends CategoryProperty>> getRetainableProperties() {
        if (this.enhancedCategories == null) {
            return null;
        }
        ArrayList<Class<? extends CategoryProperty>> retainableProperties = new ArrayList<Class<? extends CategoryProperty>>();
        for (CategoryEnhancement enhancement : this.enhancedCategories) {
            if (enhancement.getRetainableProperty() == null) continue;
            retainableProperties.add(enhancement.getRetainableProperty());
        }
        if (retainableProperties.isEmpty()) {
            return null;
        }
        return retainableProperties;
    }
}

