/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.enhancements.CategoryEnhancement;
import org.apache.lucene.facet.enhancements.params.EnhancementsIndexingParams;
import org.apache.lucene.facet.index.streaming.CategoryTokenizer;
import org.apache.lucene.util.Vint8;

public class EnhancementsCategoryTokenizer
extends CategoryTokenizer {
    protected byte[] payloadBytes;
    protected List<CategoryEnhancement> enhancements;
    protected byte[][] enhancementBytes;
    private int nStart;

    public EnhancementsCategoryTokenizer(TokenStream input, EnhancementsIndexingParams indexingParams) throws IOException {
        super(input, indexingParams);
        this.payloadBytes = new byte[5 * (indexingParams.getCategoryEnhancements().size() + 1)];
        this.enhancements = indexingParams.getCategoryEnhancements();
        if (this.enhancements != null) {
            this.enhancementBytes = new byte[this.enhancements.size()][];
            this.nStart = Vint8.encode(this.enhancements.size(), this.payloadBytes, 0);
        }
    }

    @Override
    protected void setPayload() {
        this.payloadAttribute.setPayload(null);
        if (this.enhancements == null) {
            return;
        }
        int nBytes = this.nStart;
        int i = 0;
        int nEnhancementBytes = 0;
        for (CategoryEnhancement enhancement : this.enhancements) {
            this.enhancementBytes[i] = enhancement.getCategoryTokenBytes(this.categoryAttribute);
            if (this.enhancementBytes[i] == null) {
                nBytes += Vint8.encode(0, this.payloadBytes, nBytes);
            } else {
                nBytes += Vint8.encode(this.enhancementBytes[i].length, this.payloadBytes, nBytes);
                nEnhancementBytes += this.enhancementBytes[i].length;
            }
            ++i;
        }
        if (nEnhancementBytes > 0) {
            if (this.payloadBytes.length < nBytes + nEnhancementBytes) {
                byte[] temp = new byte[(nBytes + nEnhancementBytes) * 2];
                System.arraycopy(this.payloadBytes, 0, temp, 0, nBytes);
                this.payloadBytes = temp;
            }
            for (i = 0; i < this.enhancementBytes.length; ++i) {
                if (this.enhancementBytes[i] == null) continue;
                System.arraycopy(this.enhancementBytes[i], 0, this.payloadBytes, nBytes, this.enhancementBytes[i].length);
                nBytes += this.enhancementBytes[i].length;
            }
            this.payload.setData(this.payloadBytes, 0, nBytes);
            this.payloadAttribute.setPayload(this.payload);
        }
    }
}

