/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.util.StringUtils;

public class Profiler
implements Runnable {
    private static Instrumentation instrumentation;
    private static final int MAX_ELEMENTS = 1000;
    public int interval = 2;
    public int depth = 32;
    public boolean paused;
    private String[] ignoreLines = StringUtils.arraySplit("", ',', true);
    private String[] ignorePackages = StringUtils.arraySplit("java,sun,com.sun.,", ',', true);
    private String[] ignoreThreads = StringUtils.arraySplit("java.lang.Object.wait,java.lang.Thread.dumpThreads,java.lang.Thread.getThreads,java.lang.Thread.sleep,java.lang.UNIXProcess.waitForProcessExit,java.net.PlainSocketImpl.accept,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead,java.net.SocketOutputStream.socketWrite,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run", ',', true);
    private volatile boolean stop;
    private HashMap<String, Integer> counts = new HashMap();
    private HashMap<String, Integer> packages = new HashMap();
    private int minCount = 1;
    private int total;
    private Thread thread;
    private long time;

    public static void premain(String agentArgs, Instrumentation inst) {
        instrumentation = inst;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public void startCollecting() {
        this.thread = new Thread((Runnable)this, "Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    @Override
    public void run() {
        this.time = System.currentTimeMillis();
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable t) {
                // empty catch block
                break;
            }
        }
        this.time = System.currentTimeMillis() - this.time;
    }

    private void tick() {
        if (this.interval > 0) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] dump;
            Thread t = entry.getKey();
            if (t.getState() != Thread.State.RUNNABLE || (dump = entry.getValue()) == null || dump.length == 0 || Profiler.startsWithAny(dump[0].toString(), this.ignoreThreads)) continue;
            StringBuilder buff = new StringBuilder();
            String last = null;
            boolean packageCounts = false;
            int j = 0;
            for (int i = 0; i < dump.length && j < this.depth; ++i) {
                String el = dump[i].toString();
                if (el.equals(last) || Profiler.startsWithAny(el, this.ignoreLines)) continue;
                last = el;
                buff.append("at ").append(el).append(SysProperties.LINE_SEPARATOR);
                if (!packageCounts && !Profiler.startsWithAny(el, this.ignorePackages)) {
                    char c;
                    int index;
                    packageCounts = true;
                    for (index = 0; index < el.length() && !Character.isUpperCase(c = el.charAt(index)) && c != '('; ++index) {
                    }
                    if (index > 0 && el.charAt(index - 1) == '.') {
                        --index;
                    }
                    String packageName = el.substring(0, index);
                    Profiler.increment(this.packages, packageName, 0);
                }
                ++j;
            }
            if (buff.length() <= 0) continue;
            this.minCount = Profiler.increment(this.counts, buff.toString().trim(), this.minCount);
            ++this.total;
        }
    }

    private static boolean startsWithAny(String s, String[] prefixes) {
        for (String p : prefixes) {
            if (p.length() <= 0 || !s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private static int increment(HashMap<String, Integer> map, String trace, int minCount) {
        Integer oldCount = map.get(trace);
        if (oldCount == null) {
            map.put(trace, 1);
        } else {
            map.put(trace, oldCount + 1);
        }
        while (map.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> ei = map.entrySet().iterator();
            while (ei.hasNext()) {
                Map.Entry<String, Integer> e = ei.next();
                if (e.getValue() > minCount) continue;
                ei.remove();
            }
            if (map.size() <= 1000) continue;
            ++minCount;
        }
        return minCount;
    }

    public String getTop(int count) {
        this.stopCollecting();
        StringBuilder buff = new StringBuilder();
        buff.append("Profiler: top ").append(count).append(" stack trace(s) of ").append(this.time).append(" ms [build-").append(168).append("]:").append(SysProperties.LINE_SEPARATOR);
        if (this.counts.size() == 0) {
            buff.append("(none)").append(SysProperties.LINE_SEPARATOR);
        }
        Profiler.appendTop(buff, this.counts, count, this.total, false);
        buff.append("packages:").append(SysProperties.LINE_SEPARATOR);
        Profiler.appendTop(buff, this.packages, count, this.total, true);
        buff.append('.');
        return buff.toString();
    }

    private static void appendTop(StringBuilder buff, HashMap<String, Integer> map, int count, int total, boolean table) {
        int x = 0;
        int min = 0;
        while (true) {
            int highest = 0;
            Map.Entry<String, Integer> best = null;
            for (Map.Entry<String, Integer> el : map.entrySet()) {
                if (el.getValue() <= highest) continue;
                best = el;
                highest = el.getValue();
            }
            if (best == null) break;
            map.remove(best.getKey());
            if (++x >= count) {
                if (best.getValue() < min) break;
                min = best.getValue();
            }
            int c = best.getValue();
            int percent = 100 * c / Math.max(total, 1);
            if (table) {
                if (percent <= 1) continue;
                buff.append(percent).append("%: ").append(best.getKey()).append(SysProperties.LINE_SEPARATOR);
                continue;
            }
            buff.append(c).append('/').append(total).append(" (").append(percent).append("%):").append(SysProperties.LINE_SEPARATOR).append(best.getKey()).append(SysProperties.LINE_SEPARATOR);
        }
    }
}

