/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import java.util.Collections;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheSecondLevel;
import org.h2.util.CacheTQ;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SoftHashMap;

public class CacheLRU
implements Cache {
    static final String TYPE_NAME = "LRU";
    private final CacheWriter writer;
    private final boolean fifo;
    private final CacheObject head = new CacheHead();
    private final int mask;
    private CacheObject[] values;
    private int recordCount;
    private final int len;
    private int maxMemory;
    private int memory;

    CacheLRU(CacheWriter writer, int maxMemoryKb, boolean fifo) {
        this.writer = writer;
        this.fifo = fifo;
        this.setMaxMemory(maxMemoryKb);
        this.len = MathUtils.nextPowerOf2(this.maxMemory / 64);
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.clear();
    }

    public static Cache getCache(CacheWriter writer, String cacheType, int cacheSize) {
        Cache cache;
        SoftHashMap<Integer, CacheObject> secondLevel = null;
        if (cacheType.startsWith("SOFT_")) {
            secondLevel = new SoftHashMap<Integer, CacheObject>();
            cacheType = cacheType.substring("SOFT_".length());
        }
        if (TYPE_NAME.equals(cacheType)) {
            cache = new CacheLRU(writer, cacheSize, false);
        } else if ("TQ".equals(cacheType)) {
            cache = new CacheTQ(writer, cacheSize);
        } else {
            throw DbException.getInvalidValueException("CACHE_TYPE", cacheType);
        }
        if (secondLevel != null) {
            cache = new CacheSecondLevel(cache, secondLevel);
        }
        return cache;
    }

    @Override
    public void clear() {
        this.head.cacheNext = this.head.cachePrevious = this.head;
        this.values = null;
        this.values = new CacheObject[this.len];
        this.recordCount = 0;
        this.memory = this.len * 8;
    }

    @Override
    public void put(CacheObject rec) {
        int pos;
        CacheObject old;
        if (SysProperties.CHECK && (old = this.find(pos = rec.getPos())) != null) {
            DbException.throwInternalError("try to add a record twice pos:" + pos);
        }
        int index = rec.getPos() & this.mask;
        rec.cacheChained = this.values[index];
        this.values[index] = rec;
        ++this.recordCount;
        this.memory += rec.getMemory();
        this.addToFront(rec);
        this.removeOldIfRequired();
    }

    @Override
    public CacheObject update(int pos, CacheObject rec) {
        CacheObject old = this.find(pos);
        if (old == null) {
            this.put(rec);
        } else {
            if (SysProperties.CHECK && old != rec) {
                DbException.throwInternalError("old!=record pos:" + pos + " old:" + old + " new:" + rec);
            }
            if (!this.fifo) {
                this.removeFromLinkedList(rec);
                this.addToFront(rec);
            }
        }
        return old;
    }

    private void removeOldIfRequired() {
        if (this.memory >= this.maxMemory) {
            this.removeOld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOld() {
        int i = 0;
        ArrayList changed = New.arrayList();
        int mem = this.memory;
        int rc = this.recordCount;
        boolean flushed = false;
        CacheObject next = this.head.cacheNext;
        while (rc > 16 && !(changed.size() == 0 ? mem <= this.maxMemory : mem * 4 <= this.maxMemory * 3)) {
            CacheObject check = next;
            next = check.cacheNext;
            if (++i >= this.recordCount) {
                if (!flushed) {
                    this.writer.flushLog();
                    flushed = true;
                    i = 0;
                } else {
                    this.writer.getTrace().info("cannot remove records, cache size too small? records:" + this.recordCount + " memory:" + this.memory);
                    break;
                }
            }
            if (SysProperties.CHECK && check == this.head) {
                DbException.throwInternalError("try to remove head");
            }
            if (!check.canRemove()) {
                this.removeFromLinkedList(check);
                this.addToFront(check);
                continue;
            }
            --rc;
            mem -= check.getMemory();
            if (check.isChanged()) {
                changed.add(check);
                continue;
            }
            this.remove(check.getPos());
        }
        if (changed.size() > 0) {
            CacheObject rec;
            if (!flushed) {
                this.writer.flushLog();
            }
            Collections.sort(changed);
            int max = this.maxMemory;
            int size = changed.size();
            try {
                this.maxMemory = Integer.MAX_VALUE;
                for (i = 0; i < size; ++i) {
                    rec = (CacheObject)changed.get(i);
                    this.writer.writeBack(rec);
                }
            }
            finally {
                this.maxMemory = max;
            }
            for (i = 0; i < size; ++i) {
                rec = (CacheObject)changed.get(i);
                this.remove(rec.getPos());
                if (!SysProperties.CHECK || rec.cacheNext == null) continue;
                throw DbException.throwInternalError();
            }
        }
    }

    private void addToFront(CacheObject rec) {
        if (SysProperties.CHECK && rec == this.head) {
            DbException.throwInternalError("try to move head");
        }
        rec.cacheNext = this.head;
        rec.cachePrevious = this.head.cachePrevious;
        rec.cachePrevious.cacheNext = rec;
        this.head.cachePrevious = rec;
    }

    private void removeFromLinkedList(CacheObject rec) {
        if (SysProperties.CHECK && rec == this.head) {
            DbException.throwInternalError("try to remove head");
        }
        rec.cachePrevious.cacheNext = rec.cacheNext;
        rec.cacheNext.cachePrevious = rec.cachePrevious;
        rec.cacheNext = null;
        rec.cachePrevious = null;
    }

    @Override
    public boolean remove(int pos) {
        int index = pos & this.mask;
        CacheObject rec = this.values[index];
        if (rec == null) {
            return false;
        }
        if (rec.getPos() == pos) {
            this.values[index] = rec.cacheChained;
        } else {
            do {
                CacheObject last = rec;
                rec = rec.cacheChained;
                if (rec != null) continue;
                return false;
            } while (rec.getPos() != pos);
            last.cacheChained = rec.cacheChained;
        }
        --this.recordCount;
        this.memory -= rec.getMemory();
        this.removeFromLinkedList(rec);
        if (SysProperties.CHECK) {
            rec.cacheChained = null;
            CacheObject o = this.find(pos);
            if (o != null) {
                DbException.throwInternalError("not removed: " + o);
            }
        }
        return true;
    }

    @Override
    public CacheObject find(int pos) {
        CacheObject rec = this.values[pos & this.mask];
        while (rec != null && rec.getPos() != pos) {
            rec = rec.cacheChained;
        }
        return rec;
    }

    @Override
    public CacheObject get(int pos) {
        CacheObject rec = this.find(pos);
        if (rec != null && !this.fifo) {
            this.removeFromLinkedList(rec);
            this.addToFront(rec);
        }
        return rec;
    }

    @Override
    public ArrayList<CacheObject> getAllChanged() {
        ArrayList<CacheObject> list = New.arrayList();
        CacheObject rec = this.head.cacheNext;
        while (rec != this.head) {
            if (rec.isChanged()) {
                list.add(rec);
            }
            rec = rec.cacheNext;
        }
        return list;
    }

    @Override
    public void setMaxMemory(int maxKb) {
        int newSize = MathUtils.convertLongToInt((long)maxKb * 1024L / 4L);
        this.maxMemory = newSize < 0 ? 0 : newSize;
        this.removeOldIfRequired();
    }

    @Override
    public int getMaxMemory() {
        return (int)((long)this.maxMemory * 4L / 1024L);
    }

    @Override
    public int getMemory() {
        return (int)((long)this.memory * 4L / 1024L);
    }
}

