/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.h2.message.DbException;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileChannelOutputStream;
import org.h2.store.fs.FileMem;
import org.h2.store.fs.FileMemData;
import org.h2.store.fs.FilePath;
import org.h2.util.New;

public class FilePathMem
extends FilePath {
    private static final TreeMap<String, FileMemData> MEMORY_FILES = new TreeMap();

    @Override
    public FilePathMem getPath(String path) {
        FilePathMem p = new FilePathMem();
        p.name = FilePathMem.getCanonicalPath(path);
        return p;
    }

    @Override
    public long size() {
        return this.getMemoryFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(FilePath newName) {
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileMemData f = this.getMemoryFile();
            f.setName(newName.name);
            MEMORY_FILES.remove(this.name);
            MEMORY_FILES.put(newName.name, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createFile() {
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            if (this.exists()) {
                return false;
            }
            this.getMemoryFile();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            return MEMORY_FILES.get(this.name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        if (this.isRoot()) {
            return;
        }
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            MEMORY_FILES.remove(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilePath> newDirectoryStream() {
        ArrayList<FilePath> list = New.arrayList();
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            for (String n : MEMORY_FILES.tailMap(this.name).keySet()) {
                if (!n.startsWith(this.name)) break;
                list.add(this.getPath(n));
            }
            return list;
        }
    }

    @Override
    public boolean setReadOnly() {
        return this.getMemoryFile().setReadOnly();
    }

    @Override
    public boolean canWrite() {
        return this.getMemoryFile().canWrite();
    }

    @Override
    public FilePathMem getParent() {
        int idx = this.name.lastIndexOf(47);
        return idx < 0 ? null : this.getPath(this.name.substring(0, idx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory() {
        if (this.isRoot()) {
            return true;
        }
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            return MEMORY_FILES.get(this.name) == null;
        }
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public FilePathMem toRealPath() {
        return this;
    }

    @Override
    public long lastModified() {
        return this.getMemoryFile().getLastModified();
    }

    @Override
    public void createDirectory() {
        if (this.exists() && this.isDirectory()) {
            throw DbException.get(90062, this.name + " (a file with this name already exists)");
        }
    }

    @Override
    public OutputStream newOutputStream(boolean append) {
        try {
            FileMemData obj = this.getMemoryFile();
            FileMem m = new FileMem(obj, false);
            return new FileChannelOutputStream(m, append);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
    }

    @Override
    public InputStream newInputStream() {
        FileMemData obj = this.getMemoryFile();
        FileMem m = new FileMem(obj, true);
        return new FileChannelInputStream(m);
    }

    @Override
    public FileChannel open(String mode) {
        FileMemData obj = this.getMemoryFile();
        return new FileMem(obj, "r".equals(mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMemData getMemoryFile() {
        TreeMap<String, FileMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileMemData m = MEMORY_FILES.get(this.name);
            if (m == null) {
                m = new FileMemData(this.name, this.compressed());
                MEMORY_FILES.put(this.name, m);
            }
            return m;
        }
    }

    private boolean isRoot() {
        return this.name.equals(this.getScheme());
    }

    private static String getCanonicalPath(String fileName) {
        fileName = fileName.replace('\\', '/');
        int idx = fileName.indexOf(58) + 1;
        if (fileName.length() > idx && fileName.charAt(idx) != '/') {
            fileName = fileName.substring(0, idx) + "/" + fileName.substring(idx);
        }
        return fileName;
    }

    @Override
    public String getScheme() {
        return "memFS";
    }

    boolean compressed() {
        return false;
    }
}

