/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.server.web.DbSchema;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class DbContents {
    DbSchema[] schemas;
    DbSchema defaultSchema;
    boolean isOracle;
    boolean isH2;
    boolean isH2ModeMySQL;
    boolean isPostgreSQL;
    boolean isMySQL;
    boolean isDerby;
    boolean isFirebird;
    boolean isSQLite;
    boolean isMSSQLServer;
    boolean storedUpperCaseIdentifiers;

    static int findColumn(ResultSet rs, String columnName, int defaultColumnIndex) {
        try {
            return rs.findColumn(columnName);
        }
        catch (SQLException e) {
            return defaultColumnIndex;
        }
    }

    synchronized void readContents(DatabaseMetaData meta) throws SQLException {
        String prod = StringUtils.toLowerEnglish(meta.getDatabaseProductName());
        this.isSQLite = prod.indexOf("sqlite") >= 0;
        String url = meta.getURL();
        if (url != null) {
            this.isH2 = url.startsWith("jdbc:h2:");
            if (this.isH2) {
                Statement stat = meta.getConnection().createStatement();
                ResultSet rs = stat.executeQuery("SELECT UPPER(VALUE) FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME='MODE'");
                rs.next();
                if ("MYSQL".equals(rs.getString(1))) {
                    this.isH2ModeMySQL = true;
                }
                rs.close();
                stat.close();
            }
            this.isOracle = url.startsWith("jdbc:oracle:");
            this.isPostgreSQL = url.startsWith("jdbc:postgresql:");
            this.isMySQL = url.startsWith("jdbc:mysql:");
            this.isDerby = url.startsWith("jdbc:derby:");
            this.isFirebird = url.startsWith("jdbc:firebirdsql:");
            this.isMSSQLServer = url.startsWith("jdbc:sqlserver:");
        }
        this.storedUpperCaseIdentifiers = meta.storesUpperCaseIdentifiers();
        String defaultSchemaName = this.getDefaultSchemaName(meta);
        String[] schemaNames = this.getSchemaNames(meta);
        this.schemas = new DbSchema[schemaNames.length];
        for (int i = 0; i < schemaNames.length; ++i) {
            String schemaName = schemaNames[i];
            boolean isDefault = defaultSchemaName == null || defaultSchemaName.equals(schemaName);
            DbSchema schema = new DbSchema(this, schemaName, isDefault);
            if (schema.isDefault) {
                this.defaultSchema = schema;
            }
            this.schemas[i] = schema;
            String[] tableTypes = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM"};
            schema.readTables(meta, tableTypes);
        }
        if (this.defaultSchema == null) {
            String best = null;
            for (DbSchema schema : this.schemas) {
                if ("dbo".equals(schema.name)) {
                    this.defaultSchema = schema;
                    break;
                }
                if (this.defaultSchema != null && best != null && schema.name.length() >= best.length()) continue;
                best = schema.name;
                this.defaultSchema = schema;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData meta) throws SQLException {
        if (this.isMySQL || this.isSQLite) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet rs = meta.getSchemas();
        ArrayList<String> schemaList = New.arrayList();
        while (rs.next()) {
            String schema = rs.getString(DbContents.findColumn(rs, "TABLE_SCHEM", 1));
            if (this.isOracle) {
                for (String ignore : new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "FLOWS_020100", "FLOWS_FILES", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"}) {
                    if (!ignore.equals(schema)) continue;
                    schema = null;
                    break;
                }
            } else if (this.isMSSQLServer) {
                for (String ignore : new String[]{"sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin"}) {
                    if (!ignore.equals(schema)) continue;
                    schema = null;
                    break;
                }
            }
            if (schema == null) continue;
            schemaList.add(schema);
        }
        rs.close();
        String[] list = new String[schemaList.size()];
        schemaList.toArray(list);
        return list;
    }

    private String getDefaultSchemaName(DatabaseMetaData meta) {
        String defaultSchemaName = "";
        try {
            if (this.isOracle) {
                return meta.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(meta.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet rs = meta.getSchemas();
            int index = rs.findColumn("IS_DEFAULT");
            while (rs.next()) {
                if (!rs.getBoolean(index)) continue;
                defaultSchemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return defaultSchemaName;
    }

    String quoteIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (this.isH2 && !this.isH2ModeMySQL) {
            return Parser.quoteIdentifier(identifier);
        }
        return StringUtils.toUpperEnglish(identifier);
    }
}

