/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table newTable, int id, String name, IndexColumn[] newIndexColumns, IndexType newIndexType) {
        this.initSchemaObjectBase(newTable.getSchema(), id, name, "index");
        this.indexType = newIndexType;
        this.table = newTable;
        if (newIndexColumns != null) {
            this.indexColumns = newIndexColumns;
            this.columns = new Column[newIndexColumns.length];
            int len = this.columns.length;
            this.columnIds = new int[len];
            for (int i = 0; i < len; ++i) {
                Column col;
                this.columns[i] = col = newIndexColumns[i].column;
                this.columnIds[i] = col.getColumnId();
            }
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    DbException getDuplicateKeyException() {
        String sql = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        DbException e = DbException.get(23505, sql);
        e.setSource(this);
        return e;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession(), first, last);
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        throw DbException.throwInternalError();
    }

    protected long getCostRangeIndex(int[] masks, long rowCount) {
        long cost = rowCount += 1000L;
        long rows = rowCount;
        int totalSelectivity = 0;
        if (masks == null) {
            return cost;
        }
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            long distinctRows;
            Column column = this.columns[i];
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) {
                if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                    cost = 3L;
                    break;
                }
                distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                if (distinctRows <= 0L) {
                    distinctRows = 1L;
                }
            } else {
                if ((mask & 6) == 6) {
                    cost = 2L + rows / 4L;
                    break;
                }
                if ((mask & 2) == 2) {
                    cost = 2L + rows / 3L;
                    break;
                }
                if ((mask & 4) != 4) break;
                cost = rows / 3L;
                break;
            }
            rows = Math.max(rowCount / distinctRows, 1L);
            cost = 2L + rows;
        }
        return cost;
    }

    @Override
    public int compareRows(SearchRow rowData, SearchRow compare) {
        if (rowData == compare) {
            return 0;
        }
        int len = this.indexColumns.length;
        for (int i = 0; i < len; ++i) {
            int index = this.columnIds[i];
            Value v = compare.getValue(index);
            if (v == null) {
                return 0;
            }
            int c = this.compareValues(rowData.getValue(index), v, this.indexColumns[i].sortType);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    boolean containsNullAndAllowMultipleNull(SearchRow newRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int index : this.columnIds) {
                Value v = newRow.getValue(index);
                if (v == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int index : this.columnIds) {
            Value v = newRow.getValue(index);
            if (v != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    int compareKeys(SearchRow rowData, SearchRow compare) {
        long k2;
        long k1 = rowData.getKey();
        if (k1 == (k2 = compare.getKey())) {
            if (this.isMultiVersion) {
                int v1 = rowData.getVersion();
                int v2 = compare.getVersion();
                return MathUtils.compareInt(v2, v1);
            }
            return 0;
        }
        return k1 > k2 ? 1 : -1;
    }

    private int compareValues(Value a, Value b, int sortType) {
        boolean bNull;
        if (a == b) {
            return 0;
        }
        boolean aNull = a == null;
        boolean bl = bNull = b == null;
        if (aNull || bNull) {
            return SortOrder.compareNull(aNull, bNull, sortType);
        }
        int comp = this.table.compareTypeSave(a, b);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    @Override
    public int getColumnIndex(Column col) {
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            if (!this.columns[i].equals(col)) continue;
            return i;
        }
        return -1;
    }

    private String getColumnListSQL() {
        StatementBuilder buff = new StatementBuilder();
        for (IndexColumn c : this.indexColumns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        return buff.toString();
    }

    @Override
    public String getCreateSQLForCopy(Table targetTable, String quotedName) {
        StringBuilder buff = new StringBuilder("CREATE ");
        buff.append(this.indexType.getSQL());
        buff.append(' ');
        if (this.table.isHidden()) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(quotedName);
        buff.append(" ON ").append(targetTable.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append('(').append(this.getColumnListSQL()).append(')');
        return buff.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void commit(int operation, Row row) {
    }

    void setMultiVersion(boolean multiVersion) {
        this.isMultiVersion = multiVersion;
    }

    @Override
    public Row getRow(Session session, long key) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean sortedInsertMode) {
    }
}

