/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.security.PrincipalUtil;
import org.jboss.as.domain.http.server.security.SubjectHttpPrincipal;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.jboss.util.Base64;

public class SpnegoAuthenticator
extends Authenticator {
    private static final Oid[] MECHANISMS;
    private static final String HTTP_PROTOCOL = "HTTP";
    private static final String NEGOTIATE_PREFIX = "Negotiate ";
    private final SecurityRealm securityRealm;
    private final Authenticator wrapped;

    public SpnegoAuthenticator(SecurityRealm securityRealm, Authenticator toWrap) {
        this.securityRealm = securityRealm;
        this.wrapped = toWrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authenticator.Result authenticate(HttpExchange exchange) {
        NegotiationContext context = (NegotiationContext)exchange.getAttribute(NegotiationContext.class.getName(), HttpExchange.AttributeScope.CONNECTION);
        if (context != null && context.isEstablished()) {
            HttpServerLogger.ROOT_LOGGER.trace("Using previously authenticated context.");
            return context.createSuccess(exchange);
        }
        boolean skipSpnego = false;
        SubjectIdentity subjectIdentity = null;
        Headers reqHeaders = exchange.getRequestHeaders();
        String authorization = reqHeaders.getFirst("Authorization");
        if (authorization != null && authorization.startsWith(NEGOTIATE_PREFIX)) {
            List authzHeaders = reqHeaders.remove((Object)"Authorization");
            if (authzHeaders.size() > 1) {
                authzHeaders.remove(0);
                reqHeaders.put("Authorization", authzHeaders);
            }
            HttpServerLogger.ROOT_LOGGER.trace("Processing negotiation response.");
            String base64Header = authorization.substring(NEGOTIATE_PREFIX.length());
            byte[] decoded = Base64.decode((String)base64Header);
            subjectIdentity = this.securityRealm.getSubjectIdentity(HTTP_PROTOCOL, this.getHostName(exchange));
            if (subjectIdentity != null) {
                try {
                    Authenticator.Result result = Subject.doAs(subjectIdentity.getSubject(), new AcceptAction(exchange, decoded));
                    if (result instanceof Authenticator.Success || result instanceof Authenticator.Retry) {
                        Authenticator.Result result2 = result;
                        return result2;
                    }
                    skipSpnego = true;
                }
                finally {
                    subjectIdentity.logout();
                }
            }
        }
        Authenticator.Result result = null;
        if (this.wrapped != null) {
            HttpServerLogger.ROOT_LOGGER.trace("Delegating to wrapped authenticator.");
            result = this.wrapped.authenticate(exchange);
        } else {
            HttpServerLogger.ROOT_LOGGER.trace("No negotiation response, and no wrapped authenticator.");
        }
        if (result instanceof Authenticator.Success || result instanceof Authenticator.Failure) {
            return result;
        }
        if (!skipSpnego) {
            Headers respHeaders = exchange.getResponseHeaders();
            String host = this.getHostName(exchange);
            subjectIdentity = this.securityRealm.getSubjectIdentity(HTTP_PROTOCOL, host);
            if (subjectIdentity != null) {
                subjectIdentity.logout();
                ArrayList<String> values = respHeaders.remove((Object)"WWW-Authenticate");
                if (values == null) {
                    HttpServerLogger.ROOT_LOGGER.trace("No existing WWW-Authenticate header");
                    values = new ArrayList<String>(1);
                }
                HttpServerLogger.ROOT_LOGGER.trace("Adding Negotiate challenge");
                values.add(0, "Negotiate");
                respHeaders.put("WWW-Authenticate", values);
                return new Authenticator.Retry(401);
            }
            HttpServerLogger.ROOT_LOGGER.tracef("No Subject available for host '%s'", host);
        }
        if (result != null) {
            return result;
        }
        return new Authenticator.Failure(403);
    }

    private String getHostName(HttpExchange exchange) {
        String hostName = exchange.getRequestHeaders().getFirst("Host");
        if (hostName != null) {
            if (hostName.contains(":")) {
                hostName = hostName.substring(0, hostName.indexOf(":"));
            }
            return hostName;
        }
        return null;
    }

    static {
        try {
            Oid spnego = new Oid("1.3.6.1.5.5.2");
            Oid kerberos = new Oid("1.2.840.113554.1.2.2");
            MECHANISMS = new Oid[]{spnego, kerberos};
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }

    private class NegotiationContext {
        private GSSContext gssContext;
        private Authenticator.Success success;

        private NegotiationContext() {
        }

        public GSSContext getGssContext() {
            return this.gssContext;
        }

        public void setGssContext(GSSContext gssContext) {
            this.gssContext = gssContext;
        }

        public boolean isEstablished() {
            return this.gssContext != null && this.gssContext.isEstablished();
        }

        private Authenticator.Result createSuccess(HttpExchange exchange) {
            Authenticator.Failure response;
            assert (this.isEstablished());
            if (this.success != null) {
                HttpServerLogger.ROOT_LOGGER.trace("Returning existing Success and identity");
                return this.success;
            }
            try {
                String name = ((Object)this.gssContext.getSrcName()).toString();
                SubjectHttpPrincipal shp = new SubjectHttpPrincipal(name, SpnegoAuthenticator.this.securityRealm.getName());
                this.success = new Authenticator.Success((HttpPrincipal)shp);
                response = this.success;
                HashSet<SubjectHttpPrincipal> principalCol = new HashSet<SubjectHttpPrincipal>();
                principalCol.add(shp);
                AuthorizingCallbackHandler ach = SpnegoAuthenticator.this.securityRealm.getAuthorizingCallbackHandler(AuthenticationMechanism.KERBEROS);
                AuthorizeCallback ac = new AuthorizeCallback(name, name);
                ach.handle(new Callback[]{ac});
                if (!ac.isAuthorized()) {
                    HttpServerLogger.ROOT_LOGGER.debugf("Callback handler denied authorization for '%s'", name);
                    response = new Authenticator.Failure(500);
                }
                SubjectUserInfo userInfo = ach.createSubjectUserInfo(principalCol);
                Subject subject = userInfo.getSubject();
                PrincipalUtil.addInetPrincipal(exchange, subject.getPrincipals());
                shp.setSubject(subject);
            }
            catch (GSSException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unable to create SubjectUserInfo", e);
                response = new Authenticator.Failure(500);
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unable to create SubjectUserInfo", e);
                response = new Authenticator.Failure(500);
            }
            catch (UnsupportedCallbackException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unable to perform authorization check", e);
                response = new Authenticator.Failure(500);
            }
            return response;
        }
    }

    private class AcceptAction
    implements PrivilegedAction<Authenticator.Result> {
        private final HttpExchange exchange;
        private final byte[] request;

        private AcceptAction(HttpExchange exchange, byte[] request) {
            this.exchange = exchange;
            this.request = request;
        }

        @Override
        public Authenticator.Result run() {
            NegotiationContext context = (NegotiationContext)this.exchange.getAttribute(NegotiationContext.class.getName(), HttpExchange.AttributeScope.CONNECTION);
            if (context == null) {
                HttpServerLogger.ROOT_LOGGER.trace("Creating new NegotiationContext");
                context = new NegotiationContext();
                this.exchange.setAttribute(NegotiationContext.class.getName(), (Object)context, HttpExchange.AttributeScope.CONNECTION);
            }
            assert (!context.isEstablished());
            GSSContext gssContext = context.getGssContext();
            try {
                byte[] respToken;
                if (gssContext == null) {
                    HttpServerLogger.ROOT_LOGGER.trace("Creating new GSSContext");
                    GSSManager manager = GSSManager.getInstance();
                    GSSCredential credential = manager.createCredential(null, Integer.MAX_VALUE, MECHANISMS, 2);
                    gssContext = manager.createContext(credential);
                    context.setGssContext(gssContext);
                }
                if ((respToken = gssContext.acceptSecContext(this.request, 0, this.request.length)) != null) {
                    HttpServerLogger.ROOT_LOGGER.trace("Sending response token");
                    Headers respHeaders = this.exchange.getResponseHeaders();
                    respHeaders.add("WWW-Authenticate", SpnegoAuthenticator.NEGOTIATE_PREFIX + Base64.encodeBytes((byte[])respToken, (int)8));
                }
                if (context.isEstablished()) {
                    return context.createSuccess(this.exchange);
                }
                return new Authenticator.Retry(401);
            }
            catch (GSSException e) {
                HttpServerLogger.ROOT_LOGGER.trace("Unable to authenticate user.", e);
                return new Authenticator.Failure(403);
            }
        }
    }
}

