/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.ServerLogger;
import org.jboss.dmr.ModelNode;

class ContentRepositoryCleaner {
    private final ModelControllerClient client;
    private final ControlledProcessStateService controlledProcessStateService;
    private final ScheduledExecutorService scheduledExecutor;
    private long cleanInterval = 0L;
    private volatile boolean enabled;
    private final boolean server;
    private ScheduledFuture<?> cleanTask;
    private final ContentRepositoryCleanerTask cleanRunnable = new ContentRepositoryCleanerTask();

    public ContentRepositoryCleaner(ModelControllerClient client, ControlledProcessStateService controlledProcessStateService, ScheduledExecutorService scheduledExecutor, long interval, boolean server) {
        this.controlledProcessStateService = controlledProcessStateService;
        this.client = client;
        this.scheduledExecutor = scheduledExecutor;
        this.enabled = true;
        this.cleanInterval = interval;
        this.server = server;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getCleanInterval() {
        return this.cleanInterval;
    }

    private void cancelScan() {
        if (this.cleanTask != null) {
            this.cleanTask.cancel(true);
            this.cleanTask = null;
        }
        try {
            this.client.close();
        }
        catch (IOException ex) {
            ServerLogger.ROOT_LOGGER.failedToStopRepositoryCleaner(ex);
        }
    }

    synchronized void startScan() {
        if (this.enabled) {
            this.cleanTask = this.scheduledExecutor.scheduleWithFixedDelay(this.cleanRunnable, this.cleanInterval, this.cleanInterval, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void stopScan() {
        this.enabled = false;
        this.cancelScan();
    }

    void cleanObsoleteContent() {
        if (this.controlledProcessStateService.getCurrentState() == ControlledProcessState.State.RUNNING) {
            try {
                ModelNode response;
                PathAddress address = PathAddress.EMPTY_ADDRESS;
                if (!this.server) {
                    response = this.client.execute(Util.getReadAttributeOperation((PathAddress)PathAddress.EMPTY_ADDRESS, (String)"local-host-name"));
                    if ("success".equals(response.get("outcome").asString()) && response.get("result").isDefined()) {
                        address = address.append("host", response.get("result").asString());
                    } else {
                        if ("cancelled".equals(response.get("outcome").asString())) {
                            return;
                        }
                        if ("failed".equals(response.get("outcome").asString())) {
                            this.error(response);
                        }
                    }
                }
                if ("success".equals((response = this.client.execute(Util.createOperation((String)"clean-obsolete-content", (PathAddress)address))).get("outcome").asString())) {
                    if (response.get("result").isDefined()) {
                        ServerLogger.ROOT_LOGGER.debug(response.get("result"));
                    }
                } else {
                    if ("cancelled".equals(response.get("outcome").asString())) {
                        return;
                    }
                    if ("failed".equals(response.get("outcome").asString())) {
                        this.error(response);
                    }
                }
            }
            catch (IOException e) {
                ServerLogger.ROOT_LOGGER.failedToCleanObsoleteContent(e);
            }
        }
    }

    private void error(ModelNode response) {
        if (response.hasDefined("failure-description")) {
            ServerLogger.ROOT_LOGGER.failedToCleanObsoleteContent(response.get("failure-description").asString());
        } else {
            ServerLogger.ROOT_LOGGER.failedToCleanObsoleteContent(response.asString());
        }
    }

    private class ContentRepositoryCleanerTask
    implements Runnable {
        private ContentRepositoryCleanerTask() {
        }

        @Override
        public void run() {
            ContentRepositoryCleaner.this.cleanObsoleteContent();
        }
    }
}

